<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <form class="ui form" action="" method="post">
      <h2 class="ui dividing header">Edit Student Registration</h2>
      <div class="field">
        <input type="hidden" name="_method" value="put">
        <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" <?php if(!empty(old('surname'))): ?>
              value="<?php echo e(old('surname')); ?>"
            <?php else: ?>
              value="<?php echo e($student->surname); ?>"
            <?php endif; ?> placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" <?php if(!empty(old('firstname'))): ?>
              value="<?php echo e(old('firstname')); ?>"
            <?php else: ?>
              value="<?php echo e($student->firstname); ?>"
            <?php endif; ?> placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" <?php if(!empty(old('middlename'))): ?>
              value="<?php echo e(old('middlename')); ?>"
            <?php else: ?>
              value="<?php echo e($student->middlename); ?>"
            <?php endif; ?> placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"   <?php if(!empty(old('dob'))): ?>
                value="<?php echo e(old('dob')); ?>"
              <?php else: ?>
                value="<?php echo e($student->dob); ?>"
              <?php endif; ?>>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"    <?php if(!empty(old('gender'))): ?>
                  value="<?php echo e(old('gender')); ?>"
                <?php else: ?>
                  value="<?php echo e($student->gender); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country"     <?php if(!empty(old('country'))): ?>
                  value="<?php echo e(old('country')); ?>"
                <?php else: ?>
                  value="<?php echo e($student->country); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Student House</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="house_id"  <?php if(!empty(old('house_id'))): ?>
                  value="<?php echo e(old('house_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($student->house_id); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Student House</div>
              <div class="menu">
                <?php $__empty_1 = true; foreach($school_houses as $school_house): $__empty_1 = false; ?>
                 <div class="item" data-value="<?php echo e($school_house->id); ?>"><?php echo e($school_house->name); ?></div>
                <?php endforeach; if ($__empty_1): ?>
                  <div class="item">School house has not been created</div>
                <?php endif; ?>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="seven wide field">
          <label>Contact Address</label>
            <input type="text" name="address"  <?php if(!empty(old('address'))): ?>
                  value="<?php echo e(old('address')); ?>"
                <?php else: ?>
                  value="<?php echo e($student->address); ?>"
                <?php endif; ?> placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id"     <?php if(!empty(old('state_id'))): ?>
                  value="<?php echo e(old('state_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($student->state_id); ?>"
                <?php endif; ?> data-href="<?php echo e(url('/do-ajax/state')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                <?php foreach($ngstates as $ngstate): ?>
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id"   <?php if(!empty(old('lga_id'))): ?>
                value="<?php echo e(old('lga_id')); ?>"
              <?php else: ?>
                value="<?php echo e($student->lga_id); ?>"
              <?php endif; ?>
              >
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  <?php if(!empty(old('state_id'))): ?>
                    <?php foreach(getStateLGAs(old('state_id')) as $ngstateLGA): ?>
                     <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <?php foreach(getStateLGAs($student->state_id) as $ngstateLGA): ?>
                     <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                  <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="three wide field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" <?php if(!empty(old('blood_group'))): ?> 
            value="<?php echo e(old('blood_group')); ?>"
            <?php else: ?>
            value="<?php echo e($student->blood_group); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
                 <div class="item" data-value="Unavailable">Unavailable</div>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion"   <?php if(!empty(old('religion'))): ?>
                value="<?php echo e(old('religion')); ?>"
              <?php else: ?>
                value="<?php echo e($student->religion); ?>"
              <?php endif; ?>
              ">
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone"   <?php if(!empty(old('phone'))): ?>
                value="<?php echo e(old('phone')); ?>"
              <?php else: ?>
                value="<?php echo e($student->phone); ?>"
              <?php endif; ?> placeholder="Student's Phone Number">
          </div>

          <div class="four wide field">
          <label>Student's Password</label>
            <input type="password" name="password" placeholder="Student's Password">
          </div>
          <div class="four wide field">
            <label>Student's Confirm Password</label>
            <input type="password" name="password_confirmation" placeholder="Student's Confirm Password">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname"   <?php if(!empty(old('parent_fullname'))): ?>
                value="<?php echo e(old('parent_fullname')); ?>"
              <?php else: ?>
                value="<?php echo e($student->parent_fullname); ?>"
              <?php endif; ?> placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address"   <?php if(!empty(old('parent_address'))): ?>
                value="<?php echo e(old('parent_address')); ?>"
              <?php else: ?>
                value="<?php echo e($student->parent_address); ?>"
              <?php endif; ?>
              " placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email"   <?php if(!empty(old('parent_email'))): ?>
                value="<?php echo e(old('parent_email')); ?>"
              <?php else: ?>
                value="<?php echo e($student->parent_email); ?>"
              <?php endif; ?> placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone"   <?php if(!empty(old('parent_phone'))): ?>
                value="<?php echo e(old('parent_phone')); ?>"
              <?php else: ?>
                value="<?php echo e($student->parent_phone); ?>"
              <?php endif; ?> placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Student Academic Information</h4>
        <div class="four fields">
          <div class="field">
            <label>Session</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="session"   <?php if(!empty(old('session'))): ?>
                value="<?php echo e(old('session')); ?>"
              <?php else: ?>
                value="<?php echo e($student->session); ?>"
              <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Session</div>
              <div class="menu">
                <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
                 <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
                <?php endfor; ?>
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Term</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="term"   <?php if(!empty(old('term'))): ?>
                value="<?php echo e(old('term')); ?>"
              <?php else: ?>
                <?php if(!empty($student_class->pivot->term)): ?>
                value="<?php echo e($student_class->pivot->term); ?>"
                <?php endif; ?>
              <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Term</div>
              <div class="menu">
                 <div class="item" data-value="First"> First Term </div>
                 <div class="item" data-value="Second"> Second Term </div>
                 <div class="item" data-value="Third"> Third Term </div>
              </div>
            </div>
          </div>
          
          <div class="field">
            <label>Class</label>
            <div class="ui fluid search selection dropdown" id="classes-dropdown">
              <input type="hidden" name="class_id"   <?php if(!empty(old('class_id'))): ?>
                value="<?php echo e(old('class_id')); ?>"
              <?php else: ?>
                <?php if(!empty($student_class->pivot->class_id)): ?>
                value="<?php echo e($student_class->pivot->class_id); ?>"
                <?php endif; ?>
              <?php endif; ?> data-href="<?php echo e(url('/do-ajax/class')); ?>" >
              <i class="dropdown icon"></i>
              <div class="default text">Class</div>
              <div class="menu">
                <?php foreach($classes as $class): ?>
                 <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-arms">
            <label>Class Arm</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="class_arm_id" <?php if(!empty(old('class_arm_id'))): ?>
                value="<?php echo e(old('class_arm_id')); ?>"
              <?php else: ?>
                <?php if(!empty($student_class->pivot->classarm_id)): ?>
                value="<?php echo e($student_class->pivot->classarm_id); ?>"
                <?php endif; ?>
              <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Class Arm</div>
              <div class="menu" id="class-arms">
                  <?php if(!empty(old('class_id'))): ?>
                    <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
                     <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                    <?php if(!empty($student_class->pivot->class_id)): ?>
                      <?php foreach(getClassArms($student_class->pivot->class_id) as $class_arm): ?>
                     <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                      <?php endforeach; ?>
                    <?php endif; ?>
                  <?php endif; ?>
                
              </div>
            </div>
          </div>


        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Student</button>
      
  </form>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>