<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <form class="ui form" action="<?php echo e(route('admin.register.school.students')); ?>" method="post">
      <h2 class="ui dividing header">Student Registration</h2>
      <div class="field">
        <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" value="<?php echo e(old('_token')); ?>">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" value="<?php echo e(old('surname')); ?>" placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" value="<?php echo e(old('firstname')); ?>" placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" value="<?php echo e(old('middlename')); ?>" placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob" value="<?php echo e(old('dob')); ?>">
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender" value="<?php echo e(old('gender')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country" value="<?php echo e(old('country')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Student House</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="house_id" value="<?php echo e(old('house_id')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Student House</div>
              <div class="menu">
                <?php $__empty_1 = true; foreach($school_houses as $school_house): $__empty_1 = false; ?>
                 <div class="item" data-value="<?php echo e($school_house->id); ?>"><?php echo e($school_house->name); ?></div>
                <?php endforeach; if ($__empty_1): ?>
                  <div class="item">School house has not been created</div>
                <?php endif; ?>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="seven wide field">
          <label>Contact Address</label>
            <input type="text" name="address" value="<?php echo e(old('address')); ?>" placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" value="<?php echo e(old('state_id')); ?>" data-href="<?php echo e(url('/do-ajax/state')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                <?php foreach($ngstates as $ngstate): ?>
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  <?php if(!empty(old('state_id'))): ?>
                    <?php foreach(getStateLGAs(old('state_id')) as $ngstateLGA): ?>
                     <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Select State LGA</div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="three wide field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" value="<?php echo e(old('blood_group')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
                 <div class="item" data-value="Unavailable">Unavailable</div>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion" value="<?php echo e(old('religion')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="Student's Phone Number">
          </div>

          <div class="four wide field">
          <label>Student's Password</label>
            <input type="password" name="password" placeholder="Student's Password">
          </div>
          <div class="four wide field">
            <label>Student's Confirm Password</label>
            <input type="password" name="password_confirmation" placeholder="Student's Confirm Password">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname" value="<?php echo e(old('parent_fullname')); ?>" placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address" value="<?php echo e(old('parent_address')); ?>" placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email" value="<?php echo e(old('parent_email')); ?>" placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone" value="<?php echo e(old('parent_phone')); ?>" placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Student Academic Information</h4>
        <div class="four fields">
          <div class="field">
            <label>Session</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="session" value="<?php echo e(old('session')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Session</div>
              <div class="menu">
                <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
                 <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
                <?php endfor; ?>
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Term</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="term" value="<?php echo e(old('term')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Term</div>
              <div class="menu">
                 <div class="item" data-value="First"> First Term </div>
                 <div class="item" data-value="Second"> Second Term </div>
                 <div class="item" data-value="Third"> Third Term </div>
              </div>
            </div>
          </div>
          
          <div class="field">
            <label>Class</label>
            <div class="ui fluid search selection dropdown" id="classes-dropdown">
              <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>" >
              <i class="dropdown icon"></i>
              <div class="default text">Class</div>
              <div class="menu">
                <?php foreach($classes as $class): ?>
                 <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-arms">
            <label>Class Arm</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="class_arm_id" value="<?php echo e(old('class_arm_id')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Class Arm</div>
              <div class="menu" id="class-arms">
                <?php if(!empty(old('class_id'))): ?>
                    <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
                     <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Select Class Arm</div>
                  <?php endif; ?>
                
              </div>
            </div>
          </div>


        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Student</button>
      
  </form>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>