<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<form class="ui form" action="<?php echo e(route('user.view.school.users.post')); ?>" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		  <h2 class="ui dividing header">Search User</h2>
		  <div class="two fields">

	      <div class="field">
	        <label>Users</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="id" value="<?php echo e(old('id')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Users</div>
	          <div class="menu">
	          <?php foreach($all_admin as $admin): ?>
				<div class="item" data-value="<?php echo e($admin->id); ?>"><?php echo e($admin->fullname); ?></div>
	          <?php endforeach; ?>
	          </div>
	        </div>
	      </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Admin</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View School Admin Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Username</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">User's Permissions</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Users</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($admins) > 0): ?>
		  <?php  $counter = 0  ?>
		  	<?php foreach($admins as $admin): ?>
		    <tr>
		      <td style="vertical-align: top;"><?php echo e(++$counter); ?></td>
		      <td valign="top"><?php echo e($admin->fullname); ?></td>
		      <td valign="top"><?php echo e($admin->username); ?></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php foreach(getAdminAssocPermissions($admin->id) as $a_p): ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($a_p->permission); ?></p>
				    </div>
				</div>
		      	<?php endforeach; ?>
		      	</div>
		      </td>
		      <td class="std-view" valign="top">
		      <?php if(auth('admin')->user()->can('edit-user')): ?>
			      <button class="ui labeled blue icon button" data-std-id="<?php echo e($admin->id); ?>" data-href="<?php echo e(route('admin.edit.school.user', ['id' => $admin->id])); ?>">
				  <i class="edit icon"></i>
				  Edit
				</button>
			<?php endif; ?>
			  </td>
		      <td class="std-view" valign="top">
		      <?php if(auth('admin')->user()->can('delete-user')): ?>
				<button class="ui labeled negative icon button" data-std-id="<?php echo e($admin->id); ?>" data-href="<?php echo e(route('admin.delete.school.user', ['id' => $admin->id])); ?>">
				  <i class="trash icon"></i>
				  Delete
				</button>
			 <?php endif; ?>
		      </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      <?php echo $__env->make('pagination.default', ['paginator' => $admins], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>