<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
			Class Arm Student Movement
		</h2>
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	  <form id="form_unique_id" action="" method="post" class="ui form">

	    <div class="form-group">
	        <label class="control-label">Choose Class Arm to Move Student (<?php echo e($class_name); ?>)</label>
	        <div class="field">
	            <select name="to_classarm_id" id="to_classarm_id" required class="ui dropdown">
	                <option value="">Select Class Arm</option>
	                  <?php foreach($other_classarms as $class_arm): ?>
	                      <option value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></option>
	                  <?php endforeach; ?>
	            </select>
	        </div>
	    </div>

	  	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  	<input type="hidden" name="session" value="<?php echo e(!empty(old('session')) ? old('session') : $session); ?>">
	  	<input type="hidden" name="class_id" value="<?php echo e(!empty(old('class_id')) ? old('class_id') : $class_id); ?>">
	  	<input type="hidden" name="from_classarm_id" value="<?php echo e(!empty(old('classarm_id')) ? old('classarm_id') : $classarm_id); ?>">
	  	<input type="hidden" name="term" value="<?php echo e(!empty(old('term')) ? old('term') : $term); ?>">

		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th >
		    	<div class="ui ribbon label">Select Students</div>
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($classarm_students) > 0): ?>
		  	<?php foreach($classarm_students as $student): ?>
		  	<?php 
		  		$promotion = getStudentResultPromotion($student->id, $classarm_id, $class_id, $term, $session);
		  	 ?>
		    <tr>
		      <td><?php echo e($student->surname.' '.$student->firstname.' '.$student->middlename); ?></td>
		      <td><?php echo e($student->regnum); ?></td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_ids[]" value="<?php echo e($student->id); ?>"><label></label>
				</div>
			  </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		</table>
        
    <input type="button" class="ui small blue button" id="form_submit" name="form_submit" value="Process & Save" />
	</form>
	</section>


<script>
var site_url = "<?php echo e(url('/admin')); ?>";
var token = "<?php echo e(csrf_token()); ?>";
var ajax_loader = "<?php echo e(url_public('/images/ajax-loader.gif')); ?>";

$("#form_submit").on('click', function() {
///// START: SUBMIT /////

    var formArray = $('form#form_unique_id').serializeArray();

    $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
    $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
    $("#pagewrap_ajax_box").show('slow');          
    $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
    window.oncontextmenu = function(){return false;}    // Disable right click  
    $("input").prop('disabled', true);                 // Disable form input
    $("select").prop('disabled', true);                    // Disable form input 

    $.ajax({
        url :   site_url+"/classarm/reassign/students-ajax-process",
        type :  "POST",
        data :  formArray,
        dataType: "json",
        cache :     false
    })
    .done(function(resp){   
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input       

        if(resp.type === "error"){
            alert(resp.value);
        }
        else if(resp.type === "okay"){
            alert(resp.value);
            window.location.href = site_url+"/classarm/reassign/view-students"; 
        }
        else{
            alert('Invalid callback response. Pls try again shortly'); 
        }

        })
    .fail(function(){
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input 

        alert('Error encountered while processing request. Pls try again shortly');  
    }); 

/*    var session = $("input[name=session]").val();
    var class_id = $("input[name=class_id]").val();
    var classarm_id = $("input[name=classarm_id]").val();
    var term = $("input[name=term]").val();

    var student_ids = [];

    $("input[name='student_ids']:checked").each(function(){
    	student_ids.push(this.value);
    });

        var form_data = {
            session : session,
            class_id : class_id,
            classarm_id : classarm_id,
            term : term,
            student_ids : student_ids,
            _token : token
        }
*/

///// END: SUBMIT /////
});

</script>
	
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>