<?php $__env->startSection('content'); ?>
	<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
	    <h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School
		</h2>
		
		<div class="search-bar">
			<div class="ui stackable equal height stackable grid">
				<div class="seven wide column">
					<form method="get" action="" class="form form-horizontal global_form">
							<div class="ui left action input fluid">
									<button class="ui orange labeled icon button">
											<i class="search icon"></i>
											Search KEYWORD:
									</button>
									<input type="text" placeholder="Enter keyword..." name="name_keyword" value="">
							</div>
					</form>
				</div>
				<div class="two wide column">
					<h2 class="ui horizontal divider header" style="margin-top: 8px;color:#dc4900;text-align: center;">Or</h2>
				</div>
				<div class="seven wide column">
					<form method="get" action="" class="form form-horizontal global_form">
							<div class="second">
									<div class="fields">
											<div class="sixteen wide field">
													<div class="ui left action input fluid">
															<button class="ui orange labeled icon button">
																	<i class="search icon"></i>
																	Search with LGA:
															</button>
															<select name="lga_keyword" class="ui search fluid dropdown">
																<option value="">Choose LGA</option>
																<?php if($item_rows = DB::table('ondo_lgas')->get()): ?>
																		<?php foreach($item_rows as $item_data): ?>
																		<option value="<?php echo e($item_data->id); ?>"><?php echo e($item_data->name); ?></option>
																		<?php endforeach; ?>
																<?php endif; ?>
														</select>
													</div>
											</div>
									</div>
							</div>
					</form>
				</div>
			</div>
		</div>
		<table class="ui celled table">
		  <thead>
		        <tr>
    			  	<th>
    			    	<div class="ui ribbon label">School name</div>
    			    </th>
    			    <th>
    			    	<div class="ui ribbon label">School LGA</div>
    			    </th>
    			    <th>
    			    	<div class="ui ribbon label">Pending Requests</div>
    			    </th>
    			    <th>
    			    	<div class="ui ribbon label">Approved Requests</div>
    			    </th>
    			    <th colspan="2">
    			    	<div class="ui ribbon label">Action on School</div>
    			    </th>
			    </tr>
		  </thead>
		  <tbody>
		  <?php if(count($schools) > 0): ?>
		  	<?php foreach($schools as $school): ?>
		    <tr>
		      <td><?php echo e($school->name); ?></td>
		      <td><?php echo e($school->ondo_lga->name); ?></td>
		      <td><?php echo e(App\StudentIDCardRequest::where('is_verified', false)->where('school_id', $school->id)->get()->count()); ?> pending</td>
		      <td><?php echo e(App\StudentIDCardRequest::where('is_verified', true)->where('school_id', $school->id)->get()->count()); ?> approved</td>
		      <td class="">
			    <a href="<?php echo e(route('super_admin.school.id-card-request', $school->id)); ?>">
			        <button class="ui blue button">
    				  View ID Card Requests
    				</button>
    			</a>
			  </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      <?php echo $__env->make('pagination.default', ['paginator' => $schools], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>