<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<form class="ui form" action="<?php echo e(route('admin.view.search.school.houses')); ?>" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		  <h2 class="ui dividing header">Search Class</h2>
		  <div class="two fields">
	      
	      <div class="field">
	          <label>School Houses</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="house_id" value="<?php echo e(old('house_id')); ?>">
	            <i class="dropdown icon"></i>
	            <div class="default text">Class</div>
	            <div class="menu">
	              <?php foreach($all_school_houses as $school_house): ?>
	               <div class="item" data-value="<?php echo e($school_house->id); ?>"><?php echo e($school_house->name); ?></div>
	              <?php endforeach; ?>
	            </div>
	          </div>
	        </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View School House</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School House Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School House</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">House Master</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Students Assign to House</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on school House</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if($school_houses->count() > 0): ?>
			<?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $school_houses->perPage()  ?>
		  	<?php foreach($school_houses as $school_house): ?>
		    <tr>
		      <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($school_house->name); ?></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php $__empty_1 = true; foreach($school_house->teachers as $teacher): $__empty_1 = false; ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></p>
				    </div>
				</div>
				<?php endforeach; if ($__empty_1): ?>
				<div class="ui icon negative message">
				  <div class="content">
				    <div class="header">
				    Sorry, No Record can be found.
				  	</div>
				  </div>
				 </div>
		      	<?php endif; ?>
		      	</div>
		      </td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php $__empty_1 = true; foreach($school_house->teachers as $teacher): $__empty_1 = false; ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></p>
				    </div>
				</div>
				<?php endforeach; if ($__empty_1): ?>
				<div class="ui icon negative message">
				  <div class="content">
				    <div class="header">
				    Sorry, No Record can be found.
				  	</div>
				  </div>
				 </div>
		      	<?php endif; ?>
		      	</div>
		      </td>
		      <td class="std-view">
		      <?php if(auth('admin')->user()->can('edit-school-house')): ?>
			      <button class="ui labeled blue icon button" data-std-id="<?php echo e($school_house->id); ?>" data-href="<?php echo e(route('admin.edit.school.house', ['id' => $school_house->id])); ?>">
				  <i class="edit icon"></i>
				  Edit
				</button>
				<?php endif; ?>
			  </td>
		      <td class="std-view">
		      <?php if(auth('admin')->user()->can('delete-school-house')): ?>
				<button class="ui labeled negative icon button" data-std-id="<?php echo e($school_house->id); ?>" data-href="<?php echo e(route('admin.delete.school.house', ['id' => $school_house->id])); ?>">
				  <i class="trash icon"></i>
				  Delete
				</button>
				<?php endif; ?>
		      </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="4">
		      <?php echo $__env->make('pagination.default', ['paginator' => $school_houses], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>