<?php $__env->startSection('content'); ?>
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th>Students' Name and Results</th>
        </tr>
      </thead>
      <tbody>

       <?php foreach($students_practical_character_info as $key => $student_results): ?>
        <tr>
          <td>
            <table class="ui celled table" >
              <thead>
                <tr>
                    <th colspan="4"><?php echo e(getStudentFullnameByStudentID($key)); ?></th>
                    <th colspan="3"><?php echo e(getRegNumByStudentID($key)); ?></th>
                </tr>
                <tr>
                    <th colspan="7">Practical Skills</th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              <?php if((count($student_results['practical_skill']['data']) > 0) && (count($student_results['characters']['data']) > 0)): ?>
                  <?php foreach($student_results['practical_skill']['data'] as  $practical_skill): ?>
                    <td>
                       <table class="inner-table">
                         <tr><td>Hand Writing</td></tr>
                         <tr><td><?php echo e($practical_skill->hand_writing); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Music</td></tr>
                         <tr><td><?php echo e($practical_skill->music); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Drama</td></tr>
                         <tr><td><?php echo e($practical_skill->drama); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Craft</td></tr>
                         <tr><td><?php echo e($practical_skill->craft); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Club Societies</td></tr>
                         <tr><td><?php echo e($practical_skill->club_societies); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Hobbies</td></tr>
                         <tr><td><?php echo e($practical_skill->hobbies); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Sports</td></tr>
                         <tr><td><?php echo e($practical_skill->sports); ?></td></tr>
                       </table>
                    </td>
                  <?php endforeach; ?>
                </tr>
              </tbody>
              <thead>
                <tr>
                    <th colspan="5">Character Development</th>
                    <th colspan="2">ACTIONS</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <?php foreach($student_results['characters']['data'] as  $characters): ?>
                    <td>
                       <table class="inner-table">
                         <tr><td>Attentive Class</td></tr>
                         <tr><td><?php echo e($characters->attentive_class); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Neatness</td></tr>
                         <tr><td><?php echo e($characters->neatness); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Self Control</td></tr>
                         <tr><td><?php echo e($characters->self_control); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Punctuality</td></tr>
                         <tr><td><?php echo e($characters->punctuality); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Politeness</td></tr>
                         <tr><td><?php echo e($characters->politeness); ?></td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Realationship with Others</td></tr>
                         <tr><td><?php echo e($characters->relationship_others); ?></td></tr>
                       </table>
                    </td>
                  <?php endforeach; ?>
                    <td class="std-view"> 
                    <?php if(auth('admin')->user()->can('edit-student-remarks')): ?>
                      <button class="ui labeled blue icon button" data-std-id="<?php echo e($key); ?>" data-href="<?php echo e(route('admin.edit.student.practical.attitude', ['id' => $key, 'session' => $session, 'term' => $term, 'class_id' => $class_id, 'classarm_id' => $classarm_id_get])); ?>" data-item="<?php echo e(getStudentFullnameByStudentID($key).'\'s Practical Skills and Character Development'); ?>">
                          <i class="edit icon"></i> Edit
                      </button>
                      <hr>
                      <?php endif; ?>
                      <?php if(auth('admin')->user()->can('delete-student-remarks')): ?>
                      <button class="ui labeled negative icon button" data-std-id="<?php echo e($key); ?>" data-href="<?php echo e(route('admin.delete.student.practical.attitude', ['id' => $key])); ?>" data-item="<?php echo e(getStudentFullnameByStudentID($key).'\'s Practical Skills and Character Development'); ?>">
                          <i class="trash icon"></i> Delete
                      </button>
                      <?php endif; ?>
                    </td>

                <?php else: ?>
                    <td colspan="7">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                <?php endif; ?>
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        <?php endforeach; ?>

      </tbody>
    </table>
</div>
</section>
<div class="jtr"></div>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <input type="hidden" name="_method" value="delete">
        <input type="hidden" name="session" value="<?php echo e($session); ?>">
        <input type="hidden" name="class_id" value="<?php echo e($class_id); ?>">
        <input type="hidden" name="classarm_id" value="<?php echo e($classarm_id_get); ?>">
        <input type="hidden" name="term" value="<?php echo e($term); ?>">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>