<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<form class="ui form" action="<?php echo e(route('admin.register.school.classarms')); ?>" method="post">
  <h2 class="ui dividing header">Class Registration <?php echo e(auth('admin')->user()->school_id); ?></h2>
  <div class="field">
    <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" value="<?php echo e(old('_token')); ?>">
    
    <div class="three fields">
      <div class="field">
        <label>Class</label>
        <div class="ui fluid search selection dropdown" id="classes-dropdown">
          <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>">
          <i class="dropdown icon"></i>
          <div class="default text">Class</div>
          <div class="menu">
            <?php foreach($classes as $class): ?>
             <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <div class="field">
      <label>Class Arm Name</label>
        <input type="text" name="class_arm_name" value="<?php echo e(old('class_arm_name')); ?>" placeholder="Class Name">
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Register Class Arm</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui dividing header">Available Classes and Class Arms</h2>
<?php if($all_classarms->count() > 0): ?>
  <div class="ui tag labels">
  <?php foreach($all_classarms as $key => $classarm): ?>
  <?php if(!empty(getClassNameByClassID($classarm->class_id))): ?>
  <a class="ui <?php echo e(getDynamicColorByKey($key)); ?> label">
    <?php echo e(getClassNameByClassID($classarm->class_id)); ?> <?php echo e($classarm->class_arm); ?>

  </a>
  <?php endif; ?>

  <?php endforeach; ?>
</div>
<?php else: ?>
<?php endif; ?>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>