
<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	<div class="msg-bag"></div>
	<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School Admin
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    	<th>
		    		<div class="ui ribbon label">S/N</div>
		    	</th>
			  	<th>
			    	<div class="ui ribbon label">School Admin</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Name</div>
			    </th>
			     <th>
			    	<div class="ui ribbon label">School Username</div>
			    </th>
			    <th colspan="2">
			    	<div class="ui ribbon label">Actions on School Admin</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <tr>
		  	<th colspan="6"><a href="<?php echo e(route('super_admin.create.school.admin')); ?>" class="ui orange fluid button">Create School Admin</a></th>
		  </tr>
		  <?php if($school_admins->count() > 0): ?>
		  <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $school_admins->perPage()  ?>
		  	<?php foreach($school_admins as $school_admin): ?>
		    <tr>
		      <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($school_admin->fullname); ?></td>
		      <td>
		      <?php if(getSchools($school_admin->school_id)->count() > 0): ?>
		      	<div class="item"><p><?php echo e(getSchoolName($school_admin->school_id)); ?></p></div>
		      <?php else: ?>
		      	<div class="ui negative message">
		      		<p>Sorry, School has not been created</p>
		      	</div>
		      <?php endif; ?>
		      </td>
		      <td><?php echo e($school_admin->username); ?></td>
		      <td class="std-view">
			      <button class="ui labeled blue icon button editPermission" user-name="<?php echo e($school_admin->fullname); ?>" user-id="<?php echo e($school_admin->id); ?>">
				  <i class="edit icon" ></i>
				  Edit Permissions
				</button>
		      </td>
			    </tr>
			   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      <?php echo $__env->make('pagination.default', ['paginator' => $school_admins], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<!-- modals -->
	<form class="ui long modal">
	  <!-- <i class="close icon"></i> -->
	  <div class="header">
	  </div>
	  <div class="image content" style="height: 70vh;">
	    <div class="image">
	      Available Permissions
	    </div>
	    <div class="description ui grid">
	      <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	    <div style="display: none;" class="ui approve blue button">Update</div>
	  </div>
	</form>

	<div class="jtr"></div>


	<?php echo $__env->make('super-admin.permissions.select', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<script type="text/javascript">
	$(document).ready(function(){
        $('.editPermission').click(function(){
        	var modal = $('.ui.modal');
        	var name = $(this).attr('user-name');
        	var id = $(this).attr('user-id');
        	modal.find('.header').html("Edit "+name.toLowerCase()+"'s permissions");
        	modal.find('.description').html('<div class="five wide column field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 10px;"></div>');
	        modal.modal({
		    closable  : false,
		    centered: false,
		    onDeny : function() {
				modal.find('.approve').fadeOut('fast');
		    },
		    onApprove : function() {
		    	$(this).submit();
		    }
		  }).modal('show');
	        //get permissions with ajax
	        var token = "<?php echo e(csrf_token()); ?>";
	        var route = "<?php echo e(route('super_admin.view.user.permissions')); ?>";
	        var type = 'school-admin';
	        $.ajax({
	        	url: route,
	        	type: 'POST',
	        	data: {id: id, type: type, _token: token},
	        	success: function(response){
					modal.find('.approve').fadeIn('slow');
					modal.find('.description').html('');
					modal.find('.description').addClass('scrolling content');
	        		if(typeof response !=  'string'){
	        			$.each(response, function(index, value){
	        				getPermissions(value, modal);
	        			});
	        			modal.find('.description').append('<input name="user_id" type="hidden" value="'+id+'" >');
	        			modal.find('.description').append('<input name="_token" type="hidden" value="'+token+'" >');
	        			modal.find('.description').append('<input name="type" type="hidden" value="'+type+'" >');

	        			//submit function here for form
	        			modal.one('submit', function(e){
	        				e.preventDefault();
	        				var formData = $(this).serialize();
	        				var route = "<?php echo e(route('super_admin.update.user.permissions')); ?>";
	        				$.ajax({
	        					url: route,
	        					type: 'POST',
	        					data: formData,
	        					success: function(response){
	        						if(response == 'permissions updated'){
										$('.msg-bag').html(success(response));
										msgClose();
	        						}else{
	        							$('.msg-bag').html(error(response));
	        							msgClose();
	        						}
									modal.find('.approve').fadeOut('fast');
	        					},
	        					error: function(error){
					        		console.log(error);
					        		$('.msg-bag').html(error('Something went wrong'));
					        		msgClose();
									modal.find('.approve').fadeOut('fast');
	        					}
	        				});
	        			});

	        		}else{
	        			modal.find('.description').html('<p style="text-align: center;padding-top: 1em; color: red;">'+response+'</p>');
	        		}
	        	},
	        	error: function(error){
	        		console.log(error);
	        		$('.msg-bag').html(error('Something went wrong'));
	        		msgClose();
					modal.find('.approve').fadeOut('fast');
	        	}
	        });
	    });
	});
</script>
<script>
	function getPermissions(value, modal){
		$permission = '<div class="three wide column left floated compact segment" style="padding: 30px">';
		  $permission += '<div class="ui fitted toggle checkbox">';
		    $permission += '<input '+value.status+' name="permission['+value.id+']" value="'+value.id+'" type="checkbox">';
		    $permission += '<label></label>';
		    $permission += value.permission;
		  $permission += '</div>';
		$permission += '</div>';

		modal.find('.description').append($permission);
	}

	function error(response){
		$error = '<div class="ui error message transition">';
		  $error += '<div class="header">'+response+'</div>';
		  $error += '<i class="close icon"></i>';
		$error += '</div>';
		return $error;
	}

	function success(response){
		$success = '<div class="ui success message transition">';
		  $success += '<div class="header">'+response+'</div>';
		  $success += '<i class="close icon"></i>';
		$success += '</div>';
		return $success;
	}

	function msgClose(){
		$('.message .close').on('click', function() {
		    $(this).closest('.message').fadeOut('slow');
		});
	}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>