<?php $__env->startSection('content'); ?>
	<section class="ui stackable grid" id="student-dashboard" style="margin-top: 40px; margin-left:20px;">
		<div class="ui floating message four wide column">
			<div class="ui divided items">
			  <div class="item">
			  	<div class="image" style="margin:auto">
			      <img src="<?php echo e(url_public($student->passport)); ?>">
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Fullname</div>
			      <div class="description">
			        <p><?php echo e($student->surname.' '.$student->firstname.' '.$student->middlename); ?></p>
			      </div>
			    </div>
			  </div>
			
			<?php if($student->afterTransfer()->count() == 0 && $student->beforeTransfer()->count() == 0 ): ?>
			  <div class="item">
			    <div class="content">
			      <div class="header">OSSIN</div>
			      <div class="description">
			        <p><?php echo e($student->regnum); ?></p>
			      </div>
			    </div>
			  </div>
			<?php else: ?>
				<?php if($student->beforeTransfer()->count() > 0 ): ?>
					<?php if($student->beforeTransfer()->first()->new_school_status == 1): ?>
						<div class="item">
						    <div class="content">
						      <div class="header">OLD OSSIN</div>
						      <div class="description">
						      	<p>
									<?php echo e($student->regnum); ?>

								</p>
						      </div>
						    </div>
						 </div>
						 <div class="item">
						    <div class="content">
						      <div class="header">NEW OSSIN</div>
						      <div class="description">
						      	<p>
									<?php echo e($student->beforeTransfer()->with('studentAfterTransfer')->first()->studentAfterTransfer->regnum); ?>

								</p>
						      </div>
						    </div>
						 </div>
					<?php else: ?>
						<div class="item">
						    <div class="content">
						      <div class="header">OSSIN</div>
						      <div class="description">
						        <p><?php echo e($student->regnum); ?></p>
						      </div>
						    </div>
						</div>
					<?php endif; ?>
				<?php else: ?>
					<?php if($student->afterTransfer()->first()->new_school_status == 1): ?>
						<div class="item">
						    <div class="content">
						      <div class="header">OLD OSSIN</div>
						      <div class="description">
						      	<p>
									<?php echo e($student->afterTransfer()->with('studentBeforeTransfer')->first()->studentBeforeTransfer->regnum); ?>

								</p>
						      </div>
						    </div>
						</div>
						<div class="item">
						    <div class="content">
						      <div class="header">NEW OSSIN</div>
						      <div class="description">
						      	<p>
									<?php echo e($student->regnum); ?>

								</p>
						      </div>
						    </div>
						</div>
					<?php else: ?>
						<div class="item">
						    <div class="content">
						      <div class="header">OSSIN</div>
						      <div class="description">
						        <p><?php echo e($student->regnum); ?></p>
						      </div>
						    </div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			<?php endif; ?>
			
			  <div class="item">
			    <div class="content">
			      <div class="header">Date of Birth</div>
			      <div class="description">
			        <p><?php echo e(null !== $student->dob ? \Carbon\Carbon::createFromFormat('Y-m-d', $student->dob)->format('jS F, Y ') : 'Date of Birth not Available'); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Gender</div>
			      <div class="description">
			        <p><i class="<?php echo e(strtolower($student->gender)); ?> icon"></i><?php echo e($student->gender); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Country</div>
			      <div class="description">
			        <p><?php echo e($student->country); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Contact Address</div>
			      <div class="description">
			        <p><?php echo e($student->address); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State of Origin</div>
			      <div class="description">
			        <p><?php echo e(getStateName($student->state_id)); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">State Local Government Area</div>
			      <div class="description">
			        <p><?php echo e(getStateLGAName($student->lga_id)); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Student's Religion</div>
			      <div class="description">
			        <p><?php echo e($student->religion); ?></p>
			      </div>
			    </div>
			  </div>
			  <div class="item">
			    <div class="content">
			      <div class="header">Student's Phone Number</div>
			      <div class="description">
			        <p><?php echo e($student->phone); ?></p>
			      </div>
			    </div>
			  </div>
			 </div>
		</div>
		<div class="ten wide column">
			<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			<?php echo $__env->yieldContent('content-student'); ?>
		</div>
	</section>

	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>


	<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>