<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<form class="ui form" action="<?php echo e(route('admin.view.school.teachers.page')); ?>" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		  <h2 class="ui dividing header">Search Registered teachers</h2>
		  <div class="three fields">

	      <div class="field">
	        <label>Teachers</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="id" value="<?php echo e(old('id')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Teachers</div>
	          <div class="menu">
	          <?php foreach($all_teachers as $teacher): ?>
				<div class="item" data-value="<?php echo e($teacher->id); ?>"><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></div>
	          <?php endforeach; ?>
	          </div>
	        </div>
	      </div>

	      
	      <div class="field">
	          <label>Session</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="session" value="<?php echo e(old('session')); ?>">
	            <i class="dropdown icon"></i>
	            <div class="default text">Session</div>
	            <div class="menu">
	              <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
	               <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
	              <?php endfor; ?>
	            </div>
	          </div>
	        </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Teachers</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Teachers Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Identification Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Passport</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Subject Areas</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Teachers</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($teachers) > 0): ?>
		  		<?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $teachers->perPage()  ?>
		  	<?php foreach($teachers as $teacher): ?>
		    <tr>
		    	<td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></td>
		      <td><?php echo e($teacher->staff_no); ?></td>
		      <td><img src="<?php echo e(env('APP_URL').$teacher->passport); ?>" class="ui small image"></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php foreach(getAssocSubject($teacher->id) as $t_s): ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($t_s->subject_name); ?></p>
				    </div>
				</div>
		      	<?php endforeach; ?>
		      	</div>
		      </td>
		      <td class="std-view">
		      <?php if(auth('admin')->user()->can('edit-teacher')): ?>
			      <button class="ui labeled blue icon button" data-std-id="<?php echo e($teacher->id); ?>" data-href="<?php echo e(route('admin.edit.school.teachers', ['id' => $teacher->id])); ?>">
				  <i class="edit icon" ></i>
				  Edit
				</button>
			<?php endif; ?>
			  </td>
		      <td class="std-view">
		      <?php if(auth('admin')->user()->can('delete-teacher')): ?>
				<button class="ui labeled negative icon button" data-std-id="<?php echo e($teacher->id); ?>" data-href="<?php echo e(route('admin.delete.school.teachers', ['id' => $teacher->id])); ?>">
				  <i class="trash icon"></i>
				  Delete
				</button>
				<?php endif; ?>
		      </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="7">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		      <?php echo $__env->make('pagination.default', ['paginator' => $teachers], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>