<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnityCenter extends Model
{
    protected $fillable = [
        'lga_id',
        'name',
        'max_count',
    ];

    public function hall(){
        return $this->hasMany('App\UnityHall', 'unity_centers_id');
    }

    public function ondo_lga(){
        return $this->belongsTo('App\OndoLGA', 'lga_id');
    }

    public function hallAllocation(){
        return $this->hasMany('App\UnityHallAllocation', 'school_center_id');
    }

}