<?php

namespace App;

use Illuminate\Foundation\Auth\User as Authenticatable;

class SuperAdmin extends Authenticatable
{
    protected $fillable =[
        'email',
        'fullname',
        'username',
        'password',
        'status',
        'phone',
        'login_count',
        'update_level'
    ];

    protected $table = 'super_admins';

    protected $guard = 'super_admin';

    public static $rules = [
		'fullname' => 'required|min:6',
		'username' => 'required|min:4|unique:super_admins,username',
		'email' => 'required|email|unique:super_admins,email',
		'password' => 'required|alpha_num|min:6||confirmed',
		'password_confirmation' => 'required'
	];

    public static $rulesLogin = [
		'username' => 'required|min:3',
		'password' => 'required',
    ];

    public static $schoolAdminPermissions = [1,2,3,4,5,6,7,8,9,10,11,12,13,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,55,55,56,57];

    public function permissions(){

        return $this->belongsToMany('\App\Permission', 'super_admin_permission', 'super_admin_id');

    }

    public function hasPermission($permission){
        $permissions = array();
        foreach ($this->permissions as $permits) {
            $permissions[] = $permits->permission_slug;
        }

        return in_array($permission, $permissions);

    }

    public function tasks(){
        return $this->belongsToMany('App\Task', 'tasks_members', 'super_admin_id', 'task_id');
    }
}
