<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class BackendServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('App\Repositories\StudentRepositoryInterface',
         'App\Repositories\DbStudentRepository'
         );
        $this->app->bind('App\Repositories\TeacherRepositoryInterface',
         'App\Repositories\DbTeacherRepository'
         );
        $this->app->bind('App\Repositories\ClassRepositoryInterface',
         'App\Repositories\DbClassRepository'
         );
        $this->app->bind('App\Repositories\ClassArmRepositoryInterface',
         'App\Repositories\DbClassArmRepository'
         );
        $this->app->bind('App\Repositories\SubjectRepositoryInterface',
         'App\Repositories\DbSubjectRepository'
         );
        $this->app->bind('App\Repositories\StudentResultRepositoryInterface',
         'App\Repositories\DbStudentResultRepository'
         );
        $this->app->bind('App\Repositories\AdminRepositoryInterface',
         'App\Repositories\DbAdminRepository'
         );
        $this->app->bind('App\Repositories\PermissionRepositoryInterface',
         'App\Repositories\DbPermissionRepository'
         );

        $this->app->bind('App\Repositories\ResultVoucherRepositoryInterface',
         'App\Repositories\DbResultVoucherRepository'
         );

        $this->app->bind('App\Repositories\SuperAdminRepositoryInterface',
         'App\Repositories\DbSuperAdminRepository'
         );

        $this->app->bind('App\Repositories\NgStatesRepositoryInterface',
         'App\Repositories\DbNgStatesRepository'
         );

        $this->app->bind('App\Repositories\NgStatesLGARepositoryInterface',
         'App\Repositories\DbNgStatesLGARepository'
         );

        $this->app->bind('App\Repositories\SchoolRepositoryInterface',
         'App\Repositories\DbSchoolRepository'
         );

        $this->app->bind('App\Repositories\OndoLGARepositoryInterface',
         'App\Repositories\DbOndoLGARepository'
         );

        $this->app->bind('App\Repositories\PracticalSkillRepositoryInterface',
         'App\Repositories\DbPracticalSkillRepository'
         );

        $this->app->bind('App\Repositories\StudentHouseRepositoryInterface',
         'App\Repositories\DbStudentHouseRepository'
         );

        $this->app->bind('App\Repositories\CharacterAttitudeRepositoryInterface',
         'App\Repositories\DbCharacterAttitudeRepository'
         );

        $this->app->bind('App\Repositories\PaymentRepositoryInterface',
         'App\Repositories\DbPaymentRepository'
         );

        $this->app->bind('App\Repositories\PaymentRecipientRepositoryInterface',
         'App\Repositories\DbPaymentRecipientRepository'
         );
        
        $this->app->bind('App\Repositories\PaymentItemsRepositoryInterface',
         'App\Repositories\DbPaymentItemsRepository'
         );

        $this->app->bind('App\Repositories\LibraryRepositoryInterface',
         'App\Repositories\DbLibraryRepository'
         );

        $this->app->bind('App\Repositories\LibraryCategoryRepositoryInterface',
         'App\Repositories\DbLibraryCategoryRepository'
         );

        $this->app->bind('App\Repositories\LibraryIssueRepositoryInterface',
         'App\Repositories\DbLibraryIssueRepository'
         );

        $this->app->bind('App\Repositories\SubjectUnofferedRepositoryInterface',
         'App\Repositories\DbSubjectUnofferedRepository'
         );

        $this->app->bind('App\Repositories\StudentCommentsRepositoryInterface',
         'App\Repositories\DbStudentCommentsRepository'
         );

        $this->app->bind('App\Repositories\TaskRepositoryInterface',
         'App\Repositories\DbTaskRepository'
         );


    }
}
