<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model
{
    protected $table = 'permissions';

    protected $fillable = ['admin_id', 'permission_id'];

    public function admins(){

        return $this->belongsToMany('App\Admin', 'admin_permission', 'permission_id', 'admin_id');

    }

    public function super_admins(){

        return $this->belongsToMany('App\SuperAdmin', 'super_admin_permission', 'permission_id', 'super_admin_id');

    }

    public function getPermissionSlugAttribute($value){

    	return str_slug(trim(preg_replace('!\s+!', ' ', $this->permission)), '-');

    }

    public function teacher_classes(){

        return $this->belongsToMany('App\Teacher', 'class_teacher_permission', 'permission_id', 'teacher_id')->withPivot('classarm_id', 'subject_id');

    }
}
