<?php
if (env('APP_ENV') === 'production') {
    URL::forceSchema('https');
}
/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
use App\Payment;
use App\PaymentRecipient;
use App\School;
use App\Student;
use App\PaymentItems;
use App\Admin;
use App\News;
use Illuminate\Http\Request;


Route::get('/', function () {
    $noAutoAd = true;
    return view('welcome', compact('noAutoAd'));
});

Route::get('/general-access', function () {
    $noAutoAd = true;
    return view('layouts.general-login', compact('noAutoAd'));
});

Route::get('/teachers-password-update/{from}/{to}', function ($from, $to) {
    $newTo = $to + 1;
   $teachers = App\Teacher::where('id', '>', $from)->where('id', '<', $newTo)->get();
   foreach($teachers as $teacher){
       $teacher->password = bcrypt('teacher');
       $teacher->save();
       
       echo 'Updated: '.$teacher->id.') '.$teacher->surname.' '.$teacher->firstname.'<br>';
   }
});

Route::get('/pdf-download-result', function(Request $request){
    $blob = $request->blob;
    $student = $request->student;
    $file = storage_path(). "/app/blob-result-csv/".$blob.".pdf";
    if(file_exists($file)){
        $headers = array(
          'Content-Type: application/pdf',
        );
        return Response::download($file, $student."'s_result.pdf", $headers);
    }else{
        return 'Expired';
    }
});

Route::get('/turn-off', function () {
    Artisan::call('down');
});

Route::get('/turn-on', function () {
    Artisan::call('up');
});

Route::get('/survey-2019-reset', function () {
    $surveys = App\SchoolSurvey::where('session', '!=', '2019')->get();
    foreach($surveys as $survey){
        if(App\SchoolSurvey::where('school_id', $survey->school_id)->where('session', '2019')->get()->count() > 0){
            $survey->delete();
        }else{
            $survey->session = '2019';
            $survey->save();
        }
    }
});

// schools contacts
Route::get('/schools-contacts', ['as' => 'schools-contacts', 'uses' => 'HomeController@schoolsContacts']);
Route::post('/schools-contacts', ['as' => 'schools-contacts', 'uses' => 'HomeController@schoolsContactsView']);

// charts endpoints
Route::get('/get-daily-user-chart-data', ['as' => 'test-chart', 'uses' => 'AnalyticController@getDailyUsersData']);
Route::get('/get-weekly-user-chart-data', ['as' => 'test-chart', 'uses' => 'AnalyticController@getWeeklyUsersData']);
Route::get('/get-monthly-user-chart-data', ['as' => 'test-chart', 'uses' => 'AnalyticController@getMonthlyUsersData']);

// new laravel overview app
Route::group([
        'middleware' => ['api'],
        'prefix' => 'overview-app',
    ], function () {
    Route::get('/', function() {
        return view('overview.welcome');
    });
    Route::get('help', ['as' => 'overview-app.help', 'uses' => 'Overview\MainController@help']);
    Route::get('load-error', function(){
        return view('overview.load-error');
    });
    Route::group(['prefix' => 'api'], function(){
        Route::post('get-schools', ['as' => 'overview-app.api.get-schools', 'uses' => 'SchoolController@schoolAjaxOverviewApp']);
        Route::post('get-classes', ['as' => 'overview-app.api.get-classes', 'uses' => 'SchoolController@classAjaxOverviewApp']);
        Route::post('get-class-arms', ['as' => 'overview-app.api.get-class-arms', 'uses' => 'SchoolController@classArmAjaxOverviewApp']);
    });
    
    Route::group(['prefix' => 'ministry'], function(){
        Route::pattern('id', '[0-9]+');
        // search
        Route::any('search', ['as' => 'overview-app.super_admin.search.bar', 'uses' => 'Overview\SuperAdminAuthController@searchBar']);

        Route::get('login', ['as' => 'overview-app.super_admin.login', 'uses' => 'Overview\Auth\SuperAdminAuthController@showLoginForm']);

        Route::post('login', ['as' => 'overview-app.super_admin.login.submit', 'uses' => 'Overview\Auth\SuperAdminAuthController@login']);

        Route::get('logout', ['as' => 'overview-app.super_admin.logout', 'uses' => 'Overview\Auth\SuperAdminAuthController@logout']);

        Route::get('dashboard', ['as' => 'overview-app.super_admin.dashboard', 'uses' => 'Overview\SuperAdminController@dashboard']);

        Route::get('attendance/{type}', ['as' => 'overview-app.super_admin.attendance', 'uses' => 'Overview\SuperAdminController@attendance']);

        Route::post('attendance/{type}', ['as' => 'overview-app.super_admin.attendance', 'uses' => 'Overview\SuperAdminController@attendanceSearch']);

        Route::get('profile', ['as' => 'overview-app.super_admin.profile', 'uses' => 'Overview\SuperAdminController@profile']);
    });
    
    Route::group(['prefix' => 'admin'], function(){

        Route::get('login', ['as' => 'overview-app.admin.login', 'uses' => 'Overview\Auth\AdminAuthController@showLoginForm']);
        
        Route::post('login', ['as' => 'overview-app.admin.login.submit', 'uses' => 'Overview\Auth\AdminAuthController@login']);
        
        Route::get('logout', ['as' => 'overview-app.admin.logout', 'uses' => 'Overview\Auth\AdminAuthController@logout']);

        Route::get('dashboard', ['as' => 'overview-app.admin.dashboard', 'uses' => 'Overview\AdminController@dashboard']);

        Route::post('dashboard', ['as' => 'overview-app.admin.dashboard', 'uses' => 'Overview\AdminController@attendanceMark']);

        Route::get('subject-teacher', ['as' => 'overview-app.admin.subject.teacher', 'uses' => 'Overview\AdminController@subjectTeacher']);

        Route::post('subject-teacher', ['as' => 'overview-app.admin.subject.teacher', 'uses' => 'Overview\AdminController@subjectTeacherAction']);

        Route::get('class-teacher', ['as' => 'overview-app.admin.class.teacher', 'uses' => 'Overview\AdminController@classTeacher']);

        Route::post('class-teacher', ['as' => 'overview-app.admin.class.teacher', 'uses' => 'Overview\AdminController@classTeacherAction']);
        
        Route::get('attendance/{type}', ['as' => 'overview-app.admin.attendance', 'uses' => 'Overview\AdminController@attendance']);
        
        Route::post('attendance/{type}', ['as' => 'overview-app.admin.attendance', 'uses' => 'Overview\AdminController@attendanceSearch']);
        
        Route::get('teachers/attendance', ['as' => 'overview-app.admin.teachers.attendance', 'uses' => 'Overview\AdminController@teachersAttendance']);
        
        Route::post('teachers/attendance', ['as' => 'overview-app.admin.teachers.attendance', 'uses' => 'Overview\AdminController@teachersAttendanceMark']);
        
        Route::get('profile', ['as' => 'overview-app.admin.profile', 'uses' => 'Overview\AdminController@profile']);
    });
    
    Route::group(['prefix' => 'teacher'], function(){

        Route::get('login', ['as' => 'overview-app.teacher.login', 'uses' => 'Overview\Auth\TeacherAuthController@showLoginForm']);
        
        Route::post('login', ['as' => 'overview-app.teacher.login.submit', 'uses' => 'Overview\Auth\TeacherAuthController@login']);
        
        Route::get('logout', ['as' => 'overview-app.teacher.logout', 'uses' => 'Overview\Auth\TeacherAuthController@logout']);

        Route::get('dashboard', ['as' => 'overview-app.teacher.dashboard', 'uses' => 'Overview\TeacherController@dashboard']);

        Route::post('dashboard', ['as' => 'overview-app.teacher.dashboard', 'uses' => 'Overview\TeacherController@attendanceMark']);
        
        Route::get('attendance/{type}', ['as' => 'overview-app.teacher.attendance', 'uses' => 'Overview\TeacherController@attendance']);
        
        Route::post('attendance/{type}', ['as' => 'overview-app.teacher.attendance', 'uses' => 'Overview\TeacherController@attendanceSearch']);
        
        Route::get('class/attendance/{teacher_id}', ['as' => 'overview-app.teacher.class.attendance', 'uses' => 'Overview\TeacherController@classAttendance']);
        
        Route::post('class/attendance/{teacher_id}', ['as' => 'overview-app.teacher.class.attendance', 'uses' => 'Overview\TeacherController@classAttendanceSearchAndMark']);
        
        Route::get('subject/attendance/{teacher_id}', ['as' => 'overview-app.teacher.subject.attendance', 'uses' => 'Overview\TeacherController@subjectAttendance']);
        
        Route::post('subject/attendance/{teacher_id}', ['as' => 'overview-app.teacher.subject.attendance', 'uses' => 'Overview\TeacherController@subjectAttendanceSearchAndMark']);
        
        Route::get('profile', ['as' => 'overview-app.teacher.profile', 'uses' => 'Overview\TeacherController@dashboard']);
    });
    
    Route::group(['prefix' => 'student'], function(){
        
        Route::get('login', ['as' => 'overview-app.student.login', 'uses' => 'Overview\Auth\StudentAuthController@showLoginForm']);
    
        Route::post('login', ['as' => 'overview-app.student.login.submit', 'uses' => 'Overview\Auth\StudentAuthController@login']);
    
        Route::get('logout', ['as' => 'overview-app.student.logout', 'uses' => 'Overview\Auth\StudentAuthController@logout']);

        Route::get('dashboard', ['as' => 'overview-app.student.dashboard', 'uses' => 'Overview\StudentController@dashboard']);
        
        Route::get('attendance', ['as' => 'overview-app.student.attendance', 'uses' => 'Overview\StudentController@attendance']);
        
        Route::post('attendance', ['as' => 'overview-app.student.attendance', 'uses' => 'Overview\StudentController@attendanceSearch']);
    });
});


// new laravel result app
Route::group([
        'middleware' => ['api'],
        'prefix' => 'result-app',
    ], function () {
    Route::get('/', function() {
        return view('result-app.welcome');
    });
    Route::get('help', ['as' => 'result-app.help', 'uses' => 'ResultApp\MainController@help']);
    Route::get('load-error', function(){
        return view('result.load-error');
    });
    Route::group(['prefix' => 'api'], function(){
        Route::post('get-classes', ['as' => 'result-app.api.get-classes', 'uses' => 'SchoolController@classAjaxResultApp']);
        Route::post('get-class-arms', ['as' => 'result-app.api.get-class-arms', 'uses' => 'SchoolController@classArmAjaxOverviewApp']);
    });
    
    Route::group(['prefix' => 'student'], function(){
        
        Route::get('login', ['as' => 'result-app.student.login', 'uses' => 'ResultApp\Auth\StudentAuthController@showLoginForm']);
    
        Route::post('login', ['as' => 'result-app.student.login.submit', 'uses' => 'ResultApp\Auth\StudentAuthController@login']);
    
        Route::get('logout', ['as' => 'result-app.student.logout', 'uses' => 'ResultApp\Auth\StudentAuthController@logout']);

        Route::get('dashboard', ['as' => 'result-app.student.dashboard', 'uses' => 'ResultApp\StudentController@dashboard']);
        
        Route::get('digital-card/{session}', ['as' => 'result-app.student.digital-card', 'uses' => 'ResultApp\StudentController@digitalCard']);
        
        Route::get('results/{pin}/{session}', ['as' => 'result-app.student.results', 'uses' => 'ResultApp\StudentController@results']);
        
        Route::post('results', ['as' => 'result-app.student.results', 'uses' => 'ResultApp\StudentController@resultsSearch']);
        
        Route::post('result-check', ['as' => 'result-app.result-check', 'uses' => 'ResultApp\MainController@resultCheck']);
        
        Route::get('attendance', ['as' => 'result-app.student.attendance', 'uses' => 'ResultApp\StudentController@attendance']);
        
        Route::post('attendance', ['as' => 'result-app.student.attendance', 'uses' => 'ResultApp\StudentController@attendanceSearch']);
    });
});

// api endpoints
Route::group(['prefix' => 'api'], function(){
    Route::post('super-admin-login', ['as' => 'api.super_admin.login', 'uses' => 'Api\SuperAdminAuthController@login']);
    Route::post('admin-login', ['as' => 'api.admin.login', 'uses' => 'Api\AdminAuthController@login']);
    Route::post('teacher-login', ['as' => 'api.teacher.login', 'uses' => 'Api\TeacherAuthController@login']);
    Route::post('student-login', ['as' => 'api.student.login', 'uses' => 'Api\StudentAuthController@login']);
});

Route::get('/faq/read/{id}', ['as' => 'faq.read', 'uses' => 'FaqController@postRead']);

Route::get('/student-result', ['as' => 'offlog.student.result', 'uses' => 'HomeController@requestStudentResult']);

Route::get('/student-result', ['as' => 'offlog.student.result', 'uses' => 'HomeController@requestStudentResult']);

Route::post('/student-result', ['as' => 'offlog.student.result.access', 'uses' => 'HomeController@requestStudentResultAccess']);

Route::post('/student-result-viewer', ['as' => 'offlog.student.result.viewer', 'uses' => 'HomeController@studentResultViewer']);

Route::get('/student-data', ['as' => 'offlog.student.data', 'uses' => 'HomeController@getStudentData']);

Route::post('/student-data', ['as' => 'offlog.get.student.data', 'uses' => 'HomeController@getStudentDataProcess']);

Route::post('/lga-schools', ['as' => 'lga.schools', 'uses' => 'HomeController@lgaSchools']);
Route::post('/school-classes', ['as' => 'school.classes', 'uses' => 'HomeController@schoolClasses']);
Route::post('/regnum-school-classes', ['as' => 'regnum.school.classes', 'uses' => 'HomeController@getRegnumSchoolClasses']);
Route::post('/school-classarm', ['as' => 'school.classarm', 'uses' => 'HomeController@schoolClassArms']);
Route::post('/verify-student-scratch-card', ['as' => 'verify.student.result.scratch.card', 'uses' => 'HomeController@verifyStudentScratchCard']);


Route::get('elearning-connect', 'ElearningController@index')->name('elearning.connect');



Route::group([
        'middleware' => ['api', 'cors'],
        'namespace' => $this->namespace,
        'prefix' => 'api',
    ], function ($router) {
// Route::group(['prefix' => 'api'], function(){
    Route::any('/payment', function(Request $request){
        $id = $request->PAYEE_ID;
        $type = $request->PAYMENT_TYPE;
        $error = array();
        if(Payment::where('customer_id', $id)->first()){
            if(PaymentItems::where('item_name', $type)->first()){
                $payment = Payment::where('customer_id', $id)->first();
                $pay_recipients = PaymentRecipient::where('pay_id', $payment->id)->get();
                $students = array();
                $result = array();
                $owner_id = explode('-', $id);
                $admin =  Admin::find($owner_id[1]);
                $payment_type = PaymentItems::find($payment->item_id);
                if($payment->pay_status == 1){
                    $payment_status = 'Fee has not been paid';
                }else{
                    $payment_status = 'Fee has been paid';
                }
                return 'PayeeName='.$admin->fullname.'~AccountType=Administrator~Session='.$payment->session.'~PayeeID='.$id.'~Amount='.$payment->total_cost.'~FeeStatus='.$payment_status.'~PaymentType='.$payment_type->item_name.'~Email='.$admin->email.'~PhoneNumber='.$admin->phone.'';
            }else{
                return 'Error=Payment type "'.$type.'" not found';
            }
        }else{
            return 'Error=There is no payment record with the PAYEE ID "'.$id.'"';
        }
    });
    
    
    Route::any('/payment/verify', function(Request $request){
        $id = $request->PAYEE_ID;
        $type = $request->PAYMENT_TYPE;
        $error = array();
        if(Payment::where('customer_id', $id)->first()){
            if(PaymentItems::where('item_name', $type)->first()){
                if(Payment::where('customer_id', $id)->update(['pay_status'=>2])){
                    return 'Successr=Payment "'.$id.'" has successfully been verified';
                }else{
                    return 'Error=Verification for "'.$id.'" failed';
                }
            }else{
                return 'Error=Payment type "'.$type.'" not found';
            }
        }else{
            return 'Error=There is no payment record with the PAYEE ID "'.$id.'"';
        }
    });
    
    
    Route::any('/payment/unverify', function(Request $request){
        $id = $request->PAYEE_ID;
        $type = $request->PAYMENT_TYPE;
        $error = array();
        if(Payment::where('customer_id', $id)->first()){
            if(PaymentItems::where('item_name', $type)->first()){
                if(Payment::where('customer_id', $id)->update(['pay_status'=>1])){
                    return 'Successr=Payment "'.$id.'" has successfully been unverified';
                }else{
                    return 'Error=Unverification for "'.$id.'" failed';
                }
            }else{
                return 'Error=Payment type "'.$type.'" not found';
            }
        }else{
            return 'Error=There is no payment record with the PAYEE ID "'.$id.'"';
        }
    });
    
    
    Route::get('/get-news', function(){
        return response()->json(News::all());
    });
});



Route::group(['prefix' => 'do-ajax'], function(){

        Route::post('/state', ['as' => 'lga', 'uses' => 'StudentsController@state_lga']);

        Route::post('/class', ['as' => 'arm', 'uses' => 'TeachersController@class_arm']);

        Route::post('/school', ['as' => 'school', 'uses' => 'SchoolController@schoolAjax']);

        Route::post('/primary-school', ['as' => 'school', 'uses' => 'PrimarySchoolController@schoolAjax']);

        Route::post('/subject', ['as' => 'subject', 'uses' => 'SubjectsController@subjectAjax']);

        Route::post('/classes', ['as' => 'school', 'uses' => 'SchoolController@classAjax']);
        
        Route::post('/unity-get-center', function(Request $request){
            return App\UnityCenter::where('lga_id', $request->lga_id)->get();
        });
        Route::post('/unity-get-hall', function(Request $request){
            return App\UnityHall::where('unity_centers_id', $request->center_id)->get();
        });

    });

Route::group(['prefix' => 'agency'], function(){
    Route::get('create', ['as' => 'agency.create', 'uses' => 'AgencyController@create']);
    Route::post('create', ['as' => 'agency.store', 'uses' => 'AgencyController@store']);
});


Route::group(['prefix' => 'exams'], function(){
    Route::get('scratch-card-auth', ['as' => 'exam.unity.scratch.card.auth', 'uses' => 'UnityExamController@loginPage']);
    Route::post('scratch-card-auth', ['as' => 'exam.unity.scratch.card.auth.post', 'uses' => 'UnityExamController@login']);
    Route::get('agency-auth', ['as' => 'exam.unity.agency.auth', 'uses' => 'UnityExamController@authenticatePage']);
    Route::post('agency-auth', ['as' => 'exam.unity.agency.auth.post', 'uses' => 'UnityExamController@authenticate']);

    Route::get('voucher-purchase', ['as' => 'exam.voucher.purchase', 'uses' => 'ExamsVoucherController@cardPurchase']);

    Route::post('voucher-purchase', ['as' => 'exam.voucher.purchase.post', 'uses' => 'ExamsVoucherController@paystackRedirectToGateway']);

    Route::get('voucher-purchase-callback', ['as' => 'exam.voucher.purchase.callback.post', 'uses' => 'ExamsVoucherController@handlePaystackGatewayCallback']);


    Route::group(['prefix' => 'unity'], function(){

        Route::get('generate-exam-number', ['as' => 'exam.unity.generate-exam-number', 'uses' => 'Auth\UnityExamAuthController@createStudent']);

        Route::post('generate-exam-number', ['as' => 'exam.unity.generate-exam-number.post', 'uses' => 'Auth\UnityExamAuthController@storeStudent']);

        Route::get('generate-candidate-password', ['as' => 'exam.unity.generate-candidate-password', 'uses' => 'Auth\UnityExamAuthController@createCandidatePassword']);

        Route::post('generate-candidate-password', ['as' => 'exam.unity.generate-candidate-password.post', 'uses' => 'Auth\UnityExamAuthController@storeCandidatePassword']);

        Route::get('login-with-card', ['as' => 'exam.unity.login.card', 'uses' => 'Auth\UnityExamAuthController@login']);

        Route::get('login-with-exam-number', ['as' => 'exam.unity.login.exam.number', 'uses' => 'Auth\UnityExamAuthController@login']);

        Route::post('login-with-card', ['as' => 'exam.unity.login.card', 'uses' => 'Auth\UnityExamAuthController@loginPost']);

        Route::get('logout', ['as' => 'unity_exam.logout', 'uses' => 'Auth\UnityExamAuthController@logout']);

        Route::post('login-with-exam-number', ['as' => 'exam.unity.login.exam.number', 'uses' => 'Auth\UnityExamAuthController@loginPost']);

        Route::get('create', ['as' => 'exam.unity.create', 'uses' => 'UnityExamController@create']);

        Route::post('create', ['as' => 'exam.unity.store', 'uses' => 'UnityExamController@store']);

        Route::get('passport', ['as' => 'exam.unity.passport', 'uses' => 'UnityExamController@passport'] );

        Route::post('passport', ['as' => 'exam.unity.passport.post', 'uses' => 'UnityExamController@passportPost'] );

        Route::get('confirm', ['as' => 'exam.unity.confirm', 'uses' => 'UnityExamController@confirm']);

        Route::post('confirm', ['as' => 'exam.unity.confirm.post', 'uses' => 'UnityExamController@confirmPost']);

        Route::get('dashboard', ['as' => 'exam.unity.dashboard', 'uses' => 'UnityExamController@dashboard']);

        Route::get('photocard', ['as' => 'exam.unity.photocard', 'uses' => 'UnityExamController@photocard']);

        Route::get('result', ['as' => 'exam.unity.result', 'uses' => 'UnityExamController@result']);

});

    Route::group(['prefix' => 'entrance'], function(){

        Route::get('generate-exam-number', ['as' => 'exam.entrance.generate-exam-number', 'uses' => 'Auth\EntranceExamAuthController@createStudent']);

        Route::post('generate-exam-number', ['as' => 'exam.entrance.generate-exam-number.post', 'uses' => 'Auth\EntranceExamAuthController@storeStudent']);

        Route::get('generate-school-password', ['as' => 'exam.entrance.generate-candidate-password', 'uses' => 'Auth\EntranceExamAuthController@createCandidatePassword']);

        Route::post('generate-school-password', ['as' => 'exam.entrance.generate-candidate-password.post', 'uses' => 'Auth\EntranceExamAuthController@storeCandidatePassword']);

        Route::get('login-with-card', ['as' => 'exam.entrance.login.card', 'uses' => 'Auth\EntranceExamAuthController@login']);

        Route::get('login-with-exam-number', ['as' => 'exam.entrance.login.exam.number', 'uses' => 'Auth\EntranceExamAuthController@login']);

        Route::post('login-with-card', ['as' => 'exam.entrance.login.card', 'uses' => 'Auth\EntranceExamAuthController@loginPost']);

        Route::get('logout', ['as' => 'entrance.logout', 'uses' => 'Auth\EntranceExamAuthController@logout']);

        Route::post('login-with-exam-number', ['as' => 'exam.entrance.login.exam.number', 'uses' => 'Auth\EntranceExamAuthController@loginPost']);

        Route::get('create', ['as' => 'exam.entrance.create', 'uses' => 'EntranceExamController@create']);

        Route::post('create', ['as' => 'exam.entrance.store', 'uses' => 'EntranceExamController@store']);

        Route::get('passport', ['as' => 'exam.entrance.passport', 'uses' => 'EntranceExamController@passport'] );

        Route::post('passport', ['as' => 'exam.entrance.passport.post', 'uses' => 'EntranceExamController@passportPost'] );

        Route::get('confirm', ['as' => 'exam.entrance.confirm', 'uses' => 'EntranceExamController@confirm']);

        Route::post('confirm', ['as' => 'exam.entrance.confirm.post', 'uses' => 'EntranceExamController@confirmPost']);

        Route::get('dashboard', ['as' => 'exam.entrance.dashboard', 'uses' => 'EntranceExamController@dashboard']);

        Route::get('photocard', ['as' => 'exam.entrance.photocard', 'uses' => 'EntranceExamController@photocard']);

        Route::get('{id}/photocard', ['as' => 'exam.entrance.photocard-id', 'uses' => 'EntranceExamController@photocardID']);

        Route::get('result', ['as' => 'exam.entrance.result', 'uses' => 'EntranceExamController@result']);

        Route::get('view-student', ['as' => 'exam.entrance.students', 'uses' => 'EntranceExamController@viewStudent']);

        Route::get('add-more-slots', ['as' => 'exam.entrance.add-slot', 'uses' => 'EntranceExamController@addMoreSlot']);

        Route::post('add-more-slots', ['as' => 'exam.entrance.add-slot.post', 'uses' => 'EntranceExamController@addMoreSlotPost']);

        Route::get('{id}/edit-student-information', ['as' => 'exam.entrance.edit.student', 'uses' => 'EntranceExamController@edit']);

        Route::get('{id}/edit-student-passport', ['as' => 'exam.entrance.edit.student.passport', 'uses' => 'EntranceExamController@editPassport']);

        Route::post('{id}/edit-student-information', ['as' => 'exam.entrance.edit.student.post', 'uses' => 'EntranceExamController@update']);

        Route::post('{id}/edit-student-passport', ['as' => 'exam.entrance.edit.student.passport.post', 'uses' => 'EntranceExamController@updatePassport']);


});
});

Route::group(['prefix' => 'ministry'], function(){

    Route::pattern('id', '[0-9]+');

    // search
    Route::any('search', ['as' => 'super_admin.search.bar', 'uses' => 'SuperAdminController@searchBar']);

    Route::get('login', ['as' => 'super_admin.login', 'uses' => 'Auth\SuperAdminAuthController@showLoginForm']);

    Route::post('login', ['as' => 'super_admin.login.submit', 'uses' => 'Auth\SuperAdminAuthController@login']);

    Route::get('logout', ['as' => 'super_admin.logout', 'uses' => 'Auth\SuperAdminAuthController@logout']);
    
    Route::get('overview', ['as' => 'super_admin.overview', 'uses' => 'SuperAdminController@overview']);
    
    Route::post('quick-update', ['as' => 'super_admin.quick-update', 'uses' => 'SuperAdminController@quickUpdate']);
    
    // Login Reset
    Route::get('login-reset', ['as' => 'super_admin.login-reset', 'uses' => 'SuperAdminController@loginReset']);
    Route::post('login-reset', ['as' => 'super_admin.login-reset', 'uses' => 'SuperAdminController@loginResetPost']);
    
    // Activity log
    Route::get('activity-log', ['as' => 'super_admin.activity-log', 'uses' => 'SuperAdminController@activityLog']);
    Route::get('activity-log/super-admins', ['as' => 'super_admin.activity-log.super-admins', 'uses' => 'SuperAdminController@superAdminsActivityLog']);
    Route::get('activity-log/super-admin/{id}', ['as' => 'super_admin.activity-log.super-admin', 'uses' => 'SuperAdminController@superAdminActivityLog']);
    Route::get('activity-log/admins', ['as' => 'super_admin.activity-log.admins', 'uses' => 'SuperAdminController@adminsActivityLog']);
    Route::get('activity-log/admin/{id}', ['as' => 'super_admin.activity-log.admin', 'uses' => 'SuperAdminController@adminActivityLog']);
    Route::get('activity-log/teachers', ['as' => 'super_admin.activity-log.teachers', 'uses' => 'SuperAdminController@teachersActivityLog']);
    Route::get('activity-log/teacher/{id}', ['as' => 'super_admin.activity-log.teacher', 'uses' => 'SuperAdminController@teacherActivityLog']);
    Route::get('activity-log/students', ['as' => 'super_admin.activity-log.students', 'uses' => 'SuperAdminController@studentsActivityLog']);
    Route::get('activity-log/student/{id}', ['as' => 'super_admin.activity-log.student', 'uses' => 'SuperAdminController@studentActivityLog']);
    
    // E-learning
    Route::get('e-learning', ['as' => 'super_admin.e-learning', 'uses' => 'SuperAdminController@eLearning']);
    
    // Payment History
    Route::get('payment-history', ['as' => 'super_admin.payment-history', 'uses' => 'SuperAdminController@paymentHistory']);
    Route::post('payment-history', ['as' => 'super_admin.payment-history', 'uses' => 'SuperAdminController@paymentHistoryPage']);
    
    // Payment History
    Route::get('download-passports', ['as' => 'super_admin.download-passports', 'uses' => 'SuperAdminController@downloadPassports']);
    Route::post('download-passports', ['as' => 'super_admin.download-passports', 'uses' => 'SuperAdminController@downloadPassportsPage']);
    
    // Survey
    Route::get('schools-survey', ['as' => 'super_admin.schools-survey', 'uses' => 'SuperAdminController@schoolSurvey']);
    Route::get('teachers-survey', ['as' => 'super_admin.teachers-survey', 'uses' => 'SuperAdminController@teachersSurvey']);
    Route::post('teachers-survey-sort', ['as' => 'super_admin.teachers-survey-sort', 'uses' => 'SuperAdminController@teachersSurveySort']);
    Route::post('teachers-survey-sort-export', ['as' => 'super_admin.teachers-survey-sort-export', 'uses' => 'SuperAdminController@teachersSurveySortExport']);
    Route::get('schools-survey-stats/{session}', ['as' => 'super_admin.schools-survey-stats', 'uses' => 'SuperAdminController@schoolSurveyStats']);
    Route::post('schools-survey-stats/{session}', ['as' => 'super_admin.schools-survey-stats', 'uses' => 'SuperAdminController@schoolSurveyStatsExport']);
    Route::get('schools-survey-stats-data/{session}', ['as' => 'super_admin.schools-survey-stats-data', 'uses' => 'SuperAdminController@schoolSurveyStatsData']);
    Route::get('schools-survey-stats-data-summary/{session}', ['as' => 'super_admin.schools-survey-stats-data-summary', 'uses' => 'SuperAdminController@schoolSurveyStatsDataSummary']);
    Route::get('schools-general-survey-stats-data/{session}', ['as' => 'super_admin.schools-general-survey-stats-data', 'uses' => 'SuperAdminController@schoolGeneralSurveyStatsData']);
    Route::get('schools-general-survey-stats-export/{session}', ['as' => 'super_admin.schools-general-survey-stats-export', 'uses' => 'SuperAdminController@schoolGeneralSurveyStatsExport']);
    Route::get('school-survey-view/{id}/{session}', ['as' => 'super_admin.school-survey.view', 'uses' => 'SuperAdminController@schoolSurveyView']);
    Route::post('school-survey-view/{id}/{session}', ['as' => 'super_admin.school-survey.view', 'uses' => 'SuperAdminController@schoolSurveyExport']);


    Route::get('payment/all-schools', ['as' => 'super_admin.payment.all.schools', 'uses' => 'SuperAdminController@paymentAllSchools']);
    Route::get('payment/all-transaction-verified/{id}', ['as' => 'super_admin.payment.all.transaction.verified', 'uses' => 'SuperAdminController@paymentTransactionVerified']);
    Route::get('payment/all-transaction-unverified/{id}', ['as' => 'super_admin.payment.all.transaction.unverified', 'uses' => 'SuperAdminController@paymentTransactionUnverified']);
    Route::get('payment/transaction-details/{id}', ['as' => 'super_admin.payment.transaction.details', 'uses' => 'SuperAdminController@paymentDetails']);


    Route::get('school-statistics', ['as' => 'super_admin.school.statistics', 'uses' => 'SuperAdminController@schoolStatistics']);
    Route::post('school-statistics', ['as' => 'super_admin.school.view.statistics', 'uses' => 'SuperAdminController@schoolStatisticsGet']);

    Route::post('generate-statistics-tables-student', ['as' => 'super_admin.statistics.tables.student', 'uses' => 'SuperAdminController@schoolGenerateStatTablesStudent']);

    Route::post('generate-statistics-tables-teacher', ['as' => 'super_admin.statistics.tables.teacher', 'uses' => 'SuperAdminController@schoolGenerateStatTablesTeacher']);

    Route::post('generate-broad-statistics-tables', ['as' => 'super_admin.broad.statistics.tables', 'uses' => 'SuperAdminController@schoolGenerateBroadStatTables']);
    
    Route::post('generate-statistics-session-result', ['as' => 'super_admin.statistics.session.result', 'uses' => 'SuperAdminController@generateSchoolSessionResultStatistics']);

    Route::post('generate-subject-statistics', ['as' => 'super_admin.statistics.subject', 'uses' => 'SuperAdminController@generateSchoolSubjectStatistics']);

    Route::post('generate-subject-statistics-broad', ['as' => 'super_admin.statistics.subject.broad', 'uses' => 'SuperAdminController@generateSchoolSubjectStatisticsBroad']);
    
    // schools annual asset
    Route::get('schools-annual-asset', ['as' => 'super_admin.schools.annual-asset', 'uses' => 'SuperAdminController@annualAssetView']);
    Route::get('schools-annual-asset/{id}', ['as' => 'super_admin.school.annual-asset', 'uses' => 'SuperAdminController@schoolAnnualAssetView']);
    
    // schools id-card-request
    Route::get('school-id-card-schools', ['as' => 'super_admin.school.id-card-schools', 'uses' => 'SuperAdminController@schoolIdCardSchoolsView']);
    Route::get('school-id-card-request/{id}', ['as' => 'super_admin.school.id-card-request', 'uses' => 'SuperAdminController@schoolIdCardRequestView']);
    Route::post('school-id-card-request/{id}', ['as' => 'super_admin.school.id-card-request', 'uses' => 'SuperAdminController@schoolIdCardRequestAction']);
    Route::get('school-id-card-request-download/{id}/{school_id}', ['as' => 'super_admin.school.id-card-request-download', 'uses' => 'SuperAdminController@schoolIdCardRequestDownload']);

    // schools wallet
    Route::get('schools-wallet', ['as' => 'super_admin.schools.wallet', 'uses' => 'SuperAdminController@schoolsWalletView']);
    Route::get('schools-wallet-transactions/{school_id}', ['as' => 'super_admin.schools.wallet.transactions', 'uses' => 'SuperAdminController@schoolsWalletTransactions']);
    Route::post('schools-wallet', ['as' => 'super_admin.schools.wallet', 'uses' => 'SuperAdminController@schoolWalletUpdate']);
    
    // news
    Route::get('news', ['as' => 'super_admin.news', 'uses' => 'SuperAdminController@newsView']);
    Route::post('news-create', ['as' => 'super_admin.news.create', 'uses' => 'SuperAdminController@newsCreate']);
    Route::post('news-edit', ['as' => 'super_admin.news.edit', 'uses' => 'SuperAdminController@newsEdit']);
    Route::post('news-delete', ['as' => 'super_admin.news.delete', 'uses' => 'SuperAdminController@newsDelete']);

    Route::get('payment-statistics', ['as' => 'super_admin.payment.statistics', 'uses' => 'SuperAdminController@paymentStatistics']);
    Route::post('payment-statistics', ['as' => 'super_admin.payment.view.statistics', 'uses' => 'SuperAdminController@paymentStatisticsGet']);

    Route::group(['prefix' => 'faq'], function(){

        Route::get('new', ['as' => 'super_admin.faq.new', 'uses' => 'FaqController@newPost']);
        Route::post('new', ['as' => 'super_admin.faq.new', 'uses' => 'FaqController@newPostProcess']);

        Route::get('view-all', ['as' => 'super_admin.faq.view', 'uses' => 'FaqController@allPost']);

        Route::get('edit-post/{id}', ['as' => 'super_admin.faq.edit.post', 'uses' => 'FaqController@postEdit']);
        Route::post('edit-post/{id}', ['as' => 'super_admin.faq.edit.post', 'uses' => 'FaqController@postEditProcess']);
        Route::get('delete-post/{id}', ['as' => 'super_admin.faq.delete.post', 'uses' => 'FaqController@postDelete']);

    });
    
    
    //Beginning Password Reset

    Route::get('password/email', ['as' => 'super_admin.password.email', 'uses' => 'Auth\SuperAdminPasswordController@getEmail']);
    Route::post('password/email', ['as' => 'super_admin.send.password', 'uses' => 'Auth\SuperAdminPasswordController@sendResetLinkEmail']);

    Route::post('/password/reset', ['as' => 'super_admin.password.reset.submit', 'uses' => 'Auth\SuperAdminPasswordController@reset']);

    Route::get('/password/reset/{token?}', ['as' => 'super_admin.password.reset', 'uses' => 'Auth\SuperAdminPasswordController@showResetForm']);
    //End Password Reset

    Route::get('dashboard', ['as' => 'super_admin.dashboard', 'uses' => 'SuperAdminController@dashboard']);

    Route::get('profile/id/edit', ['as' => 'super_admin.profile', 'uses' => 'SuperAdminController@profile']);

    Route::put('profile/{id}/edit', ['as' => 'super_admin.profile.update', 'uses' => 'SuperAdminController@profileUpdate']);

    Route::get('/{id}/passport', ['as' => 'super_admin.passport.edit', 'uses' => 'SuperAdminController@passport']);

    Route::post('/{id}/passport', ['as' => 'super_admin.passport.update', 'uses' => 'SuperAdminController@passportUpdate']);
    
    //sms
    Route::get('/sms/view', ['as' => 'super_admin.view.sms', 'uses' => 'SuperAdminController@smsView']);
    Route::post('/sms/view', ['as' => 'super_admin.view.sms', 'uses' => 'SuperAdminController@smsPostView']);
    Route::post('/sms/post', ['as' => 'super_admin.post.sms', 'uses' => 'SuperAdminController@smsPost']);

    //bulk student delete
    Route::get('/studentblukdelete/view', ['as' => 'super_admin.view.studentblukdelete', 'uses' => 'SuperAdminController@studentblukdeleteView']);
    Route::post('/studentblukdelete/view', ['as' => 'super_admin.view.studentblukdelete', 'uses' => 'SuperAdminController@studentblukdeletePostView']);
    Route::post('/studentblukdelete/post', ['as' => 'super_admin.post.studentblukdelete', 'uses' => 'SuperAdminController@studentblukdeletePost']);

    // unity
    Route::get('/unity/view', ['as' => 'super_admin.view.unity', 'uses' => 'SuperAdminController@unityView']);
    Route::post('/unity/create-center', ['as' => 'super_admin.unity.create.center', 'uses' => 'SuperAdminController@unityCreateCenter']);
    Route::post('/unity/create-center', ['as' => 'super_admin.unity.create.center', 'uses' => 'SuperAdminController@unityCreateCenter']);
    Route::post('/unity/delete-center', ['as' => 'super_admin.unity.delete.center', 'uses' => 'SuperAdminController@unityDeleteCenter']);
    Route::post('/unity/create-hall', ['as' => 'super_admin.unity.create.hall', 'uses' => 'SuperAdminController@unityCreateHall']);
    Route::post('/unity/delete-hall', ['as' => 'super_admin.unity.delete.hall', 'uses' => 'SuperAdminController@unityDeleteHall']);
    Route::post('/unity/view-centers', ['as' => 'super_admin.unity.view.centers', 'uses' => 'SuperAdminController@unityViewCenters']);
    Route::post('/unity/assign-students', ['as' => 'super_admin.unity.assign.students', 'uses' => 'SuperAdminController@unityAssignStudents']);
    Route::post('/unity/assign-students/post', ['as' => 'super_admin.unity.assign.students.post', 'uses' => 'SuperAdminController@unityAssignStudentsPost']);

    
    

    Route::group(['prefix' => 'scratch-card'], function(){

        Route::pattern('id', '[0-9]+');

        Route::get('/view', ['as' => 'super_admin.view.scratch_card', 'uses' => 'ScratchCardController@viewScratchCard']);
        Route::post('/generate', ['as' => 'super_admin.generate.scratch_card', 'uses' => 'ScratchCardController@generateScratchCard']);
        Route::delete('/view', ['as' => 'super_admin.delete.scratch_card', 'uses' => 'ScratchCardController@deleteScratchCard']);


    });

    Route::group(['prefix' => 'exam-scratch-card'], function(){

        Route::get('/view', ['as' => 'super_admin.view.exam_scratch_card', 'uses' => 'ExamsVoucherController@viewScratchCard']);
        Route::post('/generate', ['as' => 'super_admin.generate.exam_scratch_card', 'uses' => 'ExamsVoucherController@generateScratchCard']);
        Route::delete('/view', ['as' => 'super_admin.delete.exam_scratch_card', 'uses' => 'ExamsVoucherController@deleteScratchCard']);
    });

    Route::group(['prefix' => 'school'], function(){

        Route::get('view', ['as' => 'super_admin.view.school', 'uses' => 'SuperAdminController@viewSchool']);

        Route::get('create', ['as' => 'super_admin.create.school', 'uses' => 'SuperAdminController@createSchool']);

        Route::post('create', ['as' => 'super_admin.register.school', 'uses' => 'SuperAdminController@registerSchool']);

        Route::get('batch-create', ['as' => 'super_admin.batch.create.school', 'uses' => 'SchoolController@batchCreate']);

        Route::post('batch-create', ['as' => 'super_admin.batch.register.school', 'uses' => 'SchoolController@batchRegister']);

        Route::get('{id}/edit', ['as' => 'super_admin.edit.school', 'uses' => 'SuperAdminController@editSchool']);

        Route::post('{id}/edit', ['as' => 'super_admin.update.school', 'uses' => 'SuperAdminController@updateSchool']);

        Route::delete('{id}/delete', ['as' => 'super_admin.delete.school', 'uses' => 'SuperAdminController@deleteSchool']);
    });

    Route::group(['prefix' => 'primary-school'], function(){

        Route::get('view', ['as' => 'super_admin.view.primary.school', 'uses' => 'PrimarySchoolController@view']);

        Route::get('batch-create', ['as' => 'super_admin.batch.create.primary.school', 'uses' => 'PrimarySchoolController@batchCreate']);

        Route::post('batch-create', ['as' => 'super_admin.batch.register.primary.school', 'uses' => 'PrimarySchoolController@batchRegister']);

        Route::get('{id}/edit', ['as' => 'super_admin.edit.primary.school', 'uses' => 'PrimarySchoolController@edit']);

        Route::post('{id}/edit', ['as' => 'super_admin.update.primary.school', 'uses' => 'PrimarySchoolController@update']);

        Route::delete('{id}/delete', ['as' => 'super_admin.delete.primary.school', 'uses' => 'PrimarySchoolController@delete']);
    });

    Route::group(['prefix' => 'subject'], function(){

        Route::get('/view', ['as' => 'super.admin.view.school.subjects', 'uses' => 'SubjectsController@superAdminViewSchoolSubjects']);

        Route::post('/view', ['as' => 'super.admin.view.school.subjects.post', 'uses' => 'SubjectsController@superAdminViewSchoolSubjectsPost']);

        Route::get('/create', ['as' => 'super.admin.create.school.subjects', 'uses' => 'SubjectsController@adminCreateSchoolSubjects']);

        Route::get('/batch-create', ['as' => 'super.admin.batch.create.school.subjects', 'uses' => 'SubjectsController@adminBatchCreateSchoolSubjects']);

        Route::post('/batch-create', ['as' => 'super.admin.batch.register.school.subjects', 'uses' => 'SubjectsController@adminBatchRegisterSchoolSubjects']);

        Route::post('/create', ['as' => 'super.admin.register.school.subjects', 'uses' => 'SubjectsController@adminRegisterSchoolSubjects']);

        Route::get('{id}/edit', ['as' => 'super.admin.edit.school.subjects', 'uses' => 'SubjectsController@adminEditSchoolSubject']);
        
        Route::put('{id}/edit', ['as' => 'super.admin.update.school.subjects', 'uses' => 'SubjectsController@adminUpdateSchoolSubject']);

        Route::delete('{id}/delete', ['as' => 'super.admin.delete.school.subjects', 'uses' => 'SubjectsController@adminDeleteSchoolSubject']);

    });

    Route::group(['prefix' => 'school-admin'], function(){

        Route::get('view', ['as' => 'super_admin.view.school.admin', 'uses' => 'SuperAdminController@viewSchoolAdmin']);

        Route::get('create', ['as' => 'super_admin.create.school.admin', 'uses' => 'SuperAdminController@createSchoolAdmin']);

        Route::post('create', ['as' => 'super_admin.register.school.admin', 'uses' => 'SuperAdminController@registerSchoolAdmin']);

        Route::get('{id}/edit', ['as' => 'super_admin.edit.school.admin', 'uses' => 'SuperAdminController@editSchoolAdmin']);

        Route::post('{id}/edit', ['as' => 'super_admin.update.school.admin', 'uses' => 'SuperAdminController@updateSchoolAdmin']);

        Route::delete('{id}/delete', ['as' => 'super_admin.delete.school.admin', 'uses' => 'SuperAdminController@deleteSchoolAdmin']);

    });

    Route::group(['prefix' => 'student'], function(){

        Route::get('view', ['as' => 'super_admin.view.student', 'uses' => 'SuperAdminController@viewStudent']);

        Route::post('view', ['as' => 'super_admin.view.student.post', 'uses' => 'SuperAdminController@viewStudentPage']);

        Route::get('create', ['as' => 'super_admin.create.student', 'uses' => 'SuperAdminController@createStudent']);

        Route::post('create', ['as' => 'super_admin.register.student', 'uses' => 'SuperAdminController@registerStudent']);

        Route::get('batch-create', ['as' => 'super_admin.batch.create.student', 'uses' => 'SuperAdminController@batchCreateStudent']);

        Route::post('batch-create', ['as' => 'super_admin.batch.register.student', 'uses' => 'SuperAdminController@batchRegisterStudent']);

        Route::get('{id}/edit', ['as' => 'super_admin.edit.student', 'uses' => 'SuperAdminController@editStudent']);

        Route::put('{id}/edit', ['as' => 'super_admin.update.student', 'uses' => 'SuperAdminController@updateStudent']);

        Route::delete('{id}/delete', ['as' => 'super_admin.delete.student', 'uses' => 'SuperAdminController@deleteStudent']);

    });

    Route::group(['prefix' => 'teacher'], function(){

        Route::get('view', ['as' => 'super_admin.view.teacher', 'uses' => 'SuperAdminController@viewTeacher']);

        Route::post('view', ['as' => 'super_admin.view.teacher.post', 'uses' => 'SuperAdminController@viewTeacherPage']);

        Route::get('create', ['as' => 'super_admin.create.teacher', 'uses' => 'SuperAdminController@createTeacher']);

        Route::post('create', ['as' => 'super_admin.register.teacher', 'uses' => 'SuperAdminController@registerTeacher']);

        Route::get('batch-create', ['as' => 'super_admin.batch.create.teacher', 'uses' => 'SuperAdminController@batchCreateTeacher']);

        Route::post('batch-create', ['as' => 'super_admin.batch.register.teacher', 'uses' => 'SuperAdminController@batchRegisterTeacher']);

        Route::get('{id}/edit', ['as' => 'super_admin.edit.teacher', 'uses' => 'SuperAdminController@editTeacher']);

        Route::post('{id}/edit', ['as' => 'super_admin.update.teacher', 'uses' => 'SuperAdminController@updateTeacher']);

        Route::delete('{id}/delete', ['as' => 'super_admin.delete.teacher', 'uses' => 'SuperAdminController@deleteTeacher']);

    });

    Route::group(['prefix' => 'school-id-card'], function(){

        //Route::get('generate', ['as' => 'super_admin.generate.school-id-card-template', 'uses' => 'SchoolIDCardController@generateSchoolIDTemplate']);

        //Route::post('generate', ['as' => 'super_admin.generate.school-id-card-template.submit', 'uses' => 'SchoolIDCardController@generateSchoolIDTemplateSUbmit']);

        Route::get('view', ['as' => 'super_admin.view.school-id-card-template', 'uses' => 'SchoolIDCardController@viewSchoolIDTemplate']);

        Route::get('{id}/generate', ['as' => 'super_admin.generate.school-id-card-template', 'uses' => 'SchoolIDCardController@generateSchoolIDTemplate']);

        Route::post('{id}/generate', ['as' => 'super_admin.generate.school-id-card-template.submit', 'uses' => 'SchoolIDCardController@generateSchoolIDTemplateSUbmit']);

        Route::get('view-student-for-id-card', ['as' => 'super_admin.view.student-for-id-card', 'uses' => 'SchoolIDCardController@viewStudentForIDCardGeneration']);

        Route::post('view-student-for-id-card', ['as' => 'super_admin.view.student-for-id-card.post', 'uses' => 'SchoolIDCardController@viewStudentForIDCardGenerationPage']);

        Route::post('generate-student-school-id-card', ['as' => 'super_admin.generate.student-school-id-card', 'uses' => 'SchoolIDCardController@generateStudentIDCard']);


        Route::get('{id}/download-student-id-card', ['as' => 'super_admin.download.student-idcard', 'uses' => 'SchoolIDCardController@downloadStudentIDCard']);



    });

    Route::group(['prefix' => 'transfer'], function(){
        Route::get('/view-history', ['as' =>  'super_admin.view.transfer.history', 'uses' => 'TransferController@superAdminViewTransferHistory']);
        Route::get('{id}/view-transter', ['as' =>  'super_admin.view.transfer', 'uses' => 'TransferController@superAdminViewTransferLetter']);
    });




    Route::get('{id}/password-update', ['as' => 'super_admin.password.edit', 'uses' => 'SuperAdminController@password']);

    Route::post('{id}/password-update', ['as' => 'super_admin.password.update', 'uses' => 'SuperAdminController@passwordUpdate']);

    Route::get('/create-user-view', ['as' => 'super_admin.create.user.view', 'uses' => 'SuperAdminController@createUserView']);
    Route::post('/create-user', ['as' => 'super_admin.create.user', 'uses' => 'SuperAdminController@createUser']);

    Route::get('/edit-permissions', ['as' => 'super_admin.permission.view', 'uses' => 'SuperAdminController@permissionsView']);

    Route::post('/edit-permissions', ['as' => 'super_admin.permission.view.teacher.post', 'uses' => 'SuperAdminController@permissionViewTeacherPage']);
    Route::post('/edit-permissions/view', ['as' => 'super_admin.view.user.permissions', 'uses' => 'SuperAdminController@viewUserPermissions']);
    Route::post('/edit-permissions/get-classarm', ['as' => 'super_admin.get.classarm', 'uses' => 'SuperAdminController@getClassarm']);


    Route::get('/edit-user-permissions/{usertype}/{id}', ['as' => 'super_admin.user.permission.view', 'uses' => 'SuperAdminController@permissionUserViewPage']);

    Route::post('/edit-user-permissions/{usertype}/{id}', ['as' => 'super_admin.update.user.permissions', 'uses' => 'SuperAdminController@updateUserPermissions']);

    //Route::post('/promotion-stamp',  ['as' => 'admin.promotion.stamp.student.result', 'uses' => 'StudentResultController@adminPromotionStampStudentResultProcess']);
    



//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////  START: TASK  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

    Route::get('task/create-new', ['as' => 'super_admin.task.create.new', 'uses' => 'TaskController@createTask']);
    Route::post('task/create-new', ['as' => 'super_admin.task.create.new', 'uses' => 'TaskController@createTaskProcess']);
    Route::get('task/view-all', ['as' => 'super_admin.task.view.all', 'uses' => 'TaskController@viewTasks']);

    Route::get('task/board/{id}', ['as' => 'super_admin.task.board', 'uses' => 'TaskController@viewTaskBoard']);
    Route::post('task/assign-members', ['as' => 'super_admin.task.assign.members', 'uses' => 'TaskController@assignMembers']);
    
    
});

Route::group(['prefix' => 'admin'], function(){


    Route::get('login', ['as' => 'admin.login', 'uses' => 'Auth\AdminAuthController@showLoginForm']);

    Route::post('login', ['as' => 'admin.login.submit', 'uses' => 'Auth\AdminAuthController@login']);

    Route::get('logout', ['as' => 'admin.logout', 'uses' => 'Auth\AdminAuthController@logout']);

    //Beginning Password Reset

    Route::get('password/email', ['as' => 'admin.password.email', 'uses' => 'Auth\AdminPasswordController@getEmail']);
    Route::post('password/email', ['as' => 'admin.send.password', 'uses' => 'Auth\AdminPasswordController@sendResetLinkEmail']);

    Route::post('/password/reset', ['as' => 'admin.password.reset.submit', 'uses' => 'Auth\AdminPasswordController@reset']);

    Route::get('/password/reset/{token?}', ['as' => 'admin.password.reset', 'uses' => 'Auth\AdminPasswordController@showResetForm']);
    //End Password Reset
    
    // E-learning
    Route::get('e-learning', ['as' => 'admin.e-learning', 'uses' => 'AdminController@eLearning']);
    
    // Survey
    Route::get('school-survey/{session}', ['as' => 'admin.school-survey', 'uses' => 'AdminController@schoolSurvey']);
    Route::get('school-survey-view/{session}', ['as' => 'admin.school-survey-view', 'uses' => 'AdminController@schoolSurveyView']);
    Route::post('school-survey/{session}', ['as' => 'admin.school-survey', 'uses' => 'AdminController@schoolSurveySave']);
    
    // school annual-asset
    Route::get('school-annual-asset', ['as' => 'admin.school.annual-asset', 'uses' => 'AdminController@annualAssetView']);
    Route::post('school-annual-asset', ['as' => 'admin.school.annual-asset', 'uses' => 'AdminController@annualAssetAction']);
    Route::get('school-annual-asset-doc-preview/{session}', ['as' => 'admin.school.annual-asset-doc-preview', 'uses' => 'AdminController@annualAssetDocPreView']);
    
    // school id-card-request
    Route::get('school-id-card-request', ['as' => 'admin.school.id-card-request', 'uses' => 'AdminController@schoolIdCardRequestView']);
    Route::post('school-id-card-request', ['as' => 'admin.school.id-card-request', 'uses' => 'AdminController@schoolIdCardRequestAction']);
    
    // school transactions
    Route::get('school-transactions', ['as' => 'admin.school.transactions', 'uses' => 'AdminController@schoolTransactionsView']);
    
    // school wallet
    Route::get('school-wallet', ['as' => 'admin.school.wallet', 'uses' => 'AdminController@schoolWalletView']);
    Route::post('school-wallet', ['as' => 'admin.school.wallet', 'uses' => 'AdminController@schoolPaymentVerify']);
    Route::post('school-wallet-student-search', ['as' => 'admin.school.wallet.student.search', 'uses' => 'AdminController@schoolStudentSearch']);
    Route::post('school-wallet-student-reciept-search', ['as' => 'admin.school.wallet.student.reciept.search', 'uses' => 'AdminController@schoolStudentRecieptSearch']);
    

    //bulk student delete
    //Route::get('/studentblukdelete/view', ['as' => 'admin.view.studentblukdelete', 'uses' => 'StudentsController@studentblukdeleteView']);
    //Route::post('/studentblukdelete/view', ['as' => 'admin.view.studentblukdelete', 'uses' => 'StudentsController@studentblukdeletePostView']);
    //Route::post('/studentblukdelete/post', ['as' => 'admin.post.studentblukdelete', 'uses' => 'StudentsController@studentblukdeletePost']);

    Route::get('zip/batch-upload-image-view', ['as' => 'admin.image.zip.view', 'uses' => 'AdminController@userImageZipUploadView']);
    Route::post('zip/batch-upload-image-extract', ['as' => 'admin.image.zip.extract', 'uses' => 'AdminController@userImageZipUploadExtract']);


    Route::get('zip/batch-upload-image-async', ['as' => 'admin.image.zip.async', 'uses' => 'AdminController@userImageZipUploadAjax']);
    Route::post('zip/batch-upload-image-async-process', ['as' => 'admin.image.zip.async.process', 'uses' => 'AdminController@userImageZipUploadAjaxProcess']);



    Route::get('student-verification', ['as' => 'admin.student.verification', 'uses' => 'StudentsController@studentVerificationView']);
    Route::post('student-verification', ['as' => 'admin.student.verification', 'uses' => 'StudentsController@studentVerification']);

    Route::get('statistics', ['as' => 'admin.school.statistics', 'uses' => 'AdminController@userStatistics']);

    //quick search
    Route::post('quick-search', ['as' => 'admin.quick-search', 'uses' => 'AdminController@quickSearch']);
    
    // quick edit
    //Route::get('quick-edit/student/{id}', ['as' => 'admin.quick-edit.student.{id}', 'uses' => 'AdminController@quickEditStudentView']);
    //Route::post('quick-edit/student/{id}', ['as' => 'admin.quick-edit.student.{id}', 'uses' => 'AdminController@quickEditStudentEdit']);
    
    Route::get('quick-edit/student/{id}', ['as' => 'admin.quick-edit.student', 'uses' => 'StudentsController@quickEditStudentView']);
    Route::put('quick-edit/student/{id}', ['as' => 'admin.quick-edit.student', 'uses' => 'StudentsController@quickEditStudentSubmit']);

    //time table
    Route::get('school-timetable', ['as' => 'admin.school.timetable', 'uses' => 'AdminController@schoolTimetable']);
    Route::any('school-timetable-view', ['as' => 'admin.school.timetable.view', 'uses' => 'AdminController@schoolTimetableMakeView']);
    Route::post('school-timetable-make', ['as' => 'admin.school.create.timetable', 'uses' => 'AdminController@schoolTimetableMake']);
    Route::post('school-timetable-delete', ['as' => 'admin.school.delete.timetable', 'uses' => 'AdminController@schoolTimetableDelete']);

    Route::get('school-timetable-edit/{id}', ['as' => 'admin.school.edit.timetable', 'uses' => 'AdminController@schoolTimetableEditView']);
    Route::post('school-timetable-edit', ['as' => 'admin.school.edit.timetable', 'uses' => 'AdminController@schoolTimetableEdit']);
    Route::post('school-timetable-edit-delete', ['as' => 'admin.school.edit.timetable.delete', 'uses' => 'AdminController@schoolTimetableEditDelete']);

    Route::post('school-timetable-print', ['as' => 'admin.school.timetable.print', 'uses' => 'AdminController@schoolTimetablePrint']);

    
//  Route::get('payment/option', ['as' => 'admin.payment.option', 'uses' => 'PaymentController@paymentOption']);
//  Route::get('payment/set-data', ['as' => 'admin.payment.data', 'uses' => 'PaymentController@paymentData']);
//  Route::post('payment/set-data', ['as' => 'admin.payment.data', 'uses' => 'PaymentController@paymentDataProcess']);
//  Route::get('payment/set-gateway-data/{id}', ['as' => 'admin.payment.gateway.data', 'uses' => 'PaymentController@paymentGatewayDataReady']);
//  Route::get('payment/get-gateway-return-data', ['as' => 'admin.payment.gateway.return.data', 'uses' => 'PaymentController@paymentGatewayReturnData']);
//  Route::get('payment/fetch-gateway-data-status/{id}', ['as' => 'admin.payment.gateway.data.status', 'uses' => 'PaymentController@paymentGatewayDataStatus']);
    
    
    //Route::get('get-curl', 'PaymentController@getCurl');
    Route::get('payment/option', ['as' => 'admin.payment.option', 'uses' => 'PaymentController@paymentOption']);
    Route::get('payment/offline', ['as' => 'admin.payment.offline', 'uses' => 'PaymentController@offlinePayment']);
    Route::post('payment/offline', ['as' => 'admin.payment.offline', 'uses' => 'PaymentController@offlinePaymentSave']);
    Route::post('payment/offline-get-students', ['as' => 'admin.payment.offline.get.students', 'uses' => 'PaymentController@offlinePaymentGetStudent']);
    Route::post('payment/offline-search-invoice', ['as' => 'admin.payment.offline.search.invoice', 'uses' => 'PaymentController@offlinePaymentSearchInvoice']);
    Route::post('payment/offline-confirm_payment', ['as' => 'admin.payment.offline.confirm.payment', 'uses' => 'PaymentController@offlinePaymentConfirmPayment']);
    

    Route::get('payment/unverified-set-data', ['as' => 'admin.payment.unverified.data', 'uses' => 'PaymentController@postUnverifiedPaymentData']);
    Route::post('payment/unverified-set-data', ['as' => 'admin.payment.unverified.data', 'uses' => 'PaymentController@postUnverifiedPaymentDataProcess']);

    Route::get('payment/set-data', ['as' => 'admin.payment.data', 'uses' => 'PaymentController@paymentData']);
    Route::post('payment/set-data', ['as' => 'admin.payment.data', 'uses' => 'PaymentController@paymentDataProcess']);
    Route::post('payment/set-data-ajax', ['as' => 'admin.payment.data.ajax', 'uses' => 'PaymentController@paymentAjaxDataProcess']);
    Route::get('payment/set-gateway-data/{id}', ['as' => 'admin.payment.gateway.data', 'uses' => 'PaymentController@paymentGatewayDataReady']);
    Route::get('payment/get-gateway-return-data', ['as' => 'admin.payment.gateway.return.data', 'uses' => 'PaymentController@paymentGatewayReturnData']);
    Route::get('payment/get-gateway-notification', ['as' => 'admin.payment.gateway.notification', 'uses' => 'PaymentController@paymentGatewayNotification']);
    
    Route::get('payment/all-transaction-verified', ['as' => 'admin.payment.all.transaction.verified', 'uses' => 'PaymentController@paymentTransactionVerified']);
    Route::get('payment/all-transaction-unverified', ['as' => 'admin.payment.all.transaction.unverified', 'uses' => 'PaymentController@paymentTransactionUnverified']);
    Route::get('payment/fetch-gateway-data-status/{id}', ['as' => 'admin.payment.gateway.data.status', 'uses' => 'PaymentController@paymentFetchDataStatus']);
    Route::get('payment/transaction-details/{id}', ['as' => 'admin.payment.transaction.details', 'uses' => 'PaymentController@paymentDetails']);

    Route::post('payment/add-student-to-cart', ['as' => 'admin.payment.add.student.cart', 'uses' => 'PaymentController@addStudentToCart']);
    Route::post('payment/load-cart-student', ['as' => 'admin.payment.load.cart.student', 'uses' => 'PaymentController@loadCartStudent']);
    Route::post('payment/delete-student-cart', ['as' => 'admin.payment.delete.student.cart', 'uses' => 'PaymentController@deleteStudentFromCart']);

    Route::post('payment/online-get-students', ['as' => 'admin.payment.online.get.students', 'uses' => 'PaymentController@onlinePaymentGetStudent']);


    Route::get('payment/set-data-bankit', ['as' => 'admin.payment.data.bankit', 'uses' => 'PaymentController@paymentBankItData']);
    Route::post('payment/set-data-bankit', ['as' => 'admin.payment.data.bankit', 'uses' => 'PaymentController@paymentBankItDataProcess']);

    Route::post('payment/set-data-bankit-ajax', ['as' => 'admin.payment.data.bankit.ajax', 'uses' => 'PaymentController@paymentBankItAjaxDataProcess']);
    
    Route::get('payment/set-gateway-data-bankit/{id}', ['as' => 'admin.payment.gateway.data.bankit', 'uses' => 'PaymentController@paymentGatewayBankItDataReady']);
    Route::get('payment/get-gateway-return-data-bankit', ['as' => 'admin.payment.gateway.return.data.bankit', 'uses' => 'PaymentController@paymentGatewayReturnBankItData']);
    Route::post('payment/get-gateway-return-data-bankit', ['as' => 'admin.payment.gateway.return.data.bankit', 'uses' => 'PaymentController@paymentGatewayReturnBankItDataProcess']);
    Route::get('payment/view-gateway-return-data-bankit/{id}', ['as' => 'admin.payment.view.return.data.bankit', 'uses' => 'PaymentController@paymentViewReturnBankItData']);



//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////  START: Library  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

    Route::get('library/create-category', ['as' => 'admin.library.create.category', 'uses' => 'LibraryController@libraryCategoryCreate']);
    Route::post('library/create-category', ['as' => 'admin.library.create.category', 'uses' => 'LibraryController@libraryCategoryCreateProcess']);
    Route::get('library/all-category', ['as' => 'admin.library.all.category', 'uses' => 'LibraryController@libraryCategoryAll']);
    Route::get('library/edit-category/{id}', ['as' => 'admin.library.edit.category', 'uses' => 'LibraryController@libraryCategoryEdit']);
    Route::post('library/edit-category/{id}', ['as' => 'admin.library.edit.category', 'uses' => 'LibraryController@libraryCategoryEditProcess']);
    Route::post('library/delete-category/{id}', ['as' => 'admin.library.delete.category', 'uses' => 'LibraryController@libraryCategoryDelete']);

    Route::get('library/add-book', ['as' => 'admin.library.add.book', 'uses' => 'LibraryController@libraryBookAdd']);
    Route::post('library/add-book', ['as' => 'admin.library.add.book', 'uses' => 'LibraryController@libraryBookAddProcess']);
    Route::get('library/all-book', ['as' => 'admin.library.all.book', 'uses' => 'LibraryController@libraryBookAll']);

    Route::get('library/book-details/{id}', ['as' => 'admin.library.book.details', 'uses' => 'LibraryController@libraryBookDetails']);

    Route::get('library/edit-book/{id}', ['as' => 'admin.library.book.edit', 'uses' => 'LibraryController@libraryBookEdit']);
    Route::post('library/edit-book/{id}', ['as' => 'admin.library.book.edit', 'uses' => 'LibraryController@libraryBookEditProcess']);

    Route::get('library/edit-book-copies/{id}', ['as' => 'admin.library.book.copies.edit', 'uses' => 'LibraryController@libraryBookCopyEdit']);
    Route::post('library/edit-book-copies/{id}', ['as' => 'admin.library.book.copies.edit', 'uses' => 'LibraryController@libraryBookCopyEditProcess']);

    Route::get('library/issue-book', ['as' => 'admin.library.issue.book', 'uses' => 'LibraryController@libraryBookIssue']);
    Route::post('library/issue-book', ['as' => 'admin.library.issue.book', 'uses' => 'LibraryController@libraryBookIssueProcess']);

    Route::post('library/get-students', ['as' => 'admin.library.get.students', 'uses' => 'LibraryController@getStudents']);
    Route::post('library/get-category-books', ['as' => 'admin.library.get.category.books', 'uses' => 'LibraryController@getCategoryBooks']);

    Route::get('library/return-book', ['as' => 'admin.library.return.book', 'uses' => 'LibraryController@libraryBookReturn']);
    Route::post('library/return-book', ['as' => 'admin.library.return.book', 'uses' => 'LibraryController@libraryBookReturnProcess']);

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////  END: Library  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   


        Route::get('faq/view-all', ['as' => 'admin.faq.view', 'uses' => 'FaqController@allPostAdmin']);



    Route::get('edit-school-result-data', ['as' => 'admin.edit-school-result-data', 'uses' => 'AdminController@userEditSchoolResultData']);

    Route::post('edit-school-result-data', ['as' => 'admin.edit-school-result-data', 'uses' => 'AdminController@userEditSchoolResultDataSubmit']);



    Route::get('dashboard', ['as' => 'admin.dashboard', 'uses' => 'AdminController@dashboard']);

    Route::get('profile/edit', ['as' => 'admin.profile', 'uses' => 'AdminController@userProfile']);

    Route::put('profile/edit', ['as' => 'admin.profile.update', 'uses' => 'AdminController@userProfileUpdate']);

    Route::get('profile/edit-logo', ['as' => 'admin.profile.edit-logo', 'uses' => 'AdminController@userProfileEditLogoView']);

    Route::post('profile/edit-logo', ['as' => 'admin.profile.edit-logo', 'uses' => 'AdminController@userProfileEditLogo']);

    Route::get('password-update', ['as' => 'admin.password.edit', 'uses' => 'AdminController@password']);

    Route::post('password-update', ['as' => 'admin.password.update', 'uses' => 'AdminController@passwordUpdate']);

    Route::group(['prefix' => 'user'], function(){
        Route::pattern('id', '[0-9]+');

        Route::get('/view', ['as' => 'admin.view.school.users', 'uses' => 'AdminController@adminViewSchoolUsers']);

        Route::post('/view', ['as' => 'user.view.school.users.post', 'uses' => 'AdminController@adminViewSchoolUsersPost']);

        Route::get('/create', ['as' => 'admin.create.school.users', 'uses' => 'AdminController@adminCreateSchoolUsers']);

        Route::get('/batch-create', ['as' => 'admin.batch.create.school.users', 'uses' => 'AdminController@adminBatchCreateSchoolUsers']);

        Route::post('/create', ['as' => 'admin.register.school.users', 'uses' => 'AdminController@adminRegisterSchoolUsers']);

        Route::post('/batch-create', ['as' => 'admin.batch.register.school.users', 'uses' => 'AdminController@adminBatchRegisterSchoolUsers']);

        Route::get('{id}/edit', ['as' => 'admin.edit.school.user', 'uses' => 'AdminController@adminEditSchoolUser']);

        Route::put('{id}/edit', ['as' => 'admin.update.school.user', 'uses' => 'AdminController@adminUpdateSchoolUser']);

        Route::delete('{id}/delete', ['as' => 'admin.delete.school.user', 'uses' => 'AdminController@adminDeleteSchoolUser']);
    });


    Route::group(['prefix' => 'student'], function(){
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.school.students', 'uses' => 'StudentsController@adminViewSchoolStudents']);

            Route::post('/view', ['as' => 'admin.viev.school.students.page', 'uses' => 'StudentsController@adminViewSchoolStudentsPage']);

            Route::get('/create', ['as' => 'admin.create.school.students', 'uses' => 'StudentsController@adminCreateSchoolStudents']);

            Route::post('/create', ['as' => 'admin.register.school.students', 'uses' => 'StudentsController@adminRegisterSchoolStudents']);
            
            Route::get('/batch-create', ['as' => 'admin.batch.create.school.students', 'uses' => 'StudentsController@adminBatchCreateSchoolStudents']);

            Route::post('/batch-create', ['as' => 'admin.batch.register.school.students', 'uses' => 'StudentsController@adminBatchRegisterSchoolStudents']);
            
            Route::get('/student-search-subjects', ['as' => 'admin.students.search.subjects', 'uses' => 'StudentsController@adminStudentsDeregisterSubjectsSearch']);

            Route::post('/student-list-subjects', ['as' => 'admin.students.list.subjects', 'uses' => 'StudentsController@adminStudentsDeregisterSubjectsList']);
            
            
            Route::get('/view-floating', ['as' => 'admin.view.floating.student', 'uses' => 'StudentsController@adminViewFloatingStudents']);

            Route::post('fetch-school-floating-student', ['as' => 'admin.fetch.floating.students', 'uses' => 'StudentsController@adminFetchFloatingStudents']);

            Route::get('{id}/move-to-classarm', ['as' => 'admin.move.student.to.classarm', 'uses' => 'StudentsController@adminFloatingStudentToClassArm']);

            Route::post('/move-to-classarm', ['as' => 'admin.move.student.to.classarm.submit', 'uses' => 'StudentsController@adminFloatingStudentToClassArmSubmit']);
            

            Route::get('/nominal-roll', ['as' => 'admin.student.nominal.roll', 'uses' => 'StudentsController@nominalRollStudent']);

            Route::post('/nominal-roll', ['as' => 'admin.student.nominal.roll.process', 'uses' => 'StudentsController@nominalRollStudentSubmit']);


            Route::get('{id}/edit', ['as' => 'admin.edit.school.student', 'uses' => 'StudentsController@adminEditSchoolStudent']);

            Route::put('{id}/edit', ['as' => 'admin.update.school.student', 'uses' => 'StudentsController@adminUpdateSchoolStudent']);


            Route::delete('{id}/delete', ['as' => 'admin.delete.school.student', 'uses' => 'StudentsController@adminDeleteSchoolStudent']);

            Route::group(['prefix' => 'debtor-penalty'], function(){

                Route::get('/debtor-penalty-by-class',  ['as' => 'admin.get.student.by.classarm.debtor', 'uses' => 'DebtorPenaltyController@getStudentByClassArmPage']);

                Route::post('/debtor-penalty-by-class',  ['as' => 'admin.view.student.for.debtor.penalty', 'uses' => 'DebtorPenaltyController@adminViewStudentForDebtorPenalty']);

                Route::post('/debtor-penalty',  ['as' => 'admin.view.student.for.debtor.penalty.submit', 'uses' => 'DebtorPenaltyController@adminViewStudentForDebtorPenaltySubmit']);

                Route::get('/view-debtor-penalised-student',  ['as' => 'admin.view.debtor.penalized.student', 'uses' => 'DebtorPenaltyController@adminViewDebtors']);
                
                Route::post('/view-debtor-penalised-student',  ['as' => 'admin.view.debtor.penalized.student', 'uses' => 'DebtorPenaltyController@adminViewDebtorsSubmit']);

            });
            

    });

    Route::group(['prefix' => 'teacher'], function(){
        
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.school.teachers', 'uses' => 'TeachersController@adminViewSchoolTeachers']);

            Route::post('/view', ['as' => 'admin.view.school.teachers.page', 'uses' => 'TeachersController@adminViewSchoolTeachersPage']);

            Route::get('/create', ['as' => 'admin.create.school.teachers', 'uses' => 'TeachersController@adminCreateSchoolTeachers']);

            Route::post('/create', ['as' => 'admin.register.school.teachers', 'uses' => 'TeachersController@adminRegisterSchoolTeachers']);

            Route::get('/batch-create', ['as' => 'admin.batch.create.school.teachers', 'uses' => 'TeachersController@adminBatchCreateSchoolTeachers']);

            Route::post('/batch-create', ['as' => 'admin.batch.register.school.teachers', 'uses' => 'TeachersController@adminBatchRegisterSchoolTeachers']);

            Route::get('{id}/edit', ['as' => 'admin.edit.school.teachers', 'uses' => 'TeachersController@adminEditSchoolTeacher']);
            
            Route::put('{id}/edit', ['as' => 'admin.update.school.teachers', 'uses' => 'TeachersController@adminUpdateSchoolTeacher']);

            Route::delete('{id}/delete', ['as' => 'admin.delete.school.teachers', 'uses' => 'TeachersController@adminDeleteSchoolTeacher']);

    });

    Route::group(['prefix' => 'subject'], function(){
        
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.school.subjects', 'uses' => 'SubjectsController@adminViewSchoolSubjects']);

            Route::post('/view', ['as' => 'admin.view.school.subjects.post', 'uses' => 'SubjectsController@adminViewSchoolSubjectsPost']);

    });

    Route::group(['prefix' => 'class'], function(){
        
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.school.classes', 'uses' => 'ClassesController@adminViewSchoolClasses']);

            Route::post('/view', ['as' => 'admin.view.school.classes.page', 'uses' => 'ClassesController@adminViewSchoolClassesPage']);

            Route::get('/create', ['as' => 'admin.create.school.classes', 'uses' => 'ClassesController@adminCreateSchoolClasses']);

            Route::get('/batch-create', ['as' => 'admin.batch.create.school.classes', 'uses' => 'ClassesController@adminBatchCreateSchoolClasses']);

            Route::post('/batch-create', ['as' => 'admin.batch.register.school.classes', 'uses' => 'ClassesController@adminBatchRegisterSchoolClasses']);

            Route::post('/create', ['as' => 'admin.register.school.classes', 'uses' => 'ClassesController@adminRegisterSchoolClasses']);

            Route::get('{id}/edit', ['as' => 'admin.edit.school.class', 'uses' => 'ClassesController@adminEditSchoolClasses']);
            
            Route::put('{id}/edit', ['as' => 'admin.update.school.class', 'uses' => 'ClassesController@adminUpdateSchoolClasses']);

            Route::delete('{id}/delete', ['as' => 'admin.delete.school.class', 'uses' => 'ClassesController@adminDeleteSchoolClasses']);
    });

    Route::group(['prefix' => 'classarm'], function(){
        
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.school.classarms', 'uses' => 'ClassArmsController@adminViewSchoolClassarms']);

            Route::post('/view', ['as' => 'admin.view.school.classarms.page', 'uses' => 'ClassArmsController@adminViewSchoolClassarmsPage']);

            Route::get('/create', ['as' => 'admin.create.school.classarms', 'uses' => 'ClassArmsController@adminCreateSchoolClassarms']);

            Route::get('/batch-create', ['as' => 'admin.batch.create.school.classarms', 'uses' => 'ClassArmsController@adminBatchCreateSchoolClassarms']);

            Route::post('/batch-create', ['as' => 'admin.batch.register.school.classarms', 'uses' => 'ClassArmsController@adminBatchRegisterSchoolClassarms']);

            Route::post('/create', ['as' => 'admin.register.school.classarms', 'uses' => 'ClassArmsController@adminRegisterSchoolClassarms']);

            Route::get('{id}/edit', ['as' => 'admin.edit.school.classarm', 'uses' => 'ClassArmsController@adminEditSchoolClassarm']);
            
            Route::put('{id}/edit', ['as' => 'admin.update.school.classarm', 'uses' => 'ClassArmsController@adminUpdateSchoolClassarms']);

            Route::delete('{id}/delete', ['as' => 'admin.delete.school.classarm', 'uses' => 'ClassArmsController@adminDeleteSchoolClassarms']);
            
            
            Route::get('{id}/{classarmid}/{term}/{session}/student-subjects', ['as' => 'admin.student.subjects', 'uses' => 'SubjectUnofferedController@adminStudentSubjects']);
            
            Route::post('{id}/{classarmid}/{term}/{session}/student-subjects', ['as' => 'admin.student.subjects', 'uses' => 'SubjectUnofferedController@adminStudentSubjectsDeregisterProcess']);
            
            Route::get('subjects-deregister-search', ['as' => 'admin.classarm.subjects.deregister.search', 'uses' => 'SubjectUnofferedController@adminClassArmDeregisterSubjectsSearch']);
            
            Route::post('subjects-deregister-list', ['as' => 'admin.classarm.subjects.deregister.list', 'uses' => 'SubjectUnofferedController@adminClassArmDeregisterSubjectsList']);
            
            Route::post('subjects-deregister-search', ['as' => 'admin.classarm.subjects.deregister.search', 'uses' => 'SubjectUnofferedController@adminClassArmSubjectsDeregisterProcess']);


            Route::get('/reassign/view-students', ['as' => 'admin.classarm.reassign.view.students', 'uses' => 'ClassArmsController@adminClassarmsReAssignViewStudent']);

            Route::post('/reassign/view-students', ['as' => 'admin.classarm.reassign.view.students.submit', 'uses' => 'ClassArmsController@adminClassarmsReAssignViewStudentSubmit']);

            Route::post('/reassign/students-ajax-process', ['as' => 'admin.classarm.reassign.students.ajax.process', 'uses' => 'ClassArmsController@adminClassarmsReAssignStudentAjaxProcess']);
            

            Route::group(['prefix' => 'assign-subject-to-class'], function(){

                Route::pattern('id', '[0-9]+');

                Route::get('/', ['as' => 'admin.assign.subject.to.class','uses' => 'SubjectsController@adminAssignSubjectToClass']);

                Route::post('/', ['as' => 'admin.view.subject.teacher.to.assign.class.submit','uses' => 'SubjectsController@adminAssignSubjectWithTeacherToClass']);
                
                Route::post('/register', ['as' => 'admin.assign.subject.to.class.submit','uses' => 'SubjectsController@adminAssignSubjectWithTeacherToClassSubmit']);

                Route::get('{id}/edit', ['as' => 'admin.edit.assign.subject.to.class','uses' => 'SubjectsController@adminEditAssignSubjectToClass']);

                Route::put('{id}/edit', ['as' => 'admin.update.assign.subject.to.class','uses' => 'SubjectsController@adminUpdateAssignSubjectToClass']);

                Route::delete('{id}/delete', ['as' => 'admin.delete.assign.subject.to.class','uses' => 'SubjectsController@adminDeleteAssignSubjectToClass']);
                
            });

            Route::get('unassign-teacher-subjects', ['as' => 'admin.unassign.teacher.subjects', 'uses' => 'SubjectsController@adminUnassignTeacherSubject']);

            Route::post('unassign-get-teacher-subjects', ['as' => 'admin.unassign.get.teacher.subjects', 'uses' => 'SubjectsController@adminUnassignGetTeacherSubjects']);
                        
            Route::post('unassign-teacher-subjects', ['as' => 'admin.unassign.teacher.subjects', 'uses' => 'SubjectsController@adminUnassignTeacherSubjectProcess']);

            Route::get('assign-teacher-subjects', ['as' => 'admin.assign.teacher.subjects', 'uses' => 'SubjectsController@adminAssignTeacherSubject']);
                        
            Route::post('assign-teacher-subjects', ['as' => 'admin.assign.teacher.subjects', 'uses' => 'SubjectsController@adminAssignTeacherSubjectProcess']);

            Route::group(['prefix' => 'assign-teacher-to-class'], function(){

                Route::pattern('id', '[0-9]+');

                Route::get('/', ['as' => 'admin.assign.teacher.to.class','uses' => 'ClassArmsController@adminAssignTeacherToClass']);
                
                Route::post('/', ['as' => 'admin.assign.teacher.to.class.submit','uses' => 'ClassArmsController@adminAssignTeacherToClassSubmit']);

                Route::get('{id}/edit', ['as' => 'admin.edit.assign.teacher.to.class','uses' => 'ClassArmsController@adminEditAssignTeacherToClass']);

                Route::put('{id}/edit', ['as' => 'admin.update.assign.teacher.to.class','uses' => 'ClassArmsController@adminUpdateAssignTeacherToClass']);

                Route::delete('{id}/delete', ['as' => 'admin.delete.assign.teacher.to.class','uses' => 'ClassArmsController@adminDeleteAssignTeacherToClass']);
                
            });

            Route::group(['prefix' => 'assign-counsellor-to-class'], function(){

                Route::pattern('id', '[0-9]+');

                Route::get('/', ['as' => 'admin.assign.counsellor.to.class','uses' => 'ClassArmsController@adminAssignCounsellorToClass']);
                
                Route::post('/', ['as' => 'admin.assign.counsellor.to.class.submit','uses' => 'ClassArmsController@adminAssignCounsellorToClassSubmit']);

                Route::get('{id}/edit', ['as' => 'admin.edit.assign.counsellor.to.class','uses' => 'ClassArmsController@adminEditAssignCounsellorToClass']);

                Route::put('{id}/edit', ['as' => 'admin.update.assign.counsellor.to.class','uses' => 'ClassArmsController@adminUpdateAssignCounsellorToClass']);
                
            });

            Route::group(['prefix' => 'assign-student-to-class'], function(){

                Route::pattern('id', '[0-9]+');
                
                Route::get('/edit', ['as' => 'admin.edit.student.assign.to.class','uses' => 'ClassArmsController@adminEditStudentAssignToClass']);

                Route::get('/', ['as' => 'admin.assign.student.to.class','uses' => 'ClassArmsController@adminAssignStudentToClass']);
                
                Route::post('/', ['as' => 'admin.assign.student.to.class.submit','uses' => 'ClassArmsController@adminAssignStudentToClassSubmit']);

                Route::post('/next-term-class', ['as' => 'admin.assign.student.to.next.term.submit','uses' => 'ClassArmsController@adminAssignStudentToNextTermClassSubmit']);

                
                Route::post('/edit', ['as' => 'admin.edit.student.assign.to.class.submit','uses' => 'ClassArmsController@adminEditStudentAssignToClassSubmit']);

                Route::post('/edit-process', ['as' => 'admin.edit.student.assign.to.class.process','uses' => 'ClassArmsController@adminEditStudentAssignToClassProcess']);


                
            });
    });

    Route::group(['prefix' => 'result'], function(){
        
            Route::pattern('id', '[0-9]+');


            Route::get('/view-student-promotion-stamp',  ['as' => 'admin.promotion.stamp.view.student', 'uses' => 'StudentResultController@adminPromotionStampViewStudent']);

            Route::post('/view-student-promotion-stamp',  ['as' => 'admin.post.promotion.stamp.view.student', 'uses' => 'StudentResultController@adminPromotionStampViewStudentPost']);

            Route::post('/promotion-stamp',  ['as' => 'admin.promotion.stamp.student.result', 'uses' => 'StudentResultController@adminPromotionStampStudentResultProcess']);


            Route::get('/view-broadsheet', ['as' => 'admin.view.broadsheet.result', 'uses' => 'StudentResultController@adminResultBroadSheetViewForm']);

            Route::post('/view-broadsheet', ['as' => 'admin.view.broadsheet.result.submit', 'uses' => 'StudentResultController@adminResultBroadSheetViewFormSubmit']);

            Route::get('/view-session-broadsheet', ['as' => 'admin.view.session.broadsheet.result', 'uses' => 'StudentResultController@adminResultSessionBroadSheetViewForm']);

            Route::post('/view-session-broadsheet', ['as' => 'admin.view.session.broadsheet.result.submit', 'uses' => 'StudentResultController@adminResultSessionBroadSheetViewFormSubmit']);

            Route::get('/view', ['as' => 'admin.view.result.by.class.category', 'uses' => 'StudentResultController@adminViewResultByClassCategory']);

            Route::post('/view', ['as' => 'admin.view.result.by.class.category.submit', 'uses' => 'StudentResultController@adminViewResultByClassCategorySubmit']);

            Route::get('/upload-by-subject', ['as' => 'admin.view.batch.upload.result.by.subject', 'uses' => 'StudentResultController@adminViewBatchUploadResultBySubject']);

            Route::post('/class-result-config', ['as' => 'admin.view.class.result.template', 'uses' => 'StudentResultController@adminViewClassResultTemplate']);

            Route::post('/result-format/xls', ['as' => 'admin.download.class.result.format.by.subject', 'uses' => 'StudentResultController@adminDownloadClassResultFormatBySubject']);

            Route::post('/upload-class-result-by-subject', ['as' => 'admin.upload.students.result.by.subject', 'uses' => 'StudentResultController@adminUploadStudentResultBySubject']);

            Route::post('/create', ['as' => 'classesreg', 'uses' => 'StudentResultController@register']);

            Route::get('/batch-create', ['as' => 'batclassescrt', 'uses' => 'StudentResultController@batchCreate']);

            Route::post('/batch-create', 'StudentResultController@batchRegister');

            Route::get('{id}/{session}/{class_id}/{classarm_id}/{term}/edit',  ['as' => 'admin.edit.student.result', 'uses' => 'StudentResultController@adminEditStudentResult']);
            
            Route::put('edit',  ['as' => 'admin.update.student.result', 'uses' => 'StudentResultController@adminUpdateStudentResult']);

            Route::get('/view-student-lock-and-release',  ['as' => 'admin.view.lock.release.student.result', 'uses' => 'StudentResultController@adminReleaseOrLockResult']);

            Route::post('/view-student-lock-and-release',  ['as' => 'admin.post.view.lock.release.student.result', 'uses' => 'StudentResultController@adminViewStudentReleaseOrLockResult']);

            Route::post('/lock-and-release',  ['as' => 'admin.lock.release.student.result', 'uses' => 'StudentResultController@adminReleaseLockFinalResult']);

            Route::delete('{id}/delete',  ['as' => 'admin.delete.student.result', 'uses' => 'StudentResultController@adminDeleteStudentResult']);


            Route::get('/upload-all-subject', ['as' => 'admin.view.batch.upload.result.all.subject', 'uses' => 'StudentResultController@adminViewBatchUploadResultAllSubject']);

            Route::post('/class-all-result-config', ['as' => 'admin.view.class.all.result.template', 'uses' => 'StudentResultController@adminViewClassAllResultTemplate']);

            Route::post('/result-format-all-subject/xls', ['as' => 'admin.download.class.result.format.all.subject', 'uses' => 'StudentResultController@adminDownloadClassResultFormatAllSubject']);            

            Route::post('/upload-class-result-all-subject', ['as' => 'admin.upload.students.result.all.subject', 'uses' => 'StudentResultController@adminUploadStudentResultAllSubject']);    



            Route::get('/upload-comments-template', ['as' => 'admin.upload.comments.template', 'uses' => 'StudentCommentsController@adminBatchUploadCommentsTemplate']);

            Route::post('/upload-comments-template', ['as' => 'admin.upload.comments.template', 'uses' => 'StudentCommentsController@adminBatchUploadCommentsTemplateProcess']);

            Route::post('/download-comments-template/xls', ['as' => 'admin.download.comments.template', 'uses' => 'StudentCommentsController@adminDownloadCommentsTemplate']);    


            Route::get('/upload-comments', ['as' => 'admin.upload.comments', 'uses' => 'StudentCommentsController@adminBatchUploadComments']);

            Route::post('/upload-comments', ['as' => 'admin.upload.comments', 'uses' => 'StudentCommentsController@adminBatchUploadCommentsProcess']);
            
    });


    Route::group(['prefix' => 'practical-character'], function(){
        
            Route::pattern('id', '[0-9]+');

            Route::get('/view', ['as' => 'admin.view.practical.character.by.class.category', 'uses' => 'StudentPracticalAttitudeController@adminViewPraticalCharacterByClassCategory']);

            Route::post('/view', ['as' => 'admin.view.practical.character.by.class.category.submit', 'uses' => 'StudentPracticalAttitudeController@adminViewPraticalCharacterByClassCategorySubmit']);

            Route::get('/batch-upload', ['as' => 'admin.view.batch.upload.practical.character', 'uses' => 'StudentPracticalAttitudeController@adminViewBatchUploadPracticalCharacter']);

            Route::post('/batch-upload-config', ['as' => 'admin.view.class.practical.character.template', 'uses' => 'StudentPracticalAttitudeController@adminViewClassPraticalCharacterTemplate']);

            Route::post('/batch-upload-format/xls', ['as' => 'admin.download.class.practical.character.format', 'uses' => 'StudentPracticalAttitudeController@adminDownloadClassPraticalCharacterFormat']);

            Route::post('/batch-upload', ['as' => 'admin.upload.students.practical.character', 'uses' => 'StudentPracticalAttitudeController@adminUploadStudentPracticalCharacter']);

            // Route::post('/create', ['as' => 'classesreg', 'uses' => 'StudentPracticalAttitudeController@register']);

            // Route::get('/batch-create', ['as' => 'batclassescrt', 'uses' => 'StudentPracticalAttitudeController@batchCreate']);

            // Route::post('/batch-create', 'StudentPracticalAttitudeController@batchRegister');

            Route::get('{id}/{session}/{class_id}/{classarm_id}/{term}/edit',  ['as' => 'admin.edit.student.practical.attitude', 'uses' => 'StudentPracticalAttitudeController@adminEditStudentPracticalAttitude']);
            
            Route::put('edit',  ['as' => 'admin.update.student.practical.attitude', 'uses' => 'StudentPracticalAttitudeController@adminUpdateStudentPracticalCharacter']);

            Route::delete('{id}/delete',  ['as' => 'admin.delete.student.practical.attitude', 'uses' => 'StudentPracticalAttitudeController@adminDeleteStudentPracticalCharacter']);
    });


    Route::group(['prefix' => 'transfer'], function(){
            Route::get('/view-history', ['as' =>  'admin.transfer.history', 'uses' => 'TransferController@getSchoolTransferHistroy']);
            Route::get('/{id}/grant-transfer', ['as' =>  'admin.grant.transfer', 'uses' => 'TransferController@schoolAdminGrantTransfer']);
            Route::post('/{id}/grant-transfer', ['as' =>  'admin.grant.transfer.submit', 'uses' => 'TransferController@schoolAdminGrantTransferPost']);
            Route::get('/{id}/accept-transfer', ['as' =>  'admin.accept.transfer', 'uses' => 'TransferController@schoolAdminGrantTransfer']);
            Route::post('/{id}/accept-transfer', ['as' =>  'admin.accept.transfer.submit', 'uses' => 'TransferController@schoolAdminGrantTransferPost']);
            Route::get('{id}/view-transter', ['as' =>  'admin.view.transfer', 'uses' => 'TransferController@schoolAdminGrantTransfer']);
    });

    Route::group(['prefix' => 'school-house'], function(){
        Route::pattern('id', '[0-9]+');

        Route::get('/view', ['as' => 'admin.view.school.houses', 'uses' => 'StudentHouseController@adminViewSchoolHouse']);
        Route::post('/view', ['as' => 'admin.view.search.school.houses', 'uses' => 'StudentHouseController@adminViewSearchSchoolHouse']);

        Route::get('/create', ['as' => 'admin.create.school.houses', 'uses' => 'StudentHouseController@adminCreateSchoolHouse']);

        Route::post('/create', ['as' => 'admin.store.school.houses', 'uses' => 'StudentHouseController@adminStoreSchoolHouse']);

        Route::get('{id}/edit', ['as' => 'admin.edit.school.house', 'uses' => 'StudentHouseController@adminEditSchoolHouse']);

        Route::put('{id}/edit', ['as' => 'admin.update.school.house', 'uses' => 'StudentHouseController@adminUpdateSchoolHouse']);

        Route::delete('{id}/delete', ['as' => 'admin.delete.school.house', 'uses' => 'StudentHouseController@adminDeleteSchoolHouse']);

        Route::group(['prefix' => 'assign-house-master-to-house'], function(){

                Route::pattern('id', '[0-9]+');

                Route::get('/', ['as' => 'admin.assign.house.master.to.house','uses' => 'StudentsController@adminAssignHouseMasterToHouse']);
                
                Route::post('/', ['as' => 'admin.assign.house.master.to.house.submit','uses' => 'StudentsController@adminAssignHouseMasterToHouseSubmit']);

                Route::get('{id}/edit', ['as' => 'admin.edit.assign.house.master.to.house','uses' => 'StudentsController@adminEditAssignHouseMasterToHouse']);

                Route::put('{id}/edit', ['as' => 'admin.update.assign.house.master.to.house','uses' => 'StudentsController@adminUpdateAssignHouseMasterToHouse']);

                Route::delete('{id}/delete', ['as' => 'admin.delete.assign.house.master.to.house','uses' => 'StudentsController@adminDeleteAssignHouseMasterToHouse']);
                
            });
    });
    
    Route::group(['prefix' => 'transfer-teacher'], function(){
        Route::get('/view', ['as' =>  'admin.view.transfer.teachers', 'uses' => 'TransferTeacherController@viewTeachers']);

        Route::get('/new-request/{id}', ['as' => 'admin.view.transfer.new.request', 'uses' => 'TransferTeacherController@transferNewRequest']);
        Route::post('/new-request/{id}', ['as' => 'admin.view.transfer.new.request', 'uses' => 'TransferTeacherController@transferNewRequestProcess']);

        Route::get('/inward-history', ['as' =>  'admin.inward.transfer.teachers.history', 'uses' => 'TransferTeacherController@inwardTransferHistory']);
        Route::get('/outward-history', ['as' =>  'admin.outward.transfer.teachers.history', 'uses' => 'TransferTeacherController@outwardTransferHistory']);

        Route::get('/confirm-request/{id}', ['as' => 'admin.confirm.transfer.request', 'uses' => 'TransferTeacherController@transferConfirmRequest']);
        Route::post('/confirm-request/{id}', ['as' => 'admin.confirm.transfer.request', 'uses' => 'TransferTeacherController@transferConfirmRequestProcess']);

    }); 
    
});

Route::group(['prefix' => 'student'], function(){

    Route::get('login', ['as' => 'student.login', 'uses' => 'Auth\StudentAuthController@showLoginForm']);

    Route::post('login', ['as' => 'student.login.submit', 'uses' => 'Auth\StudentAuthController@login']);

    Route::get('logout', ['as' => 'student.logout', 'uses' => 'Auth\StudentAuthController@logout']);
    
    // E-learning
    Route::get('e-learning', ['as' => 'student.e-learning', 'uses' => 'StudentController@eLearning']);
    Route::post('e-learning-verify', ['as' => 'student.e-learning.verify', 'uses' => 'StudentController@eLearningVerify']);

    //Beginning Password Reset
    Route::get('password/email', ['as' => 'student.password.email', 'uses' => 'Auth\StudentPasswordController@getEmail']);
    Route::post('password/email', ['as' => 'student.send.password', 'uses' => 'Auth\StudentPasswordController@sendResetLinkEmail']);

    Route::post('/password/reset', ['as' => 'student.password.reset.submit', 'uses' => 'Auth\StudentPasswordController@reset']);

    Route::get('/password/reset/{token?}', ['as' => 'student.password.reset', 'uses' => 'Auth\StudentPasswordController@showResetForm']);
    
    Route::get('dashboard', ['as' => 'student.dashboard', 'uses' => 'StudentController@dashboard']);
    
    Route::pattern('id', '[0-9]+');
    
    Route::get('/digital-payment-reciept', ['as' => 'student.digital.payment.reciept', 'uses' => 'StudentController@digitalPaymentReciept']);   

    Route::group(['prefix' => '{id}'], function(){

        Route::get('profile/edit', ['as' => 'student.profile', 'uses' => 'StudentController@profile']);

        Route::put('profile/edit', ['as' => 'student.profile.update', 'uses' => 'StudentController@profileUpdate']);

        Route::get('passport', ['as' => 'student.passport', 'uses' => 'StudentController@passport']);

        Route::post('passport', ['as' => 'student.passport.update', 'uses' => 'StudentController@passportUpdate']);

        Route::get('result/select', ['as' => 'student.result.select', 'uses' => 'StudentController@resultSelect']);

        Route::post('result/select', ['as' => 'student.result.select.submit', 'uses' => 'StudentController@resultSelectPost']);

        Route::get('result/access', ['as' => 'student.result.access', 'uses' => 'StudentController@resultAccess']);

        Route::post('result/access', ['as' => 'student.result.access.submit', 'uses' => 'StudentController@resultAccessPost']);

        Route::get('result/view', ['as' => 'student.result.view', 'uses' => 'StudentController@resultView']);

        Route::post('result/view', ['as' => 'student.result.view.submit', 'uses' => 'StudentController@resultViewPost']);

        Route::get('password-update', ['as' => 'student.password.edit', 'uses' => 'StudentController@password']);

        Route::post('password-update', ['as' => 'student.password.update', 'uses' => 'StudentController@passwordUpdate']);
        
        Route::get('elearning-connect', ['as' => 'student.elearning.connect', 'uses' => 'StudentController@elearning_connect']);
        Route::post('elearning-connect', ['as' => 'student.elearning.connect.process', 'uses' => 'StudentController@elearning_connect_process']);
        
    });

    Route::get('transfer-form', ['as' => 'student.transfer.form', 'uses' => 'StudentController@transferForm']);

    Route::get('transfer-update-form', ['as' => 'student.transfer.update.form', 'uses' => 'StudentController@transferUpdateForm']);

    Route::get('view-transfer-history', ['as' => 'student.transfer.history', 'uses' => 'StudentController@viewTransferHistory']);

    Route::post('transfer-confirmation', ['as' => 'student.transfer.form.submit', 'uses' => 'StudentController@transferConfirmation']);

    Route::post('transfer-submit', ['as' => 'student.transfer.submission', 'uses' => 'StudentController@transferSubmission']);




});


Route::group(['prefix' => 'teacher'], function(){
    
    // E-learning
    Route::get('e-learning', ['as' => 'teacher.e-learning', 'uses' => 'TeacherController@eLearning']);
    
    Route::get('overview', ['as' => 'teacher.overview', 'uses' => 'TeacherController@teacherOverview']);
    Route::post('overview', ['as' => 'teacher.overview.submit', 'uses' => 'TeacherController@teacherOverviewSubmit']);

    Route::get('signature', ['as' => 'teacher.signature', 'uses' => 'TeacherController@teacherSignature']);

    Route::post('signature', ['as' => 'teacher.store.signature', 'uses' => 'TeacherController@teacherStoreSignature']);

    Route::get('upload-subject-result', ['as' => 'teacher.view.batch.upload.result.by.subject', 'uses' => 'TeacherController@teacherViewBatchUploadResultBySubject']);

    Route::post('class-result-config', ['as' => 'teacher.view.class.result.template', 'uses' => 'TeacherController@teacherViewClassResultTemplate']);

    Route::post('result-format/xls', ['as' => 'teacher.download.class.result.format.by.subject', 'uses' => 'TeacherController@teacherDownloadClassResultFormatBySubject']);

    Route::post('upload-class-result-by-subject', ['as' => 'teacher.upload.students.result.by.subject', 'uses' => 'TeacherController@teacherUploadStudentResultBySubject']);

    Route::get('view-result', ['as' => 'teacher.view.result', 'uses' => 'TeacherController@teacherViewClassResult']);

    Route::post('view-result', ['as' => 'teacher.view.result.submit', 'uses' => 'TeacherController@teacherViewClassResultSubmit']);


    Route::get('/upload-comments-template', ['as' => 'teacher.upload.comments.template', 'uses' => 'TeacherController@teacherBatchUploadCommentsTemplate']);

    Route::post('/upload-comments-template', ['as' => 'teacher.upload.comments.template', 'uses' => 'TeacherController@teacherBatchUploadCommentsTemplateProcess']);

    Route::post('/download-comments-template/xls', ['as' => 'teacher.download.comments.template', 'uses' => 'TeacherController@teacherDownloadCommentsTemplate']);    

    Route::get('/upload-comments', ['as' => 'teacher.upload.comments', 'uses' => 'TeacherController@teacherBatchUploadComments']);

    Route::post('/upload-comments', ['as' => 'teacher.upload.comments', 'uses' => 'TeacherController@teacherBatchUploadCommentsProcess']);



    Route::get('login', ['as' => 'teacher.login', 'uses' => 'Auth\TeacherAuthController@showLoginForm']);

    Route::post('login', ['as' => 'teacher.login.submit', 'uses' => 'Auth\TeacherAuthController@login']);

    Route::get('logout', ['as' => 'teacher.logout', 'uses' => 'Auth\TeacherAuthController@logout']);

    //Beginning Password Reset

    Route::get('password/email', ['as' => 'teacher.password.email', 'uses' => 'Auth\TeacherPasswordController@getEmail']);
    Route::post('password/email', ['as' => 'teacher.send.password', 'uses' => 'Auth\TeacherPasswordController@sendResetLinkEmail']);

    Route::post('/password/reset', ['as' => 'teacher.password.reset.submit', 'uses' => 'Auth\TeacherPasswordController@reset']);

    Route::get('/password/reset/{token?}', ['as' => 'teacher.password.reset', 'uses' => 'Auth\TeacherPasswordController@showResetForm']);

    Route::get('dashboard', ['as' => 'teacher.dashboard', 'uses' => 'TeacherController@dashboard']);

    Route::pattern('id', '[0-9]+');

    Route::group(['prefix' => '{id}'], function(){

        Route::get('profile/edit', ['as' => 'teacher.profile', 'uses' => 'TeacherController@profile']);

        Route::put('profile/edit', ['as' => 'teacher.profile.update', 'uses' => 'TeacherController@profileUpdate']);

        Route::get('subject', ['as' => 'teacher.subject', 'uses' => 'TeacherController@subject']);

        Route::post('subject', ['as' => 'teacher.subject.update', 'uses' => 'TeacherController@subjectPost']);

        Route::get('passport', ['as' => 'teacher.passport', 'uses' => 'TeacherController@passport']);

        Route::post('passport', ['as' => 'teacher.passport.update', 'uses' => 'TeacherController@passportUpdate']);

        Route::group(['prefix' => 'remarks'], function(){

            Route::get('/', ['as' => 'teacher.remarks', 'uses' => 'TeacherController@remarks']);

            Route::get('single', ['as' => 'teacher.remarks.single', 'uses' => 'TeacherController@remarksSingle']);

            Route::post('single', ['as' => 'teacher.remarks.single.post', 'uses' => 'TeacherController@remarksSinglePost']);

            Route::get('batch', ['as' => 'teacher.remarks.batch', 'uses' => 'TeacherController@remarksBatch']);

            Route::post('batch', ['as' => 'teacher.remarks.batch.post', 'uses' => 'TeacherController@remarksBatchPost']);

            Route::get('/{class_id}/view', ['as' => 'teacher.remarks.view', 'uses' => 'TeacherController@remarksView']);

        });

        Route::group(['prefix' => 'assignment'], function(){

            Route::get('/', ['as' => 'teacher.assignment', 'uses' => 'TeacherController@assignment']);

            Route::get('single', ['as' => 'teacher.assignment.single', 'uses' => 'TeacherController@assignmentSingle']);

            Route::post('single', ['as' => 'teacher.assignment.single.post', 'uses' => 'TeacherController@assignmentSinglePost']);

            Route::get('view', ['as' => 'teacher.assignment.view', 'uses' => 'TeacherController@assignmentView']);

        });

        Route::group(['prefix' => 'results'], function(){

            Route::get('/', ['as' => 'teacher.results', 'uses' => 'TeacherController@results']);

            Route::get('single', ['as' => 'teacher.results.single', 'uses' => 'TeacherController@resultsSingle']);

            Route::post('single', ['as' => 'teacher.results.single.post', 'uses' => 'TeacherController@resultsSinglePost']);

            Route::get('/{class_id}/view', ['as' => 'teacher.results.view', 'uses' => 'TeacherController@resultsView']);

        });

        Route::get('password-update', ['as' => 'teacher.password.edit', 'uses' => 'TeacherController@password']);

        Route::post('password-update', ['as' => 'teacher.password.update', 'uses' => 'TeacherController@passwordUpdate']);


    });

});

Route::get('transfer-format', function(){
        return view('student.transfer-print-sheet');
});

//Route::group(['prefix' => 'auth'], function(){

    Route::auth();

//});
