<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class authenticateRegistrationSlots
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {

            switch ($guard) {
                case 'entrance':
                        if (auth($guard)->user()->numberOfNotUsedSlots() == 0) {

                            flash('Sorry, You have used all your slot, you can purchase card and use the add slot menu to increase your slot')->error();

                            return redirect()->route('exam.entrance.students');
                        }
                break;

                }
            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            }

        return $next($request);
    }
}
