<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\TrafficAnalytic;

class Authenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (Auth::guard($guard)->guest()) {

            switch ($guard) {
                case 'super_admin':
                        $login = 'super_admin.login';
                break;
                case 'admin':
                        $login = 'admin.login';
                break;
                case 'student':
                        $login = 'student.login';
                break;
                case 'teacher':
                        $login = 'teacher.login';
                break;
                case 'unity_exam':
                        $login = 'exam.unity.login.exam.number';
                break;
                case 'entrance':
                        $login = 'exam.entrance.login.exam.number';
                break;
            }
            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            } else {
                return redirect()->guest(route($login));
            }
        }
        
        // save auth user imppressions
        if(Auth::user()){
            // get user's ip
            $user = Auth::user();
            $ip = $request->ip();
            $traffic_analytics = TrafficAnalytic::whereDate('last_seen', '=', Carbon::today())->where('ip', $ip)->get();
            $current_timestamp = Carbon::parse(Carbon::now());
            if($traffic_analytics->count() <= 0){
                TrafficAnalytic::create([
                    'ip' => $ip,
                    'last_seen' => $current_timestamp
                ]);
            }else{
                $traffic_analytics->first()->update([
                    'last_seen' => $current_timestamp
                ]);
            }
        }


        return $next($request);
    }
}
