<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\NgStates;

use Validator;

use App\Subject;

use App\Teacher;

use Hash;

use Excel;

use Input;

use Session;

use Carbon\Carbon;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

class TeachersController extends Controller
{
    // protected $students;
    protected $teacher;

    protected $classes;

    protected $class_arms;

    protected $subject;

    public function __construct(TeacherRepositoryInterface $teachers,ClassRepositoryInterface $classes,ClassArmRepositoryInterface $class_arms,SubjectRepositoryInterface $subjects){

        $this->middleware('auth:admin', ['except' => ['class_arm']]);

        $this->teachers = $teachers;

        $this->classes = $classes;

        $this->class_arms = $class_arms;

        $this->subjects = $subjects;

    }

    protected function permissionDeny($ability){
        \Auth::shouldUse('admin');
        return \Gate::denies($ability);
    }

    function adminViewSchoolTeachers(){
    
        if($this->permissionDeny('view-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $classes = $this->classes->setClass()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $subjects = $this->subjects->setSubject()
                                ->get();
        $teachers = $this->teachers->setTeacher()
                            ->orderBy('surname', 'asc')
                            ->where('school_id', Session('admin.school'))
                            ->paginate(100);
        $all_teachers = $this->teachers->setTeacher()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        return view('admin.teachers.view', compact('classes', 'class_arms', 'teachers', 'subjects','all_teachers', 'staff_no_digit'));
    }

    function adminViewSchoolTeachersPage(Request $request){
    
        if($this->permissionDeny('view-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $data = [];

        foreach($request->all() as $key => $value){
            if(!in_array($key, ['_method', '_token'])){
                $data[$key] = $value;
            }
        }
        $data['school_id'] = Session('admin.school');

        $classes = $this->classes->setClass()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $subjects = $this->subjects->setSubject()
                                ->get();
        $all_teachers = $this->teachers->setTeacher()
                                ->where('school_id', Session('admin.school'))
                                ->get();

        $teachers =  fetchDataTable('teachers', $data, 100);

        Input::flash();

        return view('admin.teachers.post-view',  compact('classes', 'class_arms', 'teachers', 'subjects','all_teachers', 'data'));
    }
    
    function adminCreateSchoolTeachers(){
    
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $ngstates = NgStates::all();
        $classes = $this->classes->setClass()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $subjects = $this->subjects->setSubject()
                                ->get();
        return view('admin.teachers.create', compact('ngstates', 'classes', 'class_arms', 'subjects'));
    }

    function class_arm(Request $request){
        
        $class_arms = new \App\ClassArms;
         if( $request->ajax() ) {
            $class_id = $request->input('class');
            $classarms = $class_arms->where('class_id','=',$class_id)->get();
            $classARMS = $class_arms->present_class_arm_for_display($classarms);
            return response()->json([
                'classARM' => $classARMS
            ]);
        }
    }

    function adminRegisterSchoolTeachers(Request $request){
    
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $teacher = $this->teachers->setTeacher();

        $validate = Validator::make($request->all(), $teacher::$rules);

        $session = $request->input('session');
        
        $school_id = Session::get('admin.school');
        $get_staff_no_session = $this->teachers->getNextStaffDigit($session, $school_id);


        if($validate->passes()){
            foreach ($request->all() as $key => $value) {
                if(!in_array($key, array('_token','password_confirmation','subjects')) && !empty($value)){
                    if($key == 'password'){
                        $insert[$key] = Hash::make($value);
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }
            
            $error_check = 0;

            $insert['staff_no'] = 'ONDO/'.str_pad(Session::get('admin.school'), 4, 0, STR_PAD_LEFT).'/STAFF/'.$session.'/'.str_pad($get_staff_no_session, 4, 0, STR_PAD_LEFT);
            $insert['school_id'] = $school_id;
            $insert['staff_no_digit'] = $get_staff_no_session;
        
            $teacher_check_row = $this->teachers->setTeacher()
                                ->where('staff_no', $insert['staff_no'])
                                ->count();
            $error_check = ($teacher_check_row == 0) ? $error_check: $error_check++;

            $emailTeacherVerify = $this->teachers->setTeacher()
                                        ->where('school_id', $school_id)
                                        ->where('email', strtolower(trim($request->email)))
                                        ->first();
            $error_check = (empty($emailTeacherVerify->id)) ? $error_check: $error_check++;
                            
            $phoneTeacherVerify = $this->teachers->setTeacher()
                                        ->where('school_id', $school_id)
                                        ->where('phone', trim($request->phone))
                                        ->first();
            $error_check = (empty($phoneTeacherVerify->id)) ? $error_check: $error_check++;

           if($error_check == 0){ 
                $staff = $teacher->create($insert);

                $staff->subjects()->attach($request->subjects, ['school_id' => Session::get('admin.school')]);


                flash('You have successfully created a teacher with staff no: '.$insert['staff_no'])->success();

                return redirect()->back();
           }
            else{
                flash('Something went wrong while processing data. Pls try again shortly!')->error();
                return redirect()->back();
            }

        }else{
            flash('Something is wrong')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function adminBatchCreateSchoolTeachers(){
    
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $classes = $this->classes->setClass()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session('admin.school'))
                                ->get();
        return view('admin.teachers.batch-create', compact('classes', 'class_arms'));
    }

     function adminBatchRegisterSchoolTeachers(Request $request){

    
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->setTeacher();

        $validate = Validator::make($request->all(), $teacher::$ruleBatch);

        if($validate->passes()){

                if($request->hasFile('batch_file')){
                    $session = $request->input('session');
                    $school_id = Session::get('admin.school');
                    $std_count = $this->teachers->getNextStaffDigit($session, $school_id);
                    $path = $request->file('batch_file')->getRealPath();
                    $ext = $request->file('batch_file')->getClientOriginalExtension();
                    $duplicacy = array();
                    $email_checker = array();
                    $insert = array();
                    $row_counter = 2;
                    $data = Excel::load($path, function($reader) {
                    })->get();

                    if(!empty($data) && $data->count()){
                        if(in_array($ext, ['xls', 'xlsx', 'csv'])){
                            foreach ($data as $key => $value) {

                                    $emailTeacherVerify = Teacher::where('school_id', $school_id)
                                                    ->where('email', strtolower(trim($value->email)))
                                                    ->first();
                                                    
                                    $phoneTeacherVerify = Teacher::where('school_id', $school_id)
                                                    ->where('phone', trim($value->phone))
                                                    ->first();

                                    $emailTeacherAllVerify = Teacher::where('email', strtolower(trim($value->email)))
                                                    ->first();
                                                    
                                    $phoneTeacherAllVerify = Teacher::where('phone', trim($value->phone))
                                                    ->first();

                                     if(empty($emailTeacherVerify->id)){
                                        if(empty($phoneTeacherVerify->id)){
                                            if(empty($emailTeacherAllVerify->id)){
                                                if(empty($phoneTeacherAllVerify->id)){
                                                    ///// ALL CLEAR /////
        
                                                    if(in_array($value->email, $email_checker) || empty($value->email))
                                                    {
                                                        $duplicacy[] = 'Teacher\'s email in row '.$row_counter.' already exist in the upload file OR email field is empty';
                                                    }else{
                                                        $staff_no = 'ONDO/'.str_pad(Session::get('admin.school'), 4, 0, STR_PAD_LEFT).'/STAFF/'.$session.'/'.str_pad($std_count, 4, 0, STR_PAD_LEFT);
                                                        $teacher_check_row = $this->teachers->setTeacher()
                                                            ->where('staff_no', $staff_no)
                                                            ->count();
                                                        
                                                        if($teacher_check_row == 0){ 
                                                            
                                                            if(empty($value->surname) || empty($value->firstname) || empty($value->phone) || empty($value->email) || empty($value->password)){
                                                                $duplicacy[] = 'Either teacher\'s surname, firstname, middlename, phone, email or password in row '.$row_counter.' is empty';
                                                            }else{
                                                                
                                                            $insert[] = [
                                                                'staff_no' => $staff_no,
                                                                'staff_no_digit' => $std_count,
                                                                'title' => $value->title,
                                                                'surname' => $value->surname,
                                                                'firstname' => $value->firstname,
                                                                'middlename' => $value->middlename,
                                                                'marital_status' => $value->marital_status,
                                                                'phone' => trim($value->phone),
                                                                'gender' => $value->gender,
                                                                'email' => strtolower(trim($value->email)),
                                                                'address' => $value->address,
                                                                'next_of_kins' => $value->next_of_kins,
                                                                'next_of_kins_address' => $value->next_of_kins_address,
                                                                'next_of_kins_phone' => $value->next_of_kins_phone,
                                                                'next_of_kins_email' => $value->next_of_kins_email,
                                                                'password' => Hash::make($value->password),
                                                                'session' => $session,
                                                                'qualification' => $value->qualification,
                                                                'health_status' => $value->health_status,
                                                                'school_id' => Session::get('admin.school'),
                                                                'health_status_desc' => $value->health_status_description,
                                                                'extra_curricular_activites' => $value->extra_curricular_activities,
                                                                'created_at' => Carbon::now(),
                                                                'updated_at' => Carbon::now()
                
                                                                ];
                
                                                                $email_checker[] = $value->email;
                                                                
                                                            }
                                                        }
                                                        else{
                                                            $duplicacy[] = 'Teacher\'s staff no ('.$staff_no.') in '.$row_counter.' already exist'; 
                                                        }
                                                    }//
                                                    
                                                    ///// ALL CLEAR /////
                                                }
                                                else{
                                                    $exist_school_name = getSchoolName($phoneTeacherAllVerify->school_id);
                                                    $duplicacy[] = $value->phone.' already exist in another School ('.$exist_school_name.')';
                                                }
                                            }
                                            else{
                                                $exist_school_name = getSchoolName($emailTeacherAllVerify->school_id);
                                                $duplicacy[] = $value->email.' already exist in another School ('.$exist_school_name.')';
                                            }
                                        }else{
                                         $duplicacy[] = $value->phone.' already exist, register with another phone number';
                                        }
                                            
                                     }else{
                                         $duplicacy[] = $value->email.' already exist, register with another email address';
                                     }

                                    $std_count++;

                                    $row_counter++;
                                }
                            }
                        }
                        //dd($duplicacy);
                        if(!empty($insert) && empty($duplicacy)){
                            $teacher->insert($insert);

                            flash('Successfully inserted '.count($insert).' teachers')->success();

                            return redirect()->back()
                                             ->withInput(); 

                        }elseif(!empty($insert) && !empty($duplicacy)){
                            $teacher->insert($insert);

                            flash('Successfully inserted '.count($insert).' Students')->success();

                            flash($duplicacy)->error();

                            return redirect()->back()
                                             ->withInput();  
                        }else{

                            flash($duplicacy)->error();

                            return redirect()->back()
                                             ->withInput();  

                        }
                    }
                
               return redirect()->back();     
        }else{

            flash('Something is wrong')->error();
                return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }

    function adminEditSchoolTeacher($id){
        
            if($this->permissionDeny('edit-teacher')){
                $title = 'Permission Deny';
                return view('errors.401', compact('title'));
            }
            $teacher = $this->teachers->find($id);
            $ngstates = NgStates::all();
            $classes = $this->classes->setClass()
                                ->where('school_id', Session('admin.school'))
                                ->get();
            $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session('admin.school'))
                                ->get();
            $subjects = $this->subjects->setSubject()
                                ->get();
            $teacher_subjects = array();
            foreach($teacher->subjects()->get() as $t_s){
                $teacher_subjects[] = $t_s->id;
            }
            return view('admin.teachers.edit', compact('ngstates', 'classes', 'class_arms','teacher','subjects','teacher_subjects'));
    }

    function adminUpdateSchoolTeacher(Request $request, $id){

    
        if($this->permissionDeny('edit-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->setTeacher();

            $teacher::$rules['password'] = 'sometimes|alpha_num|min:6|confirmed';
            $teacher::$rules['password_confirmation'] = 'sometimes|alpha_num|min:6';
            $teacher::$rules['email'] = 'required|email|unique:teachers,email,'.$id;

        $validate = Validator::make($request->all(), $teacher::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation', '_method','subjects')) && !empty($value)){
                    if($key == 'password' && !empty($value)){
                        $insert[$key] = Hash::make($value);
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

            $staff = $this->teachers->find($id);
                    
            $staff->update($insert);

            $staff->subjects()->detach();

            $staff->subjects()->attach($request->subjects, ['school_id' => Session::get('admin.school')]);

            flash('You have successfully updated a teacher Profile')->success();

            return redirect()->back();

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function adminDeleteSchoolTeacher(Request $request, $id){
		
        if($this->permissionDeny('delete-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->find($id);
        $fullname = $teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename;
        $teacher->delete();
        $teacher->subjects()->detach();

        flash('You have successfully deleted '.$fullname)->success();

        return redirect()->route('admin.view.school.teachers');
    }



}