<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use App\NgStates;

use Validator;

use Input;

use DB;

use Excel;

use Image;

use Hash;

use Session;

use Carbon\Carbon;

use App\AttendanceAnalytic;

class TeacherController extends Controller
{
	protected  $teacher;

    protected $classes;

    protected $subject;

    protected $students;

    protected $classarms;

    protected $student_results;

    protected $student_comments;

    function __construct(TeacherRepositoryInterface $teacher,ClassRepositoryInterface $classes, SubjectRepositoryInterface $subject, StudentRepositoryInterface $students, ClassArmRepositoryInterface $classarms, StudentResultRepositoryInterface $student_results, StudentCommentsRepositoryInterface $student_comments){

    	$this->middleware('auth:teacher');

    	$this->teacher = $teacher;

        $this->classes = $classes;

        $this->subject = $subject;

        $this->students = $students;

        $this->classarms = $classarms;

        $this->student_results = $student_results;

        $this->student_comments = $student_comments;

    }

    public function dashboard(){

    	$title = 'Teacher Dashboard';
    	$noAutoAd = true;

    	$teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        //dd($teacher);

    	return view('teacher.dashboard', compact('title', 'teacher', 'noAutoAd'));
    }

    public function profile($id){
        $title = 'Teacher Edit Profile';

        $ngstates = NgStates::all();

        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        return view('teacher.profile', compact('title', 'teacher', 'ngstates'));
    }

    public function profileUpdate($id, Request $request){

        $setTeacher = $this->teacher->setTeacher();

        $setTeacher::$teacherProfileRule['email'] = 'required|email|unique:teachers,email,'.\Auth::guard('teacher')->id();

        $validate = Validator::make($request->all(), $setTeacher::$teacherProfileRule);

        if($validate->passes()){
            $teacher = $setTeacher->find((\Auth::guard('teacher')->id()));

            $teacher->surname = $request->input('surname');
            $teacher->firstname = $request->input('firstname');
            if(!empty($request->input('middlename'))){
                $teacher->middlename = $request->input('middlename');
            }
            $teacher->title = $request->input('title');
            $teacher->gender = $request->input('gender');
            $teacher->qualification = $request->input('qualification');
            $teacher->state_id = $request->input('state_id');
            $teacher->lga_id = $request->input('lga_id');
            $teacher->address = $request->input('address');
            $teacher->email = $request->input('email');
            $teacher->phone = $request->input('phone');
            $teacher->marital_status = $request->input('marital_status');
            $teacher->next_of_kins = $request->input('next_of_kins');
            $teacher->next_of_kins_address = $request->input('next_of_kins_address');
            if(!empty($request->input('next_of_kins_email'))){
                 $teacher->next_of_kins_email = $request->input('next_of_kins_email');
            }
            $teacher->next_of_kins_phone = $request->input('next_of_kins_phone');
            $teacher->health_status = $request->input('health_status');
            $teacher->extra_curricular_activites = $request->input('extra_curricular_activites');
            $teacher->health_status_desc = $request->input('health_status_desc');

            $teacher->save();

            flash('Successfully updated Profile')->success();

            return redirect()->route('teacher.dashboard');

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }

    public function passport($id){

        $title = 'Teacher Passport Upload';

        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        return view('teacher.passport', compact('title', 'teacher'));

    }

    public function password($id){
        $title = 'Teacher Password Update';

        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        return view('teacher.password', compact('title', 'teacher'));
    }

    public function passwordUpdate($id, Request $request){

        $setTeacher = $this->teacher->setTeacher();

        $validate = Validator::make($request->all(), $setTeacher::$teacherPasswordRule);

        if($validate->passes()){
            $teacher = $setTeacher->find((\Auth::guard('teacher')->id()));

            $teacher->password = Hash::make($request->input('password'));

            $teacher->save();

            flash('Successfully updated Password')->success();

            return redirect()->route('teacher.dashboard');

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }

    public function passportUpdate($id, Request $request){

        $setTeacher = $this->teacher->setTeacher();

        $validate = Validator::make($request->all(), $setTeacher::$teacherPassportRule);

        if($validate->passes()){

            $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

            if ($request->hasFile('passport'))
            {
                if ($teacher->passport != '/images/passports/no_img_da88a72526.gif') {

                       if(file_exists(public_path(explode('?', ltrim($teacher->passport, '/'))[0])))
                    {
                        unlink( public_path(explode('?', ltrim($teacher->passport, '/'))[0]) );
                    }
                }
                $image = $request->file('passport');
                $passport_path = md5(time())."-".$teacher->surname."-".$teacher->firstname.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(250,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/passports/teachers/'.$passport_path);

                $teacher->passport = '/images/passports/teachers/'.$passport_path.'?cache='.time();

                $teacher->save();

                flash('You have successfully updated your passport')->success();

                return redirect()->route('teacher.dashboard');

            }
        }


        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate);
    }

    public function resultSelect($id){

        $title = 'Select Result';

        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('teacher.school'))
                                ->get();

        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        return view('teacher.result-select', compact('classes', 'title', 'teacher'));

    }

    public function resultSelectPost($id, Request $request){
        $title = 'Teacher Result View';

        $setTeacher = $this->teacher->setTeacher();

        $validate = Validator::make($request->all(), $setTeacher::$teacherResultSelectRule);


        if($validate->passes()){

            $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

            $session = $request->input('session');            

            $term = $request->input('term');
            
            $class_id = $request->input('class_id');            

            $classarm_id = $request->input('class_arm_id');  

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
    }

    public function subject($id){

    	$title = 'Teacher Update Subject Area';

    	$subjects = $this->subject->setSubject()
                                ->get();

    	$teacher = $this->teacher->find(\Auth::guard('teacher')->id());

    	$teacher_subjects = array();
        foreach($teacher->subjects()->get() as $t_s){
            $teacher_subjects[] = $t_s->id;
        }

    	return view('teacher.subject-area', compact('subjects', 'title', 'teacher', 'teacher_subjects'));

    }

    public function subjectPost($id, Request $request){
    	$setTeacher = $this->teacher->setTeacher();

    	$validate = Validator::make($request->all(), $setTeacher::$teacherSubjectAreaRule);

    	if($validate->passes()){

			$teacher = $this->teacher->find(\Auth::guard('teacher')->id());

			$teacher->subjects()->detach();

            $teacher->subjects()->attach($request->subjects, ['school_id' => Session::get('teacher.school')]);

			flash('You have successfully updated your subject area')->success();

			return redirect()->route('teacher.dashboard');
    	}
    	flash('Something is wrong')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();


    }


    function teacherBatchUploadCommentsTemplate(){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('teacher.school'))
                                ->get();

        return view('teacher.comment-batch-upload-template', compact('classes', 'teacher', 'teacher_id'));

    }


    function teacherBatchUploadCommentsTemplateProcess(Request $request){
        
        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'term' => 'required',
                'class_id' => 'required',
                'class_arm_id' => 'required',
                'teacher_id' => 'required'
            ]);

        if($validate->passes()){

            Input::flash();

            return $this->errorReturnForCommentTemplate($request);

        }else{
            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }
    }


    function teacherDownloadCommentsTemplate(Request $request){
        
        $classarm_data = $this->classarms->find($request->input('classarm_id'));
        $classarm_teacher_data = $classarm_data->teachers()
                            ->where('classarm_teacher.classarm_id', $request->classarm_id)
                            ->first();

        $verify_class_teacher = (!empty($classarm_teacher_data)) ? $classarm_teacher_data->id: 0;

        if(!empty($request->teacher_id) && $request->teacher_id == $verify_class_teacher){
    
            $students = $classarm_data->students()
                                ->wherePivot('session', $request->session)
                                ->wherePivot('term', $request->term)
                                ->wherePivot('class_id', $request->class_id)
                                ->get(['surname','firstname','middlename', 'regnum'])->toArray();
    
            if(count($students) > 0){
                foreach ($students as  $value) {
                    $data[] = [
                                    'fullname' => trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']),
                                    'regnum' => $value['regnum'],
                                    'comment' => ''
                                    ];
                }
            }else{
                $data = array();
            }
            if(count($data) > 0){
    
               return Excel::create('StudentResultCommentTemplate_'.time(), function($excel) use ($data) {
                    $excel->sheet('mySheet', function($sheet) use ($data)
                    {
                        $sheet->fromArray($data);
                    });
                })->download('xls'); 
                
            }else{
                flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();
    
                return $this->errorReturnForCommentTemplate($request);
            }
        }
        else{
            flash('Sorry, You must be assigned as Class Teacher to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' to perform action')->error();

            return $this->errorReturnForCommentTemplate($request);
        }
    }


    function teacherBatchUploadComments(){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('teacher.school'))
                                ->get();

        return view('teacher.comment-batch-upload', compact('classes', 'teacher', 'teacher_id'));

    }



    function teacherBatchUploadCommentsProcess(Request $request){

        $student_comments = $this->student_comments->setStudentComments();

        $rules = $student_comments::$ruleForResultUpload;

        $rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv', 'excelFormatAllowed:3'];
        $rules['classarm_id'] = 'required|integer';

        unset($rules['classarm_id']);

        $validate = Validator::make($request->all(), $rules);
                
        $comment_field = getCommentCategoryField($request->category);

        $classarm_data = $this->classarms->find($request->input('classarm_id'));
        $classarm_teacher_data = $classarm_data->teachers()
                            ->where('classarm_teacher.classarm_id', $request->classarm_id)
                            ->first();

        $verify_class_teacher = (!empty($classarm_teacher_data)) ? $classarm_teacher_data->id: 0;

        if(!empty($request->teacher_id) && $request->teacher_id == $verify_class_teacher){

            if($validate->passes()){
                if($request->hasFile('batch_file')){

                    $path = $request->file('batch_file')->getRealPath();

                    $ext = $request->file('batch_file')->getClientOriginalExtension();

                    $data = Excel::load($path, function($reader) {
                    })->get();

                    $insert = array();

                    $duplicacy = array();

                    $count_students = 0;

                    $duplicacy_update_data = array();

                    $duplicacy_update_id = array();
                                   
                   $school_id = Session::get('teacher.school');
                   
                   if(!empty($comment_field)){

                        if(!empty($data) && $data->count() > 0){
        
                            if(in_array($ext, ['xls', 'xlsx'])){
        
                                foreach ($data as $key => $value) {
        
                                        //check id the regnum exit
        
                                            $student_id = getStudentIDByRegNum($value->regnum);
        
                                            if(null === $student_id){
                                                $duplicacy[] = 'Student Regisration Number <strong>'.$value->regnum.'</strong> does not exit ';
                                            }else{
                                                if(empty($value->comment))
                                                {
                                                    $duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s Comment has not be inputted for  '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                                }
                                                else{   
                                                    $count_students++;
                                                    $notDuplicate = $this->student_comments->checkCommentDuplicacy($student_id->id, $school_id,$request->classarm_id,$request->session,$request->term);
            
                                                    if($notDuplicate){                                              
                                                        $insert[] = [
                                                        'student_id' => $student_id->id,
                                                         $comment_field => $value->comment,
                                                         'session' => $request->session,
                                                         'term' => $request->term,
                                                         'class_id' => $request->class_id,
                                                         'classarm_id' => $request->classarm_id,
                                                         'school_id' => $school_id
                                                        ];
        
                                                    }else{
                                                        $duplicateCommentId = $this->student_comments->getCommentDuplicacyId($student_id->id, $school_id, $request->classarm_id,$request->session,$request->term);
                                                            
                                                        $duplicacy_update_data[$duplicateCommentId['id']][] = [
                                                         $comment_field => $value->comment
                                                        ];

                                                        $duplicacy_update_id[] = [
                                                         'id' => $duplicateCommentId['id']
                                                        ];
                                                    }
                                                
                                                }
                                            }
                                }
                            }
        
        
                            if((count($insert) > 0) && empty($duplicacy)){

                                    $student_comments->insert($insert);
        
                                    if(!empty($duplicacy_update_id)){
                                        $d_i = 0;
                                        foreach ($duplicacy_update_id as $data_row) {
                                            $data_id = $data_row['id'];
        
                                            $student_comments_data = $student_comments->find($data_id);
                                            $student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
                                            $data_update    =   $student_comments_data->save();
                                        }//end loop
        
                                    flash(count($duplicacy_update_id).' Result Comment for '.$count_students.' Students was updated Successfully')->success();
                                    }
        
                                    flash('Successfully inserted '.count($insert).' Result Comment for '.$count_students.' Students')->success();
        
                                    return $this->errorReturnForCommentBatchUpload($request); 
                              }elseif((count($insert) > 0) && !empty($duplicacy)){
        
                                    $student_comments->insert($insert);
        
                                    if(!empty($duplicacy_update_id)){
                                        $d_i = 0;
                                        foreach ($duplicacy_update_id as $data_row) {
                                            $data_id = $data_row['id'];
        
                                            $student_comments_data = $student_comments->find($data_id);
                                            $student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
                                            $data_update    =   $student_comments_data->save();
                                        }
        
                                    flash(count($duplicacy_update_id).' Result Comment for '.$count_students.' Students updated Successfully')->success();
                                    }
        
                                    flash('Successfully inserted '.count($insert).' Result Comment for '.$count_students.' Students')->success();
        
                                    flash($duplicacy)->error();
        
                                    return $this->errorReturnForCommentBatchUpload($request); 
                               }else{
                                    if(!empty($duplicacy_update_id)){
                                        $d_i = 0;
                                        foreach ($duplicacy_update_id as $data_row) {
                                            $data_id = $data_row['id'];
        
                                            $student_comments_data = $student_comments->find($data_id);
                                            $student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
                                            $data_update    =   $student_comments_data->save();
                                        }
        
                                    flash('Successfully updated '.count($duplicacy_update_id).' Result Comment for '.$count_students.' Students')->success();
                                    }
                                    else{
                                        flash('No fresh Result Comment was submitted.')->error();
                                    }
        
                                    if(!empty($duplicacy)){
                                     flash($duplicacy)->error();
                                    }
                                    
                                    return $this->errorReturnForCommentBatchUpload($request); 
        
                                }
                        }else{
                            flash('Sorry, the file is empty')->error();
                            return $this->errorReturnForCommentBatchUpload($request);
                        }
                   }else{
                        flash('Sorry, the Comment Category submitted is invalid')->error();
                        return $this->errorReturnForCommentBatchUpload($request);
                    }       
                }else{
                    flash('Sorry, You have not choosen any file')->error();

                return $this->errorReturnForCommentBatchUpload($request);
                }
            }else{
                return $this->errorReturnForCommentBatchUpload($request)->withErrors($validate);
            }

        }
        else{
            flash('Sorry, You must be assigned as Class Teacher to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' to perform action')->error();

            return $this->errorReturnForCommentBatchUpload($request);
        }
    }


   protected function errorReturnForCommentTemplate(Request $request){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

                    if($key == 'classarm_id' || $key == 'class_arm_id'){
                        $inputs['class arm'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

            $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('teacher.school'))
                                ->get();

            return view('teacher.comment-batch-upload-template-view', compact('inputs', 'classes', 'teacher', 'teacher_id'));
    }


   protected function errorReturnForCommentBatchUpload(Request $request){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','batch_file'])){

                    if($key == 'class_arm_id'){
                        $inputs['class_arm_id'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('teacher.school'))
                                ->get();

            return view('teacher.comment-batch-upload', compact('inputs', 'classes', 'teacher', 'teacher_id'));
    }




    function teacherViewBatchUploadResultBySubject(){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('teacher.school'))
                                ->get();

        return view('teacher.subject-result-batch-upload', compact('classes', 'teacher', 'teacher_id'));

    }

    function teacherViewClassResultTemplate(Request $request){
        
        $validate = Validator::make($request->all(), [
                'class_id' => 'required',
                'class_arm_id' => 'required',
                'session' => 'required',
                'term' => 'required',
                'teacher_id' => 'required'
            ]);

        if($validate->passes()){

            Input::flash();

            return $this->templateReturnForView($request);

        }else{
            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }
    }

    function teacherDownloadClassResultFormatBySubject(Request $request){

        $verify_subject = DB::table('classarm_subject')
                            ->where('teacher_id', $request->teacher_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('session', $request->session)
                            ->get(); 

        if(!empty($verify_subject)){

            $classarm_id = $this->classarms->find($request->input('classarm_id'));

            $students = $classarm_id->students()
                                ->wherePivot('session', $request->session)
                                ->wherePivot('term', $request->term)
                                ->wherePivot('class_id', $request->class_id)
                                ->get(['surname','firstname','middlename', 'regnum'])->toArray();
            if(count($students) > 0){
                foreach ($students as  $value) {
                    $data[] = [
                                    'fullname' => trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']),
                                    'regnum' => $value['regnum'],
                                    'ca' => '',
                                    'exam' => ''
                                    ];
                }
            }else{
                $data = array();
            }
            if(count($data) > 0){
                $filename = public_path('exceluploads/studentResultBySubject.xls');

                return Excel::load($filename, function($excel) use ($data) {
                    $excel->sheet('mySheet', function($sheet) use ($data)
                    {
                        $sheet->fromArray($data);
                    });
                })->download('xls');
                
            }else{
                flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

                return $this->templateReturnForView($request);
            }
        }
        else{
            flash('Sorry, No subject has been assigned to You for '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

            return $this->templateReturnForView($request);
        }
    }

    function teacherUploadStudentResultBySubject(Request $request){

        $verify_subject = DB::table('classarm_subject')
                            ->where('teacher_id', $request->teacher_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('subject_id', $request->subject_id)
                            ->where('session', $request->session)
                            ->get(); 
                            
        if(!empty($verify_subject)){
        
            $teacher_data = $this->teacher->find($request->teacher_id);
            $school_id = $teacher_data->school_id;
    
            $student_results = $this->student_results->setStudentResult();
    
            $rules = $student_results::$ruleForSubjects;
    
            $rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv', 'excelFormatAllowed:4'];
            $rules['classarm_id'] = 'required|integer';
    
            unset($rules['class_arm_id']);
    
            $validate = Validator::make($request->all(), $rules);
    
            if($validate->passes()){
                if($request->hasFile('batch_file')){
    
                    $path = $request->file('batch_file')->getRealPath();
    
                    $ext = $request->file('batch_file')->getClientOriginalExtension();
    
                    $data = Excel::load($path, function($reader) {
                    })->get();
    
                    $insert = array();
    
                    $duplicacy = array();
                    
                   $class_data = $this->classes->find($request->class_id);
                   $class_name = $class_data->class_name;
                   $class_name_char = strtoupper(substr($class_name, 0, 1));
                        
                    if(!empty($data) && $data->count() > 0){
    
                        if(in_array($ext, ['xls', 'xlsx'])){
    
                            foreach ($data as $key => $value) {
    
                                    //check id the regnum exit
    
                                        $student_id = getStudentIDByRegNum($value->regnum);
    
                                        if(null === $student_id){
                                            $duplicacy[] = 'Student Regisration Numbe <strong>'.$value->regnum.'</strong> does not exit ';
                                        }else{
    
                                            $check_students = $student_id->classarms()->wherePivot('session',$request->input('session'))
                                                ->wherePivot('term', $request->term)
                                                ->wherePivot('class_id', $request->class_id)
                                                ->get();
    
                                            if($check_students->count() == 0){
    
                                                $duplicacy[] = getStudentFullnameByRegNum($value->regnum).' has not been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
    
                                            }elseif(empty($value->ca) || empty($value->exam))
                                            {
                                                $duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s '.getSubjectNameBySubjectID($request->input('subject_id')).' CA or EXAM has not be inputted for  '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                            }else{
                                                $subject_id = $request->input('subject_id');                                                
                                                $subj_unoffered = DB::table('student_subject_unoffered')
                                                                                ->where('student_id', $student_id->id)
                                                                                ->where('classarm_id', $request->classarm_id)
                                                                                ->where('subject_id', $subject_id)
                                                                                ->first();
                                                                                
                                                if(empty($subj_unoffered)){
        
                                                    $notDuplicate = $this->student_results->checkResultDuplicacy($student_id->id, $request->input('subject_id'),$request->input('classarm_id'),$request->input('session'),$request->input('term'));
        
                                                    //dd($notDuplicate);
        
                                                    if($notDuplicate){
                                                        $mark = $value->ca + $value->exam;  
                                                                    
                                                        if($class_name_char == "J"){
                                                            $resultGrade = resultGradeJS($mark);
                                                            $resultRemarks = resultRemarksJS($mark);
                                                        }
                                                        else{
                                                            $resultGrade = resultGradeSS($mark);
                                                            $resultRemarks = resultRemarksSS($mark);                                                                    
                                                        }
                                                        
                                                        $insert[] = [
                                                        'student_id' => $student_id->id,
                                                         'subject_id' => $request->input('subject_id'),
                                                         'ca_score' => $value->ca,
                                                         'exam_score' => $value->exam,
                                                         'weighted_average' => $mark,
                                                         'grade' => $resultGrade,
                                                         'remarks' => $resultRemarks,
                                                         'session' => $request->input('session'),
                                                         'term' => $request->input('term'),
                                                         'class_id' => $request->input('class_id'),
                                                         'classarm_id' => $request->input('classarm_id'),
                                                         'school_id' => $school_id
                                                        ];
        
                                                    }else{
                                                        $duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s '.getSubjectNameBySubjectID($request->input('subject_id')).' has already been uploaded for '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                                    }
                                                
                                                }//end if
                                            }
                                        }
                            }
                        }
    
    
                        if((count($insert) > 0) && empty($duplicacy)){
    
                                $student_results->insert($insert);
    
                                flash('Successfully inserted '.count($insert).' Students')->success();
    
                                return $this->templateReturnForView($request); 
                          }elseif((count($insert) > 0) && !empty($duplicacy)){
    
                                $student_results->insert($insert);
    
                                flash('Successfully inserted '.count($insert).' Students')->success();
    
                                flash($duplicacy)->error();
    
                                return $this->templateReturnForView($request); 
                           }else{
    
                                 flash($duplicacy)->error();
                                
                                return $this->templateReturnForView($request); 
    
                            }
                    }else{
                        flash('Sorry, the file is empty')->error();
                        return $this->templateReturnForView($request);
                    }
                }else{
                    flash('Sorry, You have not choosen any file')->error();
                    return $this->templateReturnForView($request);
                }
            }else{
                return $this->templateReturnForView($request)->withErrors($validate);
            }
        }else{
            flash('Sorry, No subject has been assigned to You for in the selected class')->error();
            return $this->templateReturnForView($request);
        }
    }

   protected function templateReturnForView(Request $request){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $inputs = array();

        foreach($request->all() as $key => $value){
            if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

                if($key == 'classarm_id' || $key == 'class_arm_id'){
                    $inputs['class arm'] = $value;
                }elseif($key == 'class_id'){
                    $inputs['class'] = $value;
                }else{
                    $inputs[$key] = $value;
                }

            }
        }

        $subjects = DB::table('classarm_subject')
                ->select('classarm_subject.subject_id', 'subjects.subject_name')
                ->where('classarm_subject.teacher_id', $request->teacher_id)
                ->where('classarm_subject.classarm_id', $inputs['class arm'])
                ->where('classarm_subject.session', $request->session)
                ->join('subjects', 'classarm_subject.subject_id', '=', 'subjects.id')
                ->orderBy('subjects.subject_name', 'asc')
                ->get(); 

        return view('teacher.subject-result-batch-template', compact('inputs', 'teacher_id', 'teacher', 'subjects'));
    }

    function teacherViewClassResult(){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', $teacher->school_id)
                                ->get();

        return view('teacher.class-view-result-form', compact('classes', 'teacher_id', 'teacher'));

    } 


    function teacherViewClassResultSubmit(Request $request){

        $teacher_id = \Auth::guard('teacher')->id();

        $teacher = $this->teacher->find($teacher_id);

        $verify_subject = DB::table('classarm_subject')
                            ->where('teacher_id', $teacher_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('session', $request->session)
                            ->get(); 
                            
        if(!empty($verify_subject)){
        
            $student_results = $this->student_results->setStudentResult();
    
            $student = $this->students->setStudent();
    
            $rules = $student_results::$ruleForSubjects;
    
            $rules['classarm_id'] = 'required|integer';
    
            unset($rules['class_arm_id']);
    
            $validate = Validator::make($request->all(), $rules);
    
            if($validate->passes()){
    
                $session = $request->session;
    
                $class_id = $request->class_id;
                
               $class_data = $this->classes->find($request->class_id);
               $class_name = $class_data->class_name;
               $class_name_char = strtoupper(substr($class_name, 0, 1));
    
                $term = $request->term;
    
                $classarm_id_get = $request->classarm_id;
    
                $data = array();
    
                foreach($request->all() as $key => $value){
                    if(!empty($key) && !in_array($key, ['_method', '_token'])){
                            $data[$key] = $value;
                    }
                }
    
                $classarm_id = $this->classarms->find($request->input('classarm_id'));
    
                $students = $classarm_id->students()
                                        ->wherePivot('session',$request->session)
                                        ->wherePivot('term',$request->term)
                                        ->wherePivot('class_id',$request->class_id)
                                        ->get();
    
                Input::flash();
    
                $result_records = array();
    
                foreach($students as $student){
    
                    $data['student_id'] = $student->id;
    
                    $results = fetchDataTable('student_results', $data,200);
    
                    $result_records[$student->id] = $results->toArray();
    
                }
    
                $students_results_info = collect($result_records);
                
                $listGradeRemark = array();
                
                if($class_name_char == "J"){
                    $listGradeRemark = resultGradeRemarksJS();
                }
                else{
                    $listGradeRemark = resultGradeRemarksSS();
                }
    
                return view('teacher.class-view-result', compact('students_results_info', 'class_id', 'session', 'term', 'classarm_id_get', 'class_name_char', 'listGradeRemark', 'teacher'));
            }
    
            flash('Something is wrong')->error();
    
            return redirect()->back()
                    ->withErrors($validate)
                    ->withInput();
        }
        else{
            flash('Sorry, No subject has been assigned to You in the selected class')->error();
            return redirect()->back()->withInput();
        }
    }




    public function teacherSignature(){
        $title = 'Teacher Signature';

        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

        return view('teacher.signature', compact('title', 'teacher'));
    }

    public function teacherStoreSignature(Request $request){

        $validate = Validator::make($request->all(), [
                'signature_png' => 'required'
            ]);
    if($validate->passes()){
        if(preg_match('/data:image/', $request->input('signature_png'))){

            $teacher = $this->teacher->find(\Auth::guard('teacher')->id());

            @unlink(public_path($teacher->signature));

            $src = $request->input('signature_png');

                        // get the mimetype
                        preg_match('/data:image\/(?<mime>.*?)\;/', $src, $groups);
                        $mimetype = $groups['mime'];

                        // Generating a random filename
                        $filename = uniqid();
                        $filepath = "/images/signatures/$filename-".$teacher->surname.".$mimetype";

                        // @see http://image.intervention.io/api/
                        $image = Image::make($src)
                          // resize if required
                          ->resize(500,null, function($constraint)
                            {
                                $constraint->aspectRatio();

                            })
                          ->encode($mimetype, 100)  // encode file to the specified mimetype
                          ->save(public_path($filepath));

                          $teacher->signature = $filepath;

                          $teacher->save();
                    } // <!--endif


                flash('Successfully uploaded')->success();

                return redirect()->back();
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate);
    }
    
    public function teacherOverview(){
        $title = 'Teacher Overview';

        $ngstates = NgStates::all();
        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());
        $overview = AttendanceAnalytic::where('teacher_id', $teacher->id)->get();
        return view('teacher.overview', compact('title', 'teacher', 'ngstates', 'overview'));
    }
    
    public function teacherOverviewSubmit(Request $request){
        // return $request->all();
        $teacher = $this->teacher->find(\Auth::guard('teacher')->id());
        $overview = AttendanceAnalytic::where('teacher_id', $teacher->id)->get();
        $current_timestamp = Carbon::parse(Carbon::now());
        if($overview->count() > 0){
            $overview->first()->update([
                'teacher_type' => $request->type,
                'teacher_description' => $request->description,
                'teacher_date_of_birth' => $request->teacher_date_of_birth,
                'teacher_date_of_service' => $request->teacher_date_of_service,
                'teacher_highest_qualification' => $request->teacher_highest_qualification,
                'teacher_other_qualification' => $request->teacher_other_qualification,
                'teacher_subject_specialization_major' => $request->teacher_subject_specialization_major,
                'teacher_subject_specialization_minor' => $request->teacher_subject_specialization_minor,
                'last_seen'=> $current_timestamp
            ]);
        }else{
            AttendanceAnalytic::create([
                'teacher_id' => $teacher->id,
                'teacher_type' => $request->type,
                'teacher_description' => $request->description,
                'teacher_date_of_birth' => $request->teacher_date_of_birth,
                'teacher_date_of_service' => $request->teacher_date_of_service,
                'teacher_highest_qualification' => $request->teacher_highest_qualification,
                'teacher_other_qualification' => $request->teacher_other_qualification,
                'teacher_subject_specialization_major' => $request->teacher_subject_specialization_major,
                'teacher_subject_specialization_minor' => $request->teacher_subject_specialization_minor,
                'last_seen'=> $current_timestamp
            ]);
        }
        
        flash('Overview updated')->success();
        return back();
    }
}
