<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use Input;

use Validator;

use Carbon\Carbon;

use Excel;

use Session;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use Auth;

use Gate;

class SubjectsController extends Controller
{
    protected $subjects;

    protected $classarms;

    protected $classes;

    protected $teachers;

    function __construct(SubjectRepositoryInterface $subjects, ClassArmRepositoryInterface $classarms, ClassRepositoryInterface $classes, TeacherRepositoryInterface $teachers){

            $this->middleware('auth:admin', ['except' => ['subjectAjax', 'superAdminViewSchoolSubjects', 'superAdminViewSchoolSubjectsPost', 'adminCreateSchoolSubjects','adminRegisterSchoolSubjects','adminBatchCreateSchoolSubjects','adminBatchRegisterSchoolSubjects','adminEditSchoolSubject','adminUpdateSchoolSubject','adminDeleteSchoolSubject']]);

            $this->middleware('auth:super_admin', ['only' => [ 'superAdminViewSchoolSubjects', 'superAdminViewSchoolSubjectsPost','adminCreateSchoolSubjects','adminRegisterSchoolSubjects','adminBatchCreateSchoolSubjects','adminBatchRegisterSchoolSubjects','adminEditSchoolSubject','adminUpdateSchoolSubject','adminDeleteSchoolSubject']]);

    		$this->subjects = $subjects;

    		$this->classarms = $classarms;

    		$this->classes = $classes;

            $this->teachers = $teachers;

    }

    protected function permissionDeny($auth, $ability){
        Auth::shouldUse($auth);
        return Gate::denies($ability);
    }

    function subjectAjax(Request $request){
        
         if( $request->ajax() ) {
        $subjects = $this->subjects->find($request->subject_id);
            $teachers = $subjects->teachers(Session::get('admin.school'))->get();
            $output = $this->subjects->setSubject()->present_teachers_for_display($request->subject_id, $teachers);

            return response()->json([
                'teacher_display' => $output->teacher_display,
                'teacher_div_option' => $output->teacher_div_option,
                'select_name' => $output->select_name

            ]);
       }
    }

    function adminViewSchoolSubjects(){

        if($this->permissionDeny('admin','view-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subjects = $this->subjects->setSubject()
                            ->orderBy('subject_name', 'asc')
                            ->paginate(6);

        $all_subjects = $this->subjects->setSubject()
                            ->get();

        return view('admin.subjects.view', compact( 'subjects','all_subjects'));

    }

    function superAdminViewSchoolSubjects(){

        if($this->permissionDeny('super_admin','view-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subjects = $this->subjects->setSubject()
                            ->orderBy('subject_name', 'asc')
                            ->paginate(6);

        $all_subjects = $this->subjects->setSubject()
                            ->get();

        return view('admin.subjects.view', compact( 'subjects','all_subjects'));

    }

    function adminAssignSubjectToClass(){

        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'Assign Subject to Class';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.view.subject.teacher.to.assign.class.submit';

        $subject_teacher = '';

        return view('admin.classarms.pre-assign-student', compact('classes', 'classarms', 'title', 'route', 'subject_teacher'));
    }

    function adminAssignSubjectWithTeacherToClass(Request $request){

        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                'class_id' => 'required',
                'classarm_id' => 'required',
                'session' => 'required|digits:4'
            ]);

        if($validate->passes()){

            	$subjects = $this->subjects->setSubject()
                                    ->get();

            	$classes = $this->classes->setClass()
                                        ->where('school_id', '=', Session::get('admin.school'))
                                        ->get();

            	$classarms = $this->classarms->setClassArms()
                                            ->where('school_id', '=', Session::get('admin.school'))
            								->orderBy('class_id', 'desc')
            								->paginate(50);
    	return view('admin.classarms.assign-subjects-to-class', compact('subjects', 'classes', 'classarms', 'request'));

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();



    }

    function adminAssignSubjectWithTeacherToClassSubmit(Request $request){

        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarms = $this->classarms->setClassArms();

    	$validate = Validator::make($request->all(), [
                'class_id' => 'required',
                'classarm_id' => 'required',
                'session' => 'required|digits:4',
                'subject_id' => 'required|array:1',
                'subject_teachers' => 'required|array:1'
            ]);

       // dd($request->all());


    	if($validate->passes()){

            $classarm = $this->classarms->find($request->classarm_id);

            $exit_subjects_array = array();

            $exit_subjects = \DB::table('classarm_subject')->select('subject_id')
                                        ->whereRaw('`classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session)
                                        ->get();
                                        
            foreach($exit_subjects as $subject){
                $exit_subjects_array[] = $subject->subject_id;
            }

            $assign_subjects = array_diff(array_unique(array_filter($request->subject_id, function($value) { return $value !== ''; })), $exit_subjects_array);

            if(count($assign_subjects) > 0){


                foreach($assign_subjects as $subject){
                    //dd(array_unique($request->subject_teachers[$subject]));

                    //$teachers = $this->subjects->find($subject)->teachers;
                    foreach (array_unique(array_filter($request->subject_teachers[$subject], function($value) { return $value !== ''; })) as $teacher) {
                     $classarm->subjects()->attach($subject,['session' => $request->session, 'teacher_id' => $teacher]);
                        $this->teachers->find($teacher)->permission_classes()->attach([48,49,50,51], ['classarm_id' => $request->classarm_id, 'subject_id' => $subject]);
                    }
                }

                flash('You have successfully assign subjects to Class Arm')->success();

                return redirect()->back();

            }

            flash('Sorry, you have already assign the teacher to the class')->error();

            return $this->adminAssignSubjectWithTeacherToClass($request);

    	}else{
            flash('something is wrong')->error();
    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();
    	}

    }

    function adminEditAssignSubjectToClass($id){

        if($this->permissionDeny('admin','edit-assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$subjects = $this->subjects->setSubject()
                                    ->get();

    	$classarm = $this->classarms->find($id);

    	$assign_subjects = array();

    	foreach($classarm->subjects()->get() as $t_s){
                $assign_subjects[] = $t_s->id;
            }

    	return view('admin.subjects.edit-assign-subjects', compact('subjects', 'classarm', 'assign_subjects'));

    }

    function adminUpdateAssignSubjectToClass(Request $request, $id){

        if($this->permissionDeny('admin','edit-assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarms = $this->classarms->setClassArms();

    	$validate = Validator::make($request->all(), $classarms::$ruleAssign);

    	if($validate->passes()){

    		$classarm = $this->classarms->find($id);

            $classarm->subjects()->sync($request->subjects);

            \DB::table('class_teacher_permission')->whereRaw("`classarm_id` = $id AND `permission_id` IN (48,49,50,51)")
                                                ->delete();

            foreach($request->subjects as $subject){
                $teachers = $this->subjects->find($subject)->teachers;
                foreach ($teachers as $teacher) {
                    $this->teachers->find($teacher->id)->permission_classes()->attach([48,49,50,51], ['classarm_id' => $id]);
                }
            }

            flash('You have successfully updated subjects to Class Arm')->success();

            return redirect()->route('admin.assign.subject.to.class');

    	}else{
    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();
    	}

    }

    function adminDeleteAssignSubjectToClass($id){

        if($this->permissionDeny('admin','remove-assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarm = $this->classarms->find($id);

        $classarm->subjects()->detach();

         \DB::table('class_teacher_permission')->whereRaw("`classarm_id` = $id AND `permission_id` IN (48,49,50,51)")
                                                ->delete();

        flash('You have successfully deleted subjects assign to '.getClassNameByClassID($classarm->class_id).' '.$classarm->class_arm)->success();

        return redirect()->to(route('subjectassign'));

    }



    function adminViewSchoolSubjectsPost(Request $request){

        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $data = [];

        foreach($request->all() as $key => $value){
            if(!in_array($key, ['_method', '_token'])){
                $data[$key] = $value;
            }
        }

        $data['school_id'] = Session::get('admin.school');
        
        $all_subjects= $this->subjects->setSubject()
                            ->get();

        $subjects =  fetchDataTable('subjects', $data, 5);

        Input::flash();

        return view('admin.subjects.post-view',  compact( 'subjects','all_subjects'));
    }

    function superAdminViewSchoolSubjectsPost(Request $request){

        if($this->permissionDeny('super_admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $data = [];

        foreach($request->all() as $key => $value){
            if(!in_array($key, ['_method', '_token'])){
                $data[$key] = $value;
            }
        }

        $data['school_id'] = Session::get('admin.school');
        
        $all_subjects= $this->subjects->setSubject()
                            ->get();

        $subjects =  fetchDataTable('subjects', $data, 5);

        Input::flash();

        return view('admin.subjects.post-view',  compact( 'subjects','all_subjects'));
    }

    function adminCreateSchoolSubjects(){

        if($this->permissionDeny('super_admin','create-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$all_subjects = $this->subjects->setSubject()
                                        ->get();
    	return view('admin.subjects.create', compact('all_subjects'));

    }

    function adminRegisterSchoolSubjects(Request $request){

        if($this->permissionDeny('super_admin','create-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$subjects = $this->subjects->setSubject();

    	$validate = Validator::make($request->all(), $subjects::$rules);

    	if($validate->passes()){

    		foreach ($request->all() as $key => $value) {
            	if(!in_array($key, array('_token','_method')) && !empty($value)){
            		if($key == 'subject_code'){
                        $insert[$key] = strtoupper(str_replace(' ', '-', $value));
            		}else{
            			$insert[$key] = ucwords($value);
            		}
                }
            }
            if(count($insert) > 0){
            	$subjects->create($insert);

                flash('You have successfully register '.$insert['subject_name'])->success();

            	return redirect()->back()
    						->withInput();
            }else{

                flash('Sorry, there is an error with your input')->error();

            	return redirect()->back()
    						->withInput();
            }

    	}else{
    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();
    	}

    	

    }

    function adminBatchCreateSchoolSubjects(){

        if($this->permissionDeny('super_admin','create-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    		$all_subjects = $this->subjects->setSubject()
                                            ->get();

    	return view('admin.subjects.batch-create', compact('all_subjects'));

    	}

     function adminBatchRegisterSchoolSubjects(Request $request){

        if($this->permissionDeny('super_admin','create-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subject = $this->subjects->setSubject();

        $validate = Validator::make($request->all(), $subject::$ruleBatch);

        if($validate->passes()){

                if($request->hasFile('batch_file')){

                    $path = $request->file('batch_file')->getRealPath();

                    $ext = $request->file('batch_file')->getClientOriginalExtension();

                    $insert = array();

                    $data = Excel::load($path, function($reader) {
                    })->get();

                    if(!empty($data) && $data->count()){
                        if(in_array($ext, ['xls', 'xlsx'])){
                           // foreach ($data as $rows) {
                                foreach ($data as $key => $value) {

                                    $insert[] = [
                                        'subject_name' => ucwords($value->subject_name),
                                        'subject_code' => strtoupper(str_replace(' ', '-', $value->subject_code)),
                                        'class_category' => $value->class_category,
                                        'created_at' => Carbon::now(),
                                        'updated_at' => Carbon::now()

                                        ];
                                }
                           // }
                        }else{
                            foreach ($data as $key => $value) {

                                $insert[] = [
                                        'subject_name' => $value->subject_name,
                                        'subject_code' => $value->subject_code,
                                        'class_category' => $value->class_category,
                                        'created_at' => Carbon::now(),

                                        'updated_at' => Carbon::now()
                                    ];
                            }
                        }
                        
                            $subject->insert($insert);

                            flash('Successfully inserted '.count($insert).' Subjects')->success();

                            return redirect()->back()
                                             ->withInput();  
                        
                    }
                }
                
               return redirect()->back();     
        }else{
                return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }

    function adminEditSchoolSubject($id){

        if($this->permissionDeny('super_admin','edit-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

            $subject = $this->subjects->find($id);

            $subjects = $this->subjects->setSubject()
                                        ->get();

            return view('admin.subjects.edit', compact('subjects','subject'));
    }

    function adminUpdateSchoolSubject(Request $request, $id){

        if($this->permissionDeny('super_admin','edit-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subject = $this->subjects->setSubject();

        $validate = Validator::make($request->all(), $subject::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','_method')) && !empty($value)){
                    if($key == 'subject_code'){
                        $insert[$key] = strtoupper(str_replace(' ', '-', $value));
            		}else{
            			$insert[$key] = ucwords($value);
            		}
                }
            }

            $this->subjects->find($id)
                    ->update($insert);

            flash('You have successfully updated a subject')->success();

            return redirect()->back();

        }else{
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function adminDeleteSchoolSubject(Request $request, $id){

        if($this->permissionDeny('super_admin','delete-subject')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subject = $this->subjects->find($id);

        $subject_name = $subject->subject_name;

        $subject->delete();

        flash('You have successfully deleted '.$subject_name)->success();

        return redirect()->back();
    }



    public function adminUnassignTeacherSubject()
    {      
        if($this->permissionDeny('admin','remove-subject-from-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $school_id = Session::get('admin.school');
        
        $teachers =  \DB::table('teachers')
                            ->join('subject_teacher', 'teachers.id', '=', 'subject_teacher.teacher_id')
                            ->where('subject_teacher.school_id', $school_id)
                            ->distinct()
                            ->get(['teachers.id', 'teachers.surname', 'teachers.firstname', 'teachers.middlename']);

        return view('admin.subjects.unassign-subject-teacher', compact('teachers', 'school_id'));
    }//End Method



    public function adminUnassignGetTeacherSubjects(Request $request)
    {
        $school_id = Session::get('admin.school');

        $teacher_subjects =  \DB::table('subject_teacher')
                                  ->join('subjects', 'subjects.id', '=', 'subject_teacher.subject_id')
                                  ->where('subject_teacher.school_id', $school_id)
                                  ->where('subject_teacher.teacher_id', $request->teacher_id)
                                  ->get(['subject_teacher.subject_id', 'subjects.subject_name']);

        $sn = 1;
        
        $html = '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th width="10%">S/N</th>
                        <th>Subject Name</th>
                        <th width="12%"></th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($teacher_subjects) > 0){

            foreach($teacher_subjects as $subject){                       

                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$subject->subject_name.'</td>';

                $html .= '<td><input type="checkbox" name="data_id[]" value="'.$subject->subject_id.'" /></td>';
                $html .= '</tr>';

                $sn++;
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table><br>';

        $html = (count($teacher_subjects) > 0) ? $html: 1;

        return $html; 

    }//End Method


    public function adminUnassignTeacherSubjectProcess(Request $request)
    {  
        if($this->permissionDeny('admin','remove-subject-from-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
          'teacher_id' => 'required',
          'school_id' => 'required',
          'data_id' => 'required'
        ]);

        if($validate->passes()){

            $teacher_subjects =  \DB::table('subject_teacher')
                                      ->where('school_id', $request->school_id)
                                      ->where('teacher_id', $request->teacher_id)
                                      ->get(['subject_id']);

            $data_count = count($request->data_id);

            if($data_count > 0 && !empty($teacher_subjects)){

                $success = 0;

                $teacher = $this->teachers->find($request->teacher_id);

                foreach ($request->data_id as $data_id) {
                    $teacher->subjects()->detach($data_id);
                    $success++;
                }

                if($success > 0){
                  flash($success.' Subject have been unassigned from teacher successfully.')->success();
                  return redirect()->route('admin.unassign.teacher.subjects');
                }
                else{
                  flash('Something went wrong while processing the request. Pls try again shortly!')->error();
                  return redirect()->route('admin.unassign.teacher.subjects');
                }

            }
            else{
              flash('Something went wrong while processing the data. Pls try again shortly!')->error();
              return redirect()->route('admin.unassign.teacher.subjects');
            }

        }
        else{ 
          flash('Something went wrong...')->error();
          return redirect()->route('admin.unassign.teacher.subjects')
                ->withErrors($validate)
                ->withInput();
        }

    }//End Method



    public function adminAssignTeacherSubject()
    {      
        if($this->permissionDeny('admin','assign-subject-to-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $school_id = Session::get('admin.school');
        
        $teachers =  \DB::table('teachers')
                            ->where('school_id', $school_id)
                            ->orderBy('teachers.surname')
                            ->get(['teachers.id', 'teachers.surname', 'teachers.firstname', 'teachers.middlename']);

        $subjects = $this->subjects->setSubject()
                                    ->get();

        return view('admin.subjects.assign-subject-teacher', compact('teachers', 'school_id', 'subjects'));
    }//End Method


    public function adminAssignTeacherSubjectProcess(Request $request)
    {  
        if($this->permissionDeny('admin','assign-subject-to-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
          'teacher_id' => 'required',
          'school_id' => 'required',
          'subject_id' => 'required|array:1'
        ]);

        if($validate->passes()){

            $current_subjects_array = array();

            $teacher_subjects =  \DB::table('subject_teacher')
                                      ->where('school_id', $request->school_id)
                                      ->where('teacher_id', $request->teacher_id)
                                      ->get(['subject_id']);   

            foreach($teacher_subjects as $subject){
                $current_subjects_array[] = $subject->subject_id;
            }

            $data_count = count($request->subject_id);

            if($data_count > 0 && !empty($teacher_subjects)){

                $success = 0;

                $assign_subjects = array_diff($request->subject_id, $current_subjects_array);

                if(count($assign_subjects) > 0){

                    $teacher = $this->teachers->find($request->teacher_id);

                    foreach ($assign_subjects as $data_id) {
                        $teacher->subjects()->attach($data_id, ['school_id' => $request->school_id]);
                        $success++;
                    }

                    if($success > 0){
                      flash($success.' Subject have been unassigned from teacher successfully.')->success();
                      return redirect()->route('admin.assign.teacher.subjects');
                    }
                    else{
                      flash('Something went wrong while processing the request. Pls try again shortly!')->error();
                      return redirect()->route('admin.assign.teacher.subjects');
                    }

                }
                else{
                  flash('Subject passed already exist in selected Teacher list.')->error();
                  return redirect()->route('admin.assign.teacher.subjects');                    
                }

            }
            else{
              flash('Something went wrong while processing the data. Pls try again shortly!')->error();
              return redirect()->route('admin.assign.teacher.subjects');
            }

        }
        else{ 
          flash('Something went wrong...')->error();
          return redirect()->route('admin.assign.teacher.subjects')
                ->withErrors($validate)
                ->withInput();
        }

    }//End Method



}//end class
