<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use DB;

use Validator;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\SubjectUnofferedRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use Carbon\Carbon;

use App\PaymentItems;

use Input;

use Auth;

use Gate;

use Session;

use App\School;

use App\Student;

use App\Admin;

class SubjectUnofferedController extends Controller
{
	  protected $admin; 

    protected $students;

    protected $subject_unoffered;

    protected $classes;

    protected $classarms;

    protected $student_results;

	public function __construct(Request $request, AdminRepositoryInterface $admin, StudentRepositoryInterface $students, SubjectUnofferedRepositoryInterface $subject_unoffered, ClassRepositoryInterface $classes, ClassArmRepositoryInterface $classarms, StudentResultRepositoryInterface $student_results){

        $this->admin = $admin;

        $this->students = $students;

        $this->subject_unoffered = $subject_unoffered;

        $this->classes = $classes;

        $this->classarms = $classarms;

        $this->student_results = $student_results;

    }

    protected function permissionDeny($auth, $ability){
        Auth::shouldUse($auth);
        return Gate::denies($ability);
    }


    public function adminStudentSubjects($id, $classarmid, $term, $session)
    {        
        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->find($id);

        $student_subject_unoffered = $this->subject_unoffered->setData()
                                        ->where('student_id', $id)
                                        ->where('classarm_id', $classarmid)
                                        ->where('session', $session)
                                        ->pluck('subject_id');
                            
        $student_subjects =  DB::table('classarm_subject')
                                    ->join('subjects', 'subjects.id', '=', 'classarm_subject.subject_id')
                                    ->where('classarm_subject.classarm_id', $classarmid)
                                    ->where('classarm_subject.session', $session)
                                    ->whereNotIn('classarm_subject.subject_id', $student_subject_unoffered)
                                    ->pluck('classarm_subject.subject_id');
                                    //->get();

        return view('admin.students.subjects', compact('student', 'classarmid', 'session', 'term', 'student_subjects', 'student_subject_unoffered'));
    }//End Method


    public function adminStudentSubjectsDeregisterProcess(Request $request)
    {
        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $subject_unoffered = $this->subject_unoffered->setData();
    
        $validate = Validator::make($request->all(), [
          'student_id' => 'required',
          'classarm_id' => 'required',
          'term' => 'required',
          'session' => 'required',
          'subject_id' => 'required'
        ]);

        if($validate->passes()){

          $subject_count = count($request->subject_id);

            if($subject_count > 0){

                $success = 0;

                foreach ($request->subject_id as $subject_id) {

                    $dbData = [
                      'student_id' => $request->student_id,
                      'classarm_id' => $request->classarm_id,
                      'subject_id' => $subject_id,
                      'session' => $request->session,
                      'created_at' => Carbon::now(),
                      'updated_at' => Carbon::now()
                    ];  

                    $new_id = $subject_unoffered->create($dbData)->id;

                    if($new_id){
                      $success++;
                      $this->student_results->setStudentResult()
                                    ->where('student_id', $request->student_id)
                                    ->where('classarm_id', $request->classarm_id)
                                    ->where('term', $request->term)
                                    ->where('subject_id', $subject_id)
                                    ->where('session', $request->session)
                                    ->delete();
                      
                    }

                }//End loop

                if($success > 0){
                  $s = ($success > 1) ? 's': '';
                  flash($success.' Subject'.$s.' have been deregistered successfully.')->success();
                  return redirect()->route('admin.student.subjects', ['id' => $request->student_id, 'classarmid' => $request->classarm_id, 'term' => $request->term, 'session' => $request->session]);
                }
                else{
                  flash('Something went wrong while processing the request. Pls try again shortly!')->error();
                  return redirect()->route('admin.student.subjects', ['id' => $request->student_id, 'classarmid' => $request->classarm_id, 'term' => $request->term, 'session' => $request->session]);
                }

            }
            else{
              flash('Something went wrong while processing the payment data. Pls try again shortly!')->error();
              return redirect()->route('admin.student.subjects', ['id' => $request->student_id, 'classarmid' => $request->classarm_id, 'term' => $request->term, 'session' => $request->session]);
            }

        }
        else{ 
          flash('Something went wrong...')->error();
          return redirect()->back()
                ->withErrors($validate)
                ->withInput();
        }

    }//End Method


    public function adminClassArmDeregisterSubjectsSearch()
    {      
        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        return view('admin.classarms.deregister-subjects-search', compact('classarm_subjects', 'classarm_id', 'classes', 'classarms'));
    }//End Method


    function adminClassArmDeregisterSubjectsList(Request $request){

        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required',
                'session' => 'required|digits:4'
            ]);

        if($validate->passes()){

              $classarm_id = $request->classarm_id;
              $session = $request->session;
              $term = $request->term;

              $classarm_name = getClassNameByClassID($request->class_id);
                                  
              $classarm_subjects =  DB::table('classarm_subject')
                                          ->join('subjects', 'subjects.id', '=', 'classarm_subject.subject_id')
                                          ->where('classarm_subject.classarm_id', $classarm_id)
                                          ->where('classarm_subject.session', $request->session)
                                          ->get(['classarm_subject.id', 'subjects.subject_name']);

              return view('admin.classarms.deregister-subjects', compact('classarm_subjects', 'term', 'session', 'classarm_id', 'classarm_name', 'request'));

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }//End Method


    public function adminClassArmSubjectsDeregisterProcess(Request $request)
    {
        if($this->permissionDeny('admin','assign-subject-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
    
        $validate = Validator::make($request->all(), [
          'classarm_id' => 'required',
          'session' => 'required',
          'term' => 'required',
          'data_id' => 'required'
        ]);

        if($validate->passes()){

          $data_count = count($request->data_id);

            if($data_count > 0){

                $success = 0;

                foreach ($request->data_id as $data_id) {

                    $data_row = DB::table('classarm_subject')
                                ->where('id', $data_id)
                                ->first();

                    $subject_id = $data_row->subject_id;

                    $del_resp = DB::table('classarm_subject')
                          ->where('classarm_id', $request->classarm_id)
                          ->where('session', $request->session)
                          ->where('id', $data_id)
                          ->delete();

                    if($del_resp && $subject_id){
                      $success++;
                      if($request->del_result){
                          $this->student_results->setStudentResult()
                                        ->where('classarm_id', $request->classarm_id)
                                        ->where('session', $request->session)
                                        ->where('term', $request->term)
                                        ->where('subject_id', $subject_id)
                                        ->delete();
                      }
                    }

                }//End loop

                if($success > 0){
                  $s = ($success > 1) ? 's': '';
                  flash($success.' Subject'.$s.' have been deregistered successfully.')->success();
                  return redirect()->route('admin.classarm.subjects.deregister.search');
                }
                else{
                  flash('Something went wrong while processing the request. Pls try again shortly!')->error();
                  return redirect()->route('admin.classarm.subjects.deregister.search');
                }

            }
            else{
              flash('Something went wrong while processing the data. Pls try again shortly!')->error();
              return redirect()->route('admin.classarm.subjects.deregister.search');
            }

        }
        else{ 
          flash('Something went wrong...')->error();
          return redirect()->route('admin.classarm.subjects.deregister.search')
                ->withErrors($validate)
                ->withInput();
        }

    }//End Method


}
