<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\PracticalSkillRepositoryInterface;

use App\Repositories\CharacterAttitudeRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use App\Teacher;

use App\DebtorPenalty;

use App\Transfer;

use Validator;

use DB;

use Image;

use Hash;

use Session;

use PDF;

use Input;

use App\DigitalPayment;

use App\School;
use App\StudentHouse;

class StudentController extends Controller
{
    protected  $student;

    protected $classes;

    protected $result_voucher;

    protected $school;

    protected $classarm;

    protected $student_comments;

    function __construct(StudentRepositoryInterface $student,ClassRepositoryInterface $classes, ResultVoucherRepositoryInterface $result_voucher, SchoolRepositoryInterface $school, ClassArmRepositoryInterface $classarm, StudentCommentsRepositoryInterface $student_comments){

        $this->middleware('auth:student');

        $this->student = $student;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->school = $school;

        $this->classarm = $classarm;

        $this->student_comments = $student_comments;

    }

    public function dashboard(){

        $title = 'Student Dashboard';
        $noAutoAd = true;

        $student = $this->student->find(\Auth::guard('student')->id());

        return view('student.dashboard', compact('title', 'student', 'noAutoAd'));
    }

    public function profile($id){
        $title = 'Student Edit Profile';

        $ngstates = \App\ngstates::all();

        $student = $this->student->find(\Auth::guard('student')->id());

        return view('student.profile', compact('title', 'student', 'ngstates'));
    }

    public function profileUpdate($id, Request $request){

        $setStudent = $this->student->setStudent();

        $validate = Validator::make($request->all(), $setStudent::$studentProfileRule);

        if($validate->passes()){
            $student = $setStudent->find((\Auth::guard('student')->id()));

            $student->surname = $request->input('surname');
            $student->firstname = $request->input('firstname');
            if(!empty($request->input('middlename'))){
                $student->middlename = $request->input('middlename');
            }
            $student->dob = $request->input('dob');
            $student->gender = $request->input('gender');
            $student->country = $request->input('country');
            $student->state_id = $request->input('state_id');
            $student->lga_id = $request->input('lga_id');
            $student->address = $request->input('address');
            $student->religion = $request->input('religion');
            if(!empty($request->input('middlename'))){
                $student->phone = $request->input('phone');
            }

            $student->save();

            flash('Successfully updated Student Profile')->success();

            return redirect()->route('student.dashboard');

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }
    public function password($id){
        $title = 'Student Password Update';

        $student = $this->student->find(\Auth::guard('student')->id());

        return view('student.password', compact('title', 'student'));
    }

    public function passwordUpdate($id, Request $request){

        $setStudent = $this->student->setStudent();

        $validate = Validator::make($request->all(), $setStudent::$studentPasswordRule);

        if($validate->passes()){
            $student = $setStudent->find((\Auth::guard('student')->id()));

            $student->password = Hash::make($request->input('password'));

            $student->save();

            flash('Successfully updated Student Password')->success();

            return redirect()->route('student.dashboard');

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }


    public function passport($id){

        $title = 'Student Passport Upload';

        $student = $this->student->find(\Auth::guard('student')->id());

        return view('student.passport', compact('title', 'student'));

    }


    public function passportUpdate($id, Request $request){

        $setStudent = $this->student->setStudent();

        $validate = Validator::make($request->all(), $setStudent::$studentPassportRule);

        if($validate->passes()){

            $student = $this->student->find(\Auth::guard('student')->id());

            if ($request->hasFile('passport'))
            {
                if ($student->passport != '/images/passports/no_img_da88a72526.gif') {
                    if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                    {
                        unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                    }
                }
                $image = $request->file('passport');
                $passport_path = md5(time())."-".$student->surname."-".$student->firstname.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(250,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/passports/students/'.$passport_path);

                $student->passport = '/images/passports/students/'.$passport_path.'?cache='.time();

                $student->save();

                flash('You have successfully updated your passport')->success();

                return redirect()->route('student.dashboard');

            }
        }


        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate);
    }

    public function resultSelect($id){

        $title = 'Select Result';

        $classes = $this->classes->setClass()
                                ->where('school_id', Session('student.school'))
                                ->get();

        $student = $this->student->find(\Auth::guard('student')->id());

        return view('student.result-select', compact('classes', 'title', 'student'));

    }

    public function resultSelectPost($id, Request $request){
        $title = 'Student Result View';

        $setStudent = $this->student->setStudent();

        $validate = Validator::make($request->all(), $setStudent::$studentResultSelectRule);

        $grace_session_limit = 2019;
        $grace_sessions = array(2018, 2019);

        $dr_error = 0;
        $dr_error_msg = '';
        
        // check if a digital payment for that session was made
        $student_id = \Auth::guard('student')->id();
        $digitalRecord = DigitalPayment::where('student_id', $student_id)
										->where('is_verified', true)
										->where('session', $request->session)
										->get()->first();


        if(!$digitalRecord){
            if($request->session > $grace_session_limit){
                $dr_error++;
                $dr_error_msg = 'No Digital pin payment has been made for the selected session.';
            }
            elseif(!in_array($request->session, $grace_sessions)){
                $dr_error++;
                $dr_error_msg = 'No Digital pin payment was found for the selected session.';
            }
        }

        if($dr_error > 0){
            flash($dr_error_msg)->error();
            return redirect()->back();
        }

        if($validate->passes()){

            $student = $this->student->find(\Auth::guard('student')->id());

            $session = $request->input('session');            

            $term = $request->input('term');
            
            $class_id = $request->input('class_id');           

            $classarm_id = $request->input('class_arm_id');

            $student_results = $student->studentResults()
                            ->where('session', $session)
                            ->where('class_id', $class_id)
                            ->where('classarm_id', $classarm_id)
                            ->where('term', $term)
                            ->where('status', 1)
                            ->where('school_id', Session::get('student.school'))
                            ->get();

            if($student_results->count() === 0 ){

                flash('Sorry, Result is not avaliable yet or has not been released');

                return redirect()->back()
                        ->withInput();
            }

            $student_debtor = DebtorPenalty::where('student_id', \Auth::guard('student')->id())->first();

            if(count($student_debtor) > 0){
                if($student_debtor->status == 0){
                    
                    flash($student_debtor->issue)->error();

                    return redirect()->back()
                        ->withInput();
                        
                }
            }


            $result_vouchers = $this->result_voucher->setResultVoucher();


            $student_voucher = $result_vouchers->where('student_id', '=', \Auth::guard('student')->id())
                                                //->where('session', '=', $session + 1)
												->where('session', '=', $session)
                                                //->where('term', '=',$term) Term Irrelevant: PIN to be used for WHOLE SESSION
                                                ->where('class_id', '=',$class_id)
                                                ->where('classarm_id', '=',$classarm_id)
                                                ->get();

            if($student_voucher->count() == 0){

                Input::flash();

                flash('You need to purchase result scratch card')->error(); 

                return redirect()->route('student.result.access', ['id' => auth('student')->id()])->withInput();
                                
            }

           return $this->viewStudentResult($request);

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
    }

    public function resultAccess(){
        $title = 'Student Result Scratch Card';
        $student = $this->student->find(auth('student')->id());

        return view('student.result-access', compact('title', 'student'));
    }

    public function resultAccessPost(Request $request){
        $validate = Validator::make($request->all(), [
                                        'pin' => 'required',
                                        'serial' => 'required|pin_and_serial_validate',
                                        'class_arm_id' => 'required|integer',
                                        'class_id' => 'required|integer',
                                        'session' => 'required|digits:4',
                                        'term' => ['required','regex:/(First|Second|Third)/']
        ]);

        if($validate->passes()){

            $result_vouchers = $this->result_voucher->setResultVoucher()->where('serial','=', $request->input('serial'))
                                ->where('pin','=',  $request->input('pin'))
                                ->first();

            $result_vouchers->student_id = auth('student')->id();
            $result_vouchers->classarm_id = $request->input('class_arm_id');
            $result_vouchers->class_id = $request->input('class_id');
            $result_vouchers->session = $request->input('session');
            $result_vouchers->term = $request->input('term');
            $result_vouchers->save();

            return $this->resultSelectPost(auth('student')->id(), $request);
        }

         flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
    }

    public function downloadStudentResult(Request $request){
        return $this->viewStudentResult($request);
    }


    protected function viewStudentResult(Request $request){

        $student = $this->student->find(\Auth::guard('student')->id());


        $student_results = $student->studentResults()
                            ->where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->class_arm_id)
                            ->where('term', $request->term)
                            ->where('school_id', Session::get('student.school'))
                            ->get();

        $student_practical_skill = $student->studentPracticalSkills()
                            ->where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->class_arm_id)
                            ->where('term', $request->term)
                            ->where('school_id', Session::get('student.school'))
                            ->get();

        $student_character_development = $student->studentCharacterAttitudes()
                            ->where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->class_arm_id)
                            ->where('term', $request->term)
                            ->where('school_id', Session::get('student.school'))
                            ->get();

            
       $class_data = $this->classes->find($request->class_id);
       $class_name = $class_data->class_name;
       $class_name_char = strtoupper(substr($class_name, 0, 1)); 

       $classarm_data = $this->classarm->find($request->class_arm_id);

       $classarm_teacher_data = $classarm_data->teachers()
                            ->where('classarm_teacher.classarm_id', $request->class_arm_id)
                            ->first();
        $teacher_signature = $classarm_teacher_data['signature'];

       $classarm_counsellor_data = $classarm_data->counsellors()
                            ->where('classarm_counsellor.classarm_id', $request->classarm_id)
                            ->first();
        $counsellor_signature = $classarm_counsellor_data['signature'];  

        $house_master_signature = '';         

        if(!empty($student->house_id)){
            $school_house = StudentHouse::find($student->house_id);
            if(!empty($school_house)){
                $house_master =  $school_house->house_masters()->first();
                if(!empty($house_master)){
                    $house_master_signature = $house_master['signature'];
                }
            }
        } 

       $schoolData = $this->school->find(Session::get('student.school'));

        $student_comments = $this->student_comments->setStudentComments()
                                ->where('student_id', $student->id)
                                ->where('school_id', $student->school_id)
                                ->where('classarm_id', $request->class_arm_id)
                                ->where('session', $request->session)
                                ->where('term', $request->term)
                                ->first();

        $comment_teacher = (!empty($student_comments->comment_teacher)) ? $student_comments->comment_teacher: ''; 
        $comment_house = (!empty($student_comments->comment_house)) ? $student_comments->comment_house: ''; 
        $comment_guard = (!empty($student_comments->comment_guard)) ? $student_comments->comment_guard: ''; 
        $comment_principal = (!empty($student_comments->comment_principal)) ? $student_comments->comment_principal: '';

        $promotion = getStudentResultPromotion($student->id, $request->class_arm_id, $request->class_id, $request->term, $request->session);      

        //$promotion = 0;
        $promotion_text = $promotion_img = '';


        if($promotion == 1){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        }
        elseif($promotion == 2){
            $promotion_text = 'PROMOTED to Next Class';
            $promotion_img = 'promotion-stamp.jpg';
        }
        elseif($promotion == 3){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        } 
        elseif($promotion == 4){
            $promotion_text = 'WITHDRAW from School';
            $promotion_img = 'withdraw-stamp.jpg';
        } 

        view()->share('school_id',$request->school_id);
        view()->share('student',$student);
        view()->share('student_results',$student_results);
        view()->share('student_practical_skill',$student_practical_skill);
        view()->share('student_character_development',$student_character_development);
        view()->share('logo', url_public('/images/logo-bg.png'));
        view()->share('class_name_char',$class_name_char);
        view()->share('comment_teacher',$comment_teacher);
        view()->share('comment_house',$comment_house);
        view()->share('comment_guard',$comment_guard);
        view()->share('comment_principal',$comment_principal);

        view()->share('promotion_text',$promotion_text);
        view()->share('promotion_img', '/images/'.$promotion_img);

        view()->share('principal_sign',$schoolData->principal_sign);
        view()->share('counsellor_sign',$counsellor_signature);
        view()->share('teacher_signature',$teacher_signature);
        view()->share('house_master_signature',$house_master_signature);
        view()->share('next_session_date',$schoolData->next_session_date);

        view()->share('session_full', $request->session.'/'.($request->session + 1));
        view()->share('term',$request->term);

        flash('Your result will be display in PDF format')->success();

      $pdf = PDF::loadView('student.result-view');
       if($request->input('download') !== null){
            return $pdf->download('pdfview.pdf');
      }

    return $pdf->stream('pdfview.pdf');

       // return view('student.result-view');
    }

    function viewTransferHistory(){

        $title = 'View Transfer History';

        $transfers = Transfer::whereRaw("`student_former_id` = ".auth('student')->id()." OR `student_new_id` = ".auth('student')->id())
                                    ->get();

        $student = auth('student')->user();

        return view('student.student-transfer-view', compact('title', 'transfers', 'student'));

    }

    function transferForm(){

        $title = 'Student Transfer Form';

        $student = $this->student->find(auth('student')->id());

        $schools = $this->school->getAll();

        $student_current_class = DB::table('classarm_student')
                                ->where('student_id', auth('student')->id())
                                ->orderBy('session', 'desc')
                                ->first();

        return view('student.student-transfer-form', compact('title', 'student', 'schools', 'student_current_class'));

    }


    function transferUpdateForm(){

        $title = 'Update Student Transfer Form';

        $student = $this->student->find(auth('student')->id());

        $schools = $this->school->getAll();


        $student_current_class = DB::table('classarm_student')
                                ->where('student_id', auth('student')->id())
                                ->orderBy('session', 'desc')
                                ->first();

        $transfer = Transfer::where('student_former_school', auth('student')->user()->school_id)
                              ->where('student_former_id', auth('student')->id())
                              ->where('session', $student_current_class->session)
                              ->first();

        return view('student.student-transfer-form', compact('title', 'student', 'schools', 'student_current_class', 'transfer'));

    }

    function transferConfirmation(Request $request){

        $validate = Validator::make($request->all(), [
                'transfer_school_id' => 'required',
                'session' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required',
                'reason_for_transfer' => 'required|min:5'
            ]);

        if($validate->passes()){

            $transfer = new Transfer;

            $student_transfer =  $transfer->where('student_former_school', auth('student')->user()->school_id)
                                          ->where('student_former_id', auth('student')->id())
                                          ->where('session', $request->input('session'))
                                          ->first();

            $student = auth('student')->user();

            $debtor = DebtorPenalty::where('student_id', auth('student')->id())
                                    ->where('status', 0)
                                    ->first();

           if(count($student_transfer) == 0){

                $student_transfer =  $transfer->create([
                                                'student_former_id' => auth('student')->id(),
                                                'student_former_school' =>  auth('student')->user()->school_id,
                                                'student_new_school' => $request->input('transfer_school_id'),
                                                'session' => $request->input('session'),
                                                'class_id' => $request->input('class_id'),
                                                'term' => $request->input('term'),
                                                'classarm_id' => $request->input('classarm_id'),
                                                'reason_for_transfer' => $request->input('reason_for_transfer'),
                                                'debtor_id' => count($debtor) > 0 ? $debtor->id : NULL
                                            ]);

                flash('Transfer Confirmation');

                return view('student.student-transfer-confirm', compact('student_transfer', 'student', 'student_transfer'));

           }elseif(null !== $request->input('update')){

                $student_transfer->update([
                        'student_new_school' => $request->input('transfer_school_id'),
                        'session' => $request->input('session'),
                        'class_id' => $request->input('class_id'),
                        'classarm_id' => $request->input('classarm_id'),
                        'term' => $request->input('term'),
                        'reason_for_transfer' => $request->input('reason_for_transfer'),
                        'debtor_id' => count($debtor) > 0 ? $debtor->id : NULL
                    ]);

                flash('Transfer Confirmation');

                return view('student.student-transfer-confirm', compact('student_transfer', 'student', 'student_transfer'));
           }

            flash('You have already started a transfer, Use View Transfer to continue')->error();

            return redirect()->back()
                        ->withInput();

        }

        flash('Something is Wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }

    function transferSubmission(Request $request){

        $validate = Validator::make($request->all(), [
                    'transfer_id' => 'required'
            ]); 

        if($validate->passes()){

            $transfer = Transfer::find($request->transfer_id);

            $transfer->student_status = 1;

            $transfer->save();

            $student_current_class = DB::table('classarm_student')
                                ->where('student_id', auth('student')->id())
                                ->orderBy('session', 'desc')
                                ->first();

            $head_teachers = $this->classarm->find($student_current_class->classarm_id)
                                            ->teachers()
                                            ->wherePivot('session', $student_current_class->session)
                                            ->get();

            return view('student.transfer-print-sheet',compact('transfer', 'student_current_class', 'head_teachers') );

        }

        flash('Something is wrong with your form submission')->error();

        return redirect()->route('view-transfer-history');

    }
    
    public function digitalPaymentReciept(){
        $title = 'Digital Payment Reciept';

        $student = $this->student->find(auth('student')->id());

        $school = School::find(Session::get('student.school'));
        $reciepts = array();
        $payment = DigitalPayment::where('student_id', $student->id)->where('is_verified', true)->get()->first();
        if($payment){
            $reciepts[] = $student;
            flash('Your reciept is available')->success();
            return view('student.reciept', compact('user', 'school', 'reciepts'));
        }
        flash('Reciept not available. Please verify digital payment and check back')->error();
        return back();
    }
}