<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use DB;

use Validator;

use Input;

use Excel;

use Session;

use Auth;

use Gate;

class StudentCommentsController extends Controller
{

    protected $students;

    protected $classes;

    protected $classarms;

    protected $student_comments;

    function __construct(StudentRepositoryInterface $students,ClassRepositoryInterface $classes, ClassArmRepositoryInterface $classarms, StudentCommentsRepositoryInterface $student_comments){

        $this->middleware('auth:admin');

        $this->students = $students;

        $this->classes = $classes;

        $this->classarms = $classarms;

        $this->student_comments = $student_comments;

    }


    function adminBatchUploadCommentsTemplate(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.comments.batch-upload-template', compact('classes'));

    }

    function adminBatchUploadCommentsTemplateProcess(Request $request){
        
        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'term' => 'required',
                'class_id' => 'required',
                'class_arm_id' => 'required'
            ]);

        if($validate->passes()){

            Input::flash();

			return $this->errorReturnForTemplate($request);

        }else{
            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }
    }


    function adminDownloadCommentsTemplate(Request $request){

        $classarm_id = $this->classarms->find($request->input('classarm_id'));

        $students = $classarm_id->students()
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->get(['surname','firstname','middlename', 'regnum'])->toArray();

        if(count($students) > 0){
            foreach ($students as  $value) {
                $data[] = [
                                'fullname' => trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']),
                                'regnum' => $value['regnum'],
                                'comment' => ''
                                ];
            }
        }else{
            $data = array();
        }
        if(count($data) > 0){

           return Excel::create('StudentResultCommentTemplate_'.time(), function($excel) use ($data) {
                $excel->sheet('mySheet', function($sheet) use ($data)
                {
                    $sheet->fromArray($data);
                });
            })->download('xls'); 
            
        }else{
            flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

            return $this->errorReturnForTemplate($request);
        }
        
    }


    function adminBatchUploadComments(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.comments.batch-upload', compact('classes'));

    }



    function adminBatchUploadCommentsProcess(Request $request){

        $student_comments = $this->student_comments->setStudentComments();

        $rules = $student_comments::$ruleForResultUpload;

        $rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv', 'excelFormatAllowed:3'];
        $rules['classarm_id'] = 'required|integer';

        unset($rules['classarm_id']);

        $validate = Validator::make($request->all(), $rules);
		
		//dd($request->all());
		
		$comment_field = getCommentCategoryField($request->category);

        if($validate->passes()){
            if($request->hasFile('batch_file')){

                $path = $request->file('batch_file')->getRealPath();

                $ext = $request->file('batch_file')->getClientOriginalExtension();

                $data = Excel::load($path, function($reader) {
                })->get();

                $insert = array();

                $duplicacy = array();

                $count_students = 0;

                $duplicacy_update_data = array();

                $duplicacy_update_id = array();
                               
			   $school_id = Session::get('admin.school');
			   
			   if(!empty($comment_field)){

					if(!empty($data) && $data->count() > 0){
	
						if(in_array($ext, ['xls', 'xlsx'])){
	
							foreach ($data as $key => $value) {
	
									//check id the regnum exit
	
										$student_id = getStudentIDByRegNum($value->regnum);
	
										if(null === $student_id){
											$duplicacy[] = 'Student Regisration Number <strong>'.$value->regnum.'</strong> does not exit ';
										}else{
											if(empty($value->comment))
											{
												$duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s Comment has not be inputted for  '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
											}
											else{	
												$count_students++;
												$notDuplicate = $this->student_comments->checkCommentDuplicacy($student_id->id, $school_id,$request->classarm_id,$request->session,$request->term);
		
												if($notDuplicate){												
													$insert[] = [
													'student_id' => $student_id->id,
													 $comment_field => $value->comment,
													 'session' => $request->session,
													 'term' => $request->term,
													 'class_id' => $request->class_id,
													 'classarm_id' => $request->classarm_id,
													 'school_id' => $school_id
													];
	
												}else{
													$duplicateCommentId = $this->student_comments->getCommentDuplicacyId($student_id->id, $school_id, $request->classarm_id,$request->session,$request->term);
													    
													$duplicacy_update_data[$duplicateCommentId['id']][] = [
													 $comment_field => $value->comment
													];

													$duplicacy_update_id[] = [
													 'id' => $duplicateCommentId['id']
													];
												}
											
											}
										}
							}
						}
	
	
						if((count($insert) > 0) && empty($duplicacy)){

								$student_comments->insert($insert);
	
								if(!empty($duplicacy_update_id)){
									$d_i = 0;
									foreach ($duplicacy_update_id as $data_row) {
										$data_id = $data_row['id'];
	
										$student_comments_data = $student_comments->find($data_id);
										$student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
										$data_update    =   $student_comments_data->save();
									}//end loop
	
								flash(count($duplicacy_update_id).' Result Comment for '.$count_students.' Students was updated Successfully')->success();
								}
	
								flash('Successfully inserted '.count($insert).' Result Comment for '.$count_students.' Students')->success();
	
								return $this->errorReturnForBatchUpload($request); 
						  }elseif((count($insert) > 0) && !empty($duplicacy)){
	
								$student_comments->insert($insert);
	
								if(!empty($duplicacy_update_id)){
									$d_i = 0;
									foreach ($duplicacy_update_id as $data_row) {
										$data_id = $data_row['id'];
	
										$student_comments_data = $student_comments->find($data_id);
										$student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
										$data_update    =   $student_comments_data->save();
									}
	
								flash(count($duplicacy_update_id).' Result Comment for '.$count_students.' Students updated Successfully')->success();
								}
	
								flash('Successfully inserted '.count($insert).' Result Comment for '.$count_students.' Students')->success();
	
								flash($duplicacy)->error();
	
								return $this->errorReturnForBatchUpload($request); 
						   }else{
								if(!empty($duplicacy_update_id)){
									$d_i = 0;
									foreach ($duplicacy_update_id as $data_row) {
										$data_id = $data_row['id'];
	
										$student_comments_data = $student_comments->find($data_id);
										$student_comments_data->$comment_field = $duplicacy_update_data[$data_id][$d_i][$comment_field];
										$data_update    =   $student_comments_data->save();
									}
	
								flash('Successfully updated '.count($duplicacy_update_id).' Result Comment for '.$count_students.' Students')->success();
								}
								else{
									flash('No fresh Result Comment was submitted.')->error();
								}
	
								if(!empty($duplicacy)){
								 flash($duplicacy)->error();
								}
								
								return $this->errorReturnForBatchUpload($request); 
	
							}
					}else{
						flash('Sorry, the file is empty')->error();
						return $this->errorReturnForBatchUpload($request);
					}
			   }else{
					flash('Sorry, the Comment Category submitted is invalid')->error();
					return $this->errorReturnForBatchUpload($request);
				}		
            }else{
                flash('Sorry, You have not choosen any file')->error();

            return $this->errorReturnForBatchUpload($request);
            }
        }else{
            return $this->errorReturnForBatchUpload($request)->withErrors($validate);
        }

    }


   protected function errorReturnForTemplate(Request $request){
        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

                    if($key == 'classarm_id' || $key == 'class_arm_id'){
                        $inputs['class arm'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

        	$classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

            return view('admin.comments.batch-upload-template-view', compact('inputs', 'classes'));
    }


   protected function errorReturnForBatchUpload(Request $request){
        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','batch_file'])){

                    if($key == 'class_arm_id'){
                        $inputs['class_arm_id'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

            return view('admin.comments.batch-upload', compact('inputs', 'classes'));
    }


}
