<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\NgStatesRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\SchoolIDTemplate;

use App\StudentIDCard;

use Auth;

use Gate;

use Session;

use Image;

use Validator;

use Input;

use Zipper;

use File;


class SchoolIDCardController extends Controller
{
	protected $school;

	protected $ngstate;

	protected $students;

    function __construct(SchoolRepositoryInterface $school, NgStatesRepositoryInterface $ngstate, StudentRepositoryInterface $students){
    	$this->middleware('auth:super_admin');

    	$this->school = $school;

    	$this->ngstate = $ngstate;

    	$this->students = $students;
    }

    function  generateSchoolIDTemplate($id){
    	$title = 'Generate School ID Card Template';

    	$schools = $this->school->find($id);

    	return view('super-admin.idcard.generate-school-id-template-form', compact('schools', 'title'));

    }

    function generateSchoolIDTemplateSUbmit($id, Request $request){

    	$validate = Validator::make($request->all(), ['exp_date' => 'required']);

    	if($validate->passes()){

	    	$school = $this->school->find($id);

	    	if($school->logo !== '/images/school_logos/Nigerian-Coat-of-Arm-icon.png'){

	    	$school_logo = public_path().substr($school->logo, 0, strpos($school->logo, "?"));

	    	$extension = strtolower(substr($school_logo, strrpos($school_logo, ".") + 1));

	    	$school_id_template = new SchoolIDTemplate;

	    	$school_logo_check = $school_id_template->where('school_id', $id)->first();
            

	    	if(count($school_logo_check) === 0){
	    		
		    	$new_dimension_path = '/images/school-id-template/school-logo-new-dimension/'.time().'-'.str_slug($school->name).'.'.$extension;

		    	Image::make($school_logo)->resize(200,null, function($constraint)
		                {
		                    $constraint->aspectRatio();
		                })->save(public_path() . $new_dimension_path);

		    	$school_logo_check = $school_id_template->create([
		    					'school_id' => $id,
		    					'school_id_logo' => $new_dimension_path
		    		]);

	    	}else{

	    		$new_dimension_path = $school_logo_check->school_id_logo;

	    	}

	    	$exp_date = 'EXP '.$request->exp_date;


	    	$template = schoolIDCardTemplate($new_dimension_path, $school->name, $exp_date);

	    	if($template !== false){

		    	$school_logo_check->school_id_design = $template;

		    	$school_logo_check->exp_date = $request->exp_date;

		    	$school_logo_check->save();

		    	flash('You have successfully generated school template')->success();

		    	return redirect()->route('super_admin.view.school-id-card-template');
	    	}

	    	flash('School ID Template was not generated')->error();

    		return redirect()->back();

    	}
    		flash('School Logo has not been uploaded')->error();

    		return redirect()->back();

    	}

    	flash('Something is wrong')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();

    }

    function viewSchoolIDTemplate(){

    	$title = 'View School ID Card Template';

    	$counter = 0;

    	//$get_schools = $this->school->setSchool()->paginate(50);
        $get_schools = $this->school->setSchool()->get();

    	return view('super-admin.idcard.school-id-template-view', compact('get_schools', 'title', 'counter'));
    }

    function viewStudentForIDCardGeneration(){

        $title = 'View Student For School ID Card';

        $ngstate =  $this->ngstate->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        $students = $this->students->setStudent()
                                    ->where('school_id', 0)
                                    ->paginate(20);

        return view('super-admin.idcard.view-student-for-id-card', compact('ngstate_lgas', 'title', 'data', 'students', 'ngstate'));
    }

    function viewStudentForIDCardGenerationPage(Request $request){
        
        // if($this->permissionDeny('view-student')){
        //     $title = 'Permission Deny';
        //     return view('errors.401', compact('title'));
        // }



        $validate = Validator::make($request->all(), [
                    'school' => 'required',
                    'class_id' => 'required',
                    'session' => 'required',
                    'class_arm_id' => 'required',
                    'term' => 'required'
                ]);



        if($validate->passes()){

                $title = 'View Student';

                $ngstate =  $this->ngstate->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }

                $session = $request->session;
                $term = $request->term;
                $classarm = $request->class_arm_id;
                $class_id = $request->class_id;
                $school = $request->school;
        
                $sql = "SELECT `s`.*, `cs`.`classarm_id`, `cs`.`session`, `cs`.`term`, `cs`.`class_id` FROM `students` as `s` LEFT JOIN `classarm_student` as `cs` ON `s`.`id` = `cs`.`student_id` WHERE `cs`.`classarm_id` = '$classarm' AND `cs`.`session` = '$session' AND `cs`.`term` = '$term' AND `cs`.`class_id` = '$class_id' AND `s`.`school_id` = '$school'";


                $students = fetchDataTableWithSql($sql, 50);
        
                Input::flash();

                $counter = 0;
        
                return view('super-admin.idcard.view-student-for-id-card', compact('data', 'students', 'ngstate', 'ngstate_lgas', 'counter'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    function generateStudentIDCard(Request $request){

    	$validate = Validator::make($request->all(), ['student_id' => 'required|max:25', 'school' => 'required']);

    	$pix_not_upload = array();


    	if($validate->passes()){

    		$counter = 0;

    		$school_id_template = SchoolIDTemplate::where('school_id', $request->school)->first();

    		$student_classarm = getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->class_arm_id);

    		$student_idcard_table = new StudentIDCard;

    		if(count($school_id_template) > 0){

	    		foreach ($request->student_id as $key => $student_id) {

	    			$student = $this->students->find($student_id);

	    			$student_fullname = $student->surname.' '.$student->firstname.' '.$student->middlename;

	    			if($student->passport === '/images/passports/no_img_da88a72526.gif'){
	    				
	    				$pix_not_upload[] = $student_fullname.' has not uploaded his/her passport';

	    				continue;
	    			}

					$student_idcard = $student_idcard_table->where('student_id', $student_id)->first(); 

                    $image_saved_to_path = 0;  

	    			if(count($student_idcard) === 0){

				    	$student_passport_idcard = public_path().$student->passport;

                        $extension = strtolower(substr($student_passport_idcard, strrpos($student_passport_idcard, ".") + 1));

                        // Clear out extra string after file extension
                        if (strpos($extension, '?') !== false) {
                            $extension_array = explode('?', $extension);
                            $extension = $extension_array[0];

                            $student_passport_array = explode('.', $student_passport_idcard);
                            $student_passport_idcard = $student_passport_array[0].'.'.$extension;
                        }
                        else{
                            $extension = $extension;
                        }

                        $valid_extension = array('jpg', 'jpeg', 'jpe', 'png', 'gif');
                        // Clear out extra string after file extension


                        if(file_exists($student_passport_idcard) && in_array($extension, $valid_extension)){

                            $student_passport = '/images/passports/students/id-card-pix/'.time().'-'.str_slug(trim($student_fullname)).'.'.$extension;


                            Image::make($student_passport_idcard)->resize(250,null, function($constraint)
                                    {
                                        $constraint->aspectRatio();
                                    })->save(public_path() . $student_passport);

                            $student_idcard = $student_idcard_table->create([
                                            'student_id' => $student_id,
                                            'school_id' => $request->school,
                                            'passport' =>  $student_passport
                                ]);
                            $image_saved_to_path = 1;
                        }
    			    		

			    	}else{

			    		$student_passport = $student_idcard->passport;
                        @unlink(public_path().$student_idcard->id_card);
                        $image_saved_to_path = 1;
			    	}

                    if($image_saved_to_path){
    			    	$student_fullname_uppercase = strtoupper($student_fullname);

    			    	$student_id_card = generateStudentDICard($school_id_template->school_id_design,$student_passport, $student_fullname_uppercase, $student->regnum, $student_classarm, $student->gender, $student->blood_group, $student->parent_phone);

    			    	$student_idcard->id_card = $student_id_card;

    			    	$student_idcard->save();

    			    	++$counter;
                    }

                    $image_saved_to_path = 0;
	    		}
	    	}else{
	    		$pix_not_upload[] = 'You have not generated school id card template';
	    	}

	    	if(count($pix_not_upload) > 0){
	    		$request->session()->flash('flash_message', $pix_not_upload);
	    	}

	    	if($counter > 0){
	    		
		    	Flash('You have sucessfully generated '.$counter.' Student ID Card(s)');
	    	}

	    	return $this->viewStudentForIDCardTemplate($request)->withErrors($validate);
	    	
    	}

    	flash('Something is wrong')->error();

    	return $this->viewStudentForIDCardTemplate($request)->withErrors($validate);
    }

    public function downloadStudentIDCard($id){

    	File::cleanDirectory(public_path().'/images/zip-id-card');

    	$student = $this->students->find($id);

    	$filename = 'images/zip-id-card/'.$student->regnum.'-'.str_slug(trim(strtoupper($student->surname.' '.$student->firstname.' '.$student->middlename))).'.zip';

    	Zipper::make(public_path($filename))->add([public_path().$student->studentIDCard->id_card,public_path().'/images/Back-of-ID.jpg'])->close();

    	return response()->download(public_path($filename));  
    	

    } 

    protected function viewStudentForIDCardTemplate($request){

        $ngstate =  $this->ngstate->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        foreach($request->all() as $key => $value){
            if(!in_array($key, ['_method', '_token', 'student_id'])){
                $data[$key] = $value;
            }
        }

        $session = $request->session;
        $term = $request->term;
        $classarm = $request->class_arm_id;
        $class_id = $request->class_id;
        $school = $request->school;

        $sql = "SELECT `s`.*, `cs`.`classarm_id`, `cs`.`session`, `cs`.`term`, `cs`.`class_id` FROM `students` as `s` LEFT JOIN `classarm_student` as `cs` ON `s`.`id` = `cs`.`student_id` WHERE `cs`.`classarm_id` = '$classarm' AND `cs`.`session` = '$session' AND `cs`.`term` = '$term' AND `cs`.`class_id` = '$class_id' AND `s`.`school_id` = '$school'";


        $students = fetchDataTableWithSql($sql, 50);

        Input::flash();

        $counter = 0;

        return view('super-admin.idcard.view-student-for-id-card', compact('data', 'students', 'ngstate', 'ngstate_lgas', 'counter'));
    
	}
}
