<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\NgStatesRepositoryInterface;

use Validator;

use Excel;

use App\Student;

class SchoolController extends Controller
{
	protected $schools;

    protected $classes;

    protected $school_house;

    protected $subjects;

    protected $ngstates;

    public function __construct(SchoolRepositoryInterface $schools, ClassRepositoryInterface $classes, StudentHouseRepositoryInterface $school_house, SubjectRepositoryInterface $subjects, NgStatesRepositoryInterface $ngstates){

    	$this->schools = $schools;

        $this->classes = $classes;

        $this->school_house = $school_house;

        $this->subjects = $subjects;

        $this->middleware('auth:super_admin', ['only' => ['batchCreate', 'batchRegister']]);

        $this->ngstates = $ngstates;

    }

    function schoolAjax(Request $request){

    	$schools = $this->schools->setSchool();

        

    	 if( $request->ajax() ) {
    	 	$state_id = $request->input('state');
    	 	$lga_id = $request->input('lga');
    	 	if(isset($request->state)){
        	 	$schools_fetch = $schools->where('state_id','=',$state_id)
        	 						->where('lga_id', '=', $lga_id)
        	 						->get();
    	 	}else{
        	 	$schools_fetch = $schools->where('lga_id', '=', $lga_id)
        	 						->get();
    	 	}
            
    	 	$schools_display = $schools->present_schools_for_display($schools_fetch);

            
	        return response()->json([
	            'schoolDisplay' => $schools_display
	        ]);
    	}
    }

    function schoolAjaxOverviewApp(Request $request){
    	$schools = $this->schools->setSchool();
    	
    	 if( $request->ajax() ) {
    	 	$lga_id = $request->lga_id;
    	 	$schools_fetch = $schools->where('lga_id', '=', $lga_id)->get();
            
            $schools_display = [];
            foreach($schools_fetch as $school){
                $schools_display[] = [
                    'id' => $school->id,
                    'name' => $school->name
                ];
            }
        
            return response()->json([
                'message' => 'done',
                'data' => $schools_display
            ], 200);
    	}
        
        return response()->json([
            'message' => 'failed'   
        ], 400);
    }

     function classAjax(Request $request){

        $classes = $this->classes->setClass();

        $schools = $this->schools->setSchool();

        $subjects = $this->subjects->setSubject();

        $school_house = $this->school_house->setSchoolHouse();

        if( $request->ajax() ) {
            $school_id = $request->input('school');
            $class_fetch = $classes->where('school_id','=',$school_id)
                                ->get();
            $school_house_fetch = $school_house->where('school_id','=',$school_id)
                                ->get();

            $subject_fetch = $subjects->get();
            
            $classes_display = $classes->present_classes_for_display($class_fetch);

            $houses_display = $schools->present_schools_for_display($school_house_fetch);

            $subjects_display = $subjects->present_subjects_for_display($subject_fetch);



            return response()->json([
                'classDisplay' => $classes_display,
                'houseDisplay' => $houses_display,
                'subjectDisplay' => $subjects_display
            ]);
        }
    }

    function classAjaxOverviewApp(Request $request){
        
        $classes = $this->classes->setClass();
        
        $schools = $this->schools->setSchool();
        
        $subjects = $this->subjects->setSubject();
        
        $school_house = $this->school_house->setSchoolHouse();
        
        if( $request->ajax() ) {
            $school_id = $request->input('school_id');
            $class_fetch = $classes->where('school_id','=',$school_id)
                                ->get();
            $classes_display = [];
            foreach($class_fetch as $class){
                $classes_display[] = [
                    'id' => $class->id,
                    'name' => $class->class_name
                ];
            }
        
            return response()->json([
                'message' => 'done',
                'data' => $classes_display
            ], 200);
        }
        
        return response()->json([
            'message' => 'failed'   
        ], 400);
    }

    function classAjaxResultApp(Request $request){
        
        $classes = $this->classes->setClass();
        
        $schools = $this->schools->setSchool();
        
        $subjects = $this->subjects->setSubject();
        
        $school_house = $this->school_house->setSchoolHouse();
        
        if( $request->ajax() ) {
            $student = Student::where('regnum', $request->regnum)->get()->first();
            if(!$student){
                return response()->json([
                    'message' => 'Opps! no student with OSSI number "'.$request->regnum.'"'
                ], 400);
            }
            $school_id = $student->school_id;
            $class_fetch = $classes->where('school_id','=',$school_id)
                                ->get();
            $classes_display = [];
            foreach($class_fetch as $class){
                $classes_display[] = [
                    'id' => $class->id,
                    'name' => $class->class_name
                ];
            }
        
            return response()->json([
                'message' => 'done',
                'data' => $classes_display,
                'name' => $student->surname.' '.$student->firstname.' '.$student->middlename
            ], 200);
        }
        
        return response()->json([
            'message' => 'failed'   
        ], 400);
    }
    
    function classArmAjaxOverviewApp(Request $request){
        
        $class_arms = new \App\ClassArms;
         if( $request->ajax() ) {
            $class_id = $request->input('class_id');
            $classarms = $class_arms->where('class_id','=',$class_id)->get();
            $classARMS = [];
            foreach($classarms as $arm){
                $classARMS[] = [
                    'id' => $arm->id,
                    'name' => $arm->class_arm
                ];
            }

            return response()->json([
                'message' => 'done',
                'data' => $classARMS
            ], 200);
        }
        
        return response()->json([
            'message' => 'failed'   
        ], 400);
    }

    public function batchCreate(){
        $title = 'Batch Create Secondary School';

        $ngstate = $this->ngstates->find(28);

        return view('super-admin.school.batch-create-secondary-school', compact('title', 'ngstate'));
    }

    public function batchRegister(Request $request){
        $schools = $this->schools->setSchool();

        $validate = Validator::make($request->all(), $schools::$ruleBatch);

        if($validate->passes()){
            $duplicacy = array();
            $insert = array();
            $path = $request->file('batch_file')->getRealPath();
            $data = Excel::load($path, function($reader) {
                    })->get();

                if(!empty($data) && $data->count() > 0){
                    foreach ($data as $key => $value) {
                        if(!empty($value->school_name) && ($schools->where('name', '=', trim($value->school_name))->count() == 0)){
                            $insert[] = [
                                'name' => trim($value->school_name),
                                'school_category' =>  $request->school_category,
                                'state_id' => $request->state_id,
                                'lga_id' => $request->lga_id
                                ];
                        }else{
                            $duplicacy[] = trim($value->school_name).' has already exist';
                        }
                    }
                }

                if((count($insert) > 0) && empty($duplicacy)){

                    flash('Successfully inserted '.count($insert).' School(s)')->success();

                    $schools->insert($insert);

                    return redirect()->back(); 

                }elseif((count($insert) > 0) && !empty($duplicacy)){

                    $schools->insert($insert);

                    flash($duplicacy)->error();

                    flash('Successfully inserted '.count($insert).' School(s)')->success();

                    return redirect()->back()
                                     ->withInput();  
                }else{

                    if(empty($duplicacy)){
                        flash('Sorry, the file is empty')->error();
                    }else{

                        flash($duplicacy)->error();
                    }


                    return redirect()->back()
                                     ->withInput();  

                }

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors()
                        ->withInput();

    }

}
