<?php

namespace App\Http\Controllers\ResultApp;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\PracticalSkillRepositoryInterface;

use App\Repositories\CharacterAttitudeRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use App\Teacher;

use App\DebtorPenalty;

use App\Transfer;

use Validator;

use DB;

use Image;

use Hash;

use Session;

use PDF;

use Storage;

use Input;

use App\DigitalPayment;

use App\School;

use App\Student;


use App\Classes;
use App\ClassArms;
use App\OndoLGA;
use App\StudentHouse;
use App\ResultVoucher;
use App\StudentResult;
use App\PracticalSkill;
use App\CharacterAttitude;
use App\StudentComments;

use Carbon\Carbon;

use App\ClassAttendanceAnalyticLog;

use App\ClassAttendanceAnalyticTeacher;

use App\SubjectAttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;

class MainController extends Controller
{
	protected  $student;

    protected $classes;

    protected $result_voucher;

    protected $school;

    protected $classarm;

    protected $student_comments;

    function __construct(StudentRepositoryInterface $student,ClassRepositoryInterface $classes, ResultVoucherRepositoryInterface $result_voucher, SchoolRepositoryInterface $school, ClassArmRepositoryInterface $classarm, StudentCommentsRepositoryInterface $student_comments){

    	$this->student = $student;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->school = $school;

        $this->classarm = $classarm;

        $this->student_comments = $student_comments;

    }
    
    public function help(){
        $noTopAd = true;
        return view('result-app.help', compact('noTopAd'));
    }
    
    
    public function resultCheck(Request $request){
        $validate = Validator::make($request->all(), [
            'class_id' => 'required',
            'classarm_id' => 'required',
            'session' => 'required',
            'term' => 'required',
            'regnum' => 'required',
            'card_pin' => 'required',
            'request_type' => 'required'
        ]);

        if($validate->passes()){
            $student_data = Student::where('regnum', $request->regnum)
                                ->first();

            if(!empty($student_data)){
                $student_name = $student_data->firstname.' '.$student_data->surname;
                $student_id = $student_data->id;
                $school_id = $student_data->school_id;
				
				// check if a digital payment for session is active
												//->whereYear('created_at', '=', $request->session + 1)
												
				$digitalRecord = DigitalPayment::where('student_id', $student_id)
												->where('is_verified', true)
												->where('session', $request->session)
												->get()->first();
												
				if(!$digitalRecord){
					flash('Digital payment for the session has not been made for this student.')->error();
					return redirect()->back()
									->withInput();
				}
				else{	
					$student_results = StudentResult::where('session', $request->session)
												->where('class_id', $request->class_id)
												->where('classarm_id', $request->classarm_id)
												->where('term', $request->term)
												->where('school_id', $school_id)
												->where('student_id', $student_id)
												->first();
					
					if(!empty($student_results)){
						$student_result_status = $student_results->status;
					
						if($student_result_status > 0){
							if($request->request_type == 2){
									$error = 0;
									$error_msg = '';
								$student_debtor = DebtorPenalty::where('student_id', $student_data->id)
															->where('school_id', $school_id)
															->first();
			
								if(count($student_debtor) > 0){
									if($student_debtor->status == 0){
										$error++;  
										$error_msg = 'Result Request Aborted! Student ('.$student_name.') is on the School Debtor List';
										flash($error_msg)->error();
										return redirect()->back()
												->withInput();
									}
								}
			
								if($error > 0){
									flash($error_msg)->error();
									return redirect()->back()
													->withInput();
								}
								else{
									$card_pin_data = ResultVoucher::where('pin', $request->card_pin)->get()->first();
									if(!empty($card_pin_data)){
										$result_vouchers = ResultVoucher::find($card_pin_data->id);
		
										$result_vouchers->student_id = $student_data->id;
										$result_vouchers->classarm_id = $request->classarm_id;
										$result_vouchers->class_id = $request->class_id;
										$result_vouchers->session = $request->session;
										$result_vouchers->term = $request->term;
										$result_vouchers->save();
		
										return $this->studentResultViewer($request);
									}
									else{
										flash('Invalid Result Card Pin')->error();
										return redirect()->back()
												->withInput();
									}
								}
							}
							else{
								flash('Invalid Request Type')->error();
								return redirect()->back()
											->withInput();
							}                   
						}
						else{
							flash('Student Result has not been released. Contact School Administrator!')->error();
							return redirect()->back()
											->withInput();                  
						}
					
					}
					else{
						flash('No Result for selected session, term, class and class-arm was found for this student')->error();
						return redirect()->back()
										->withInput();                  
					}
				}
            }
            else{
                flash('Invalid Student OSSI Number')->error();
                return redirect()->back()
                                ->withInput();
            }

        }
        else{
            flash('Please fill all fields')->error();
                return redirect()->back()
                                ->withInput();
        }
    }
    
    

    protected function studentResultViewer(Request $request){

        $student_data = Student::where('regnum', $request->regnum)
                                ->first();

        if(empty($student_data)){
            return redirect()->route('student.result');
        }

        $student = Student::find($student_data->id);
        $student_id = $student_data->id;
        $school_id = $student_data->school_id;

        $student_results = StudentResult::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $school_id)
                            ->where('student_id', $student_id)
                            ->get();

        $student_practical_skill = PracticalSkill::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $school_id)
                            ->where('student_id', $student_id)
                            ->get();

        $student_character_development = CharacterAttitude::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $school_id)
                            ->where('student_id', $student_id)
                            ->get();
            
       $class_data = Classes::find($request->class_id);
       $class_name = $class_data->class_name;
       $class_name_char = strtoupper(substr($class_name, 0, 1)); 

       $classarm_data = ClassArms::find($request->classarm_id);
       $class_arm_name = $classarm_data->class_arm;

       $classarm_teacher_data = $classarm_data->teachers()
                            ->where('classarm_teacher.classarm_id', $request->classarm_id)
                            ->first();
        $teacher_signature = $classarm_teacher_data['signature'];

       $classarm_counsellor_data = $classarm_data->counsellors()
                            ->where('classarm_counsellor.classarm_id', $request->classarm_id)
                            ->first();
        $counsellor_signature = $classarm_counsellor_data['signature']; 

        $house_master_signature = '';         

        if(!empty($student->house_id)){
            $school_house = StudentHouse::find($student->house_id);
            if(!empty($school_house)){
            	$house_master =  $school_house->house_masters()->first();
            	if(!empty($house_master)){
            		$house_master_signature = $house_master['signature'];
            	}
        	}
        }                                             

       $schoolData = School::find($request->school_id);

        $student_comments = StudentComments::where('student_id', $student->id)
                                ->where('school_id', $school_id)
                                ->where('classarm_id', $request->classarm_id)
                                ->where('session', $request->session)
                                ->where('term', $request->term)
                                ->first();

        $comment_teacher = (!empty($student_comments->comment_teacher)) ? $student_comments->comment_teacher: ''; 
        $comment_house = (!empty($student_comments->comment_house)) ? $student_comments->comment_house: ''; 
        $comment_guard = (!empty($student_comments->comment_guard)) ? $student_comments->comment_guard: ''; 
        $comment_principal = (!empty($student_comments->comment_principal)) ? $student_comments->comment_principal: '';                    

        $promotion = getStudentResultPromotion($student->id, $request->classarm_id, $request->class_id, $request->term, $request->session);      

        //$promotion = 0;
        $promotion_text = $promotion_img = '';

        if($promotion == 1){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        }
        elseif($promotion == 2){
            $promotion_text = 'PROMOTED to Next Class';
            $promotion_img = 'promotion-stamp.jpg';
        }
        elseif($promotion == 3){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        } 
        elseif($promotion == 4){
            $promotion_text = 'WITHDRAW from School';
            $promotion_img = 'withdraw-stamp.jpg';
        } 

        view()->share('school_id',$school_id);
        view()->share('student',$student);
        view()->share('student_id',$student->id);
        view()->share('student_results',$student_results);
        view()->share('student_practical_skill',$student_practical_skill);
        view()->share('student_character_development',$student_character_development);
        view()->share('logo', url_public('/images/logo-bg.png'));
        view()->share('class_name_char',$class_name_char);
        view()->share('comment_teacher',$comment_teacher);
        view()->share('comment_house',$comment_house);
        view()->share('comment_guard',$comment_guard);
        view()->share('comment_principal',$comment_principal);
        view()->share('class_id',$request->class_id);
        view()->share('class_name',$class_name);
        view()->share('class_arm_name',$class_arm_name);

        view()->share('promotion_text',$promotion_text);
        view()->share('promotion_img', '/images/'.$promotion_img);

        error_reporting(0);
        view()->share('principal_sign',$schoolData->principal_sign);
        view()->share('counsellor_sign',$counsellor_signature);
        view()->share('teacher_signature',$teacher_signature);
        view()->share('house_master_signature',$house_master_signature);
        view()->share('next_session_date',$schoolData->next_session_date);

        view()->share('session_full', $request->session.'/'.($request->session + 1));
        view()->share('term',$request->term);

        $pdf = PDF::loadView('result-pane');
        $content = $pdf->download()->getOriginalContent();
        $randName = sha1(time());
        Storage::put('blob-result-csv/'.$randName.'.pdf', $content) ;
        return $randName;
        // return $pdf->download($student->regnum.'_result.pdf');
    }
}
