<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\PrimarySchool;

use App\Repositories\NgStatesRepositoryInterface;

use Validator;

use Excel;


class PrimarySchoolController extends Controller
{
	protected $ngstates;

    public function __construct(NgStatesRepositoryInterface $ngstates){
    	$this->middleware('auth:super_admin', ['except', ['schoolAjax']]);

    	$this->ngstates = $ngstates;
    }

    function schoolAjax(Request $request){

    	$schools = new PrimarySchool;

    	 if( $request->ajax() ) {
    	 	$state_id = $request->input('state');
    	 	$lga_id = $request->input('lga');
    	 	$schools_fetch = $schools->where('state_id','=',$state_id)
    	 						->where('lga_id', '=', $lga_id)
    	 						->get();
            
    	 	$schools_display = $schools->present_schools_for_display($schools_fetch);

            
	        return response()->json([
	            'schoolDisplay' => $schools_display
	        ]);
    	}
    }

    public function view(){
    	$title = 'View Primary Schools';

    	$primary_schools = PrimarySchool::orderBy('lga_id', 'asc')
    									->paginate(50);

    	return view('super-admin.school.view-primary-school', compact('title', 'primary_schools'));
    }


    public function batchCreate(){
    	$title = "Batch Create Primary School";

    	$ngstate = $this->ngstates->find(28);

    	return view('super-admin.school.batch-create-primary-school', compact('title', 'ngstate'));
    }

    public function batchRegister(Request $request){

    	$primary_school = new PrimarySchool;

    	$validate = Validator::make($request->all(), $primary_school::$ruleBatch);

    	if($validate->passes()){
    		$duplicacy = array();
    		$insert = array();
    		$path = $request->file('batch_file')->getRealPath();
    		$data = Excel::load($path, function($reader) {
                    })->get();

	            if(!empty($data) && $data->count() > 0){
	                foreach ($data as $key => $value) {
	                    if(!empty($value->school_name) && ($primary_school->where('name', '=', trim($value->school_name))->count() == 0)){
	                        $insert[] = [
	                            'name' => trim($value->school_name),
	                            'state_id' => $request->state_id,
	                            'lga_id' => $request->lga_id
	                            ];
	                    }else{
	                  		$duplicacy[] = trim($value->school_name).' has already exist';
	                  	}
	                }
	            }

	            if((count($insert) > 0) && empty($duplicacy)){

                    flash('Successfully inserted '.count($insert).' School(s)')->success();

                    $primary_school->insert($insert);

                    return redirect()->back(); 

                }elseif((count($insert) > 0) && !empty($duplicacy)){

                	$primary_school->insert($insert);

                    flash($duplicacy)->error();

                    flash('Successfully inserted '.count($insert).' School(s)')->success();

                    return redirect()->back()
                                     ->withInput();  
                }else{

                    if(empty($duplicacy)){
                        flash('Sorry, the file is empty')->error();
                    }else{

                        flash($duplicacy)->error();
                    }
                    return redirect()->back()
                                     ->withInput();  

                }

    	}

    	flash('Something is wrong')->error();

    	return redirect()->back()
    					->withErrors()
    					->withInput();

    }

    public function edit($id){

    	$title = 'Edit Primary School';

    	$ngstate = $this->ngstates->find(28);

    	$school = PrimarySchool::find($id);

    	return view('super-admin.school.edit-primary-school', compact('title', 'ngstate', 'school'));

    }

    public function update($id, Request $request){
    	$validate = Validator::make($request->all(), [
    			'state_id' => 'required|integer',
    			'lga_id' => 'required|integer',
    			'school' => 'required|min:5',
    		]);

    	if($validate->passes()){

    		$primary_school = PrimarySchool::find($id);

    		$primary_school->update([
    				'name' => $request->input('school'),
                    'state_id' => $request->input('state_id'),
                    'lga_id' => $request->input('lga_id')
    			]);

    		flash('You have Successfully update school')->success();

    		return redirect()->back();
    	}

    	flash('Something is wrong')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();
    }

    public function delete($id){

    	$primary_school = PrimarySchool::find($id);

    	$primary_school->delete();

    	flash('You have successfully deleted school')->success();

    	return redirect()->back();

    }


}
