<?php
namespace App\Http\Controllers\Overview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\NgStates;

use Validator;

use Input;

use DB;

use Excel;

use Image;

use Hash;

use Session;

use Carbon\Carbon;

use App\AttendanceAnalytic;

use App\AttendanceAnalyticLog;

use App\ClassAttendanceAnalyticLog;

use App\ClassAttendanceAnalyticTeacher;

use App\SubjectAttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;

use App\School;

use App\Student;

use App\Subject;

use App\Classes;

use Illuminate\Pagination\Paginator;
 
use Illuminate\Pagination\LengthAwarePaginator;

class TeacherController extends Controller
{
	protected  $teacher;

    protected $classes;

    protected $subject;

    protected $students;

    protected $classarms;

    protected $student_results;

    function __construct(TeacherRepositoryInterface $teacher,ClassRepositoryInterface $classes, SubjectRepositoryInterface $subject, StudentRepositoryInterface $students, ClassArmRepositoryInterface $classarms, StudentResultRepositoryInterface $student_results){

    	$this->middleware('auth:teacher');

    	$this->teacher = $teacher;

        $this->classes = $classes;
  
        $this->subject = $subject;

        $this->students = $students;

        $this->classarms = $classarms;

        $this->student_results = $student_results;

    }


	public function dashboard(){
	    $title = 'Teacher Dashboard';
        $noAutoAd = true;
        $today_class_student_attendance = ClassAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                            ->where('student_id', '!=', 0)
                                            ->where('teacher_id', auth('teacher')->user()->id)
                                            ->whereDate('created_at', '>', Carbon::yesterday())
                                            ->get()->count();
        $all_class_student_attendance = ClassAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                            ->where('student_id', '!=', 0)
                                            ->where('teacher_id', auth('teacher')->user()->id)
                                            ->get()->count();
        $today_subject_student_attendance = SubjectAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                            ->where('student_id', '!=', 0)
                                            ->where('teacher_id', auth('teacher')->user()->id)
                                            ->whereDate('created_at', '>', Carbon::yesterday())
                                            ->get()->count();
        $all_subject_student_attendance = SubjectAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                            ->where('student_id', '!=', 0)
                                            ->where('teacher_id', auth('teacher')->user()->id)
                                            ->get()->count();
		return view('overview.teacher.dashboard', compact('title', 'noAutoAd', 'today_class_student_attendance', 'all_class_student_attendance', 'today_subject_student_attendance', 'all_subject_student_attendance'));
		
	}
	
	public function attendanceMark(Request $request){
	    AttendanceAnalyticLog::create([
	        'school_id' => auth('teacher')->user()->school_id,
	        'admin_id' => auth('teacher')->user()->id,
	        'last_seen' => Carbon::now()
	    ]);
	    
	    flash('Attendance marked')->success();
	    return back();
	}
    
    public function attendance($type){
        if($type == 'subject-student'){
            $title = "Subject Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $date = '';
            $session = 0;
            $term = '';
            $class_id = 0;
            $class_arm_id = 0;
            $subject_id = 0;
            if($subjectTeacher = SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                $attendance = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($subjectTeacher) {
                                $query->where('subject_id', $subjectTeacher->subject->id)->whereDate('created_at', '<', Carbon::today());
                            })
                            ->orderBy('session', 'desc')
                            ->paginate(20);
                $attendance_count = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($subjectTeacher) {
                                $query->where('subject_id', $subjectTeacher->subject->id)->whereDate('created_at', '<', Carbon::today());
                            })
                            ->get()
                            ->count();
            }else{
                $attendance = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('subjectAttendanceAnalyticLog', function ($query) {
                                $query->where('subject_id', Subject::get()->first()->id)->whereDate('created_at', '<', Carbon::today());
                            })
                            ->orderBy('session', 'desc')
                            ->paginate(20);
                $attendance_count = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('subjectAttendanceAnalyticLog', function ($query) {
                                $query->where('subject_id', Subject::get()->first()->id)->whereDate('created_at', '<', Carbon::today());
                            })->get()->count();
            }
            return view('overview.teacher.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'class_arm_id', 'type', 'subject_id'));
        }elseif($type == 'class-student'){
            $title = "Class Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $date = '';
            $session = 0;
            $term = '';
            $class_id = 0;
            $class_arm_id = 0;
            if($classTeacher = ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                $attendance = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('classAttendanceAnalyticLog', function ($query) use($classTeacher) {
                                $query->where('class_id', $classTeacher->classes->id)->whereDate('created_at', '<', Carbon::today());
                            })
                            ->orderBy('session', 'desc')
                            ->paginate(20);
                $attendance_count = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('classAttendanceAnalyticLog', function ($query) use($classTeacher) {
                                $query->where('class_id', $classTeacher->classes->id)->whereDate('created_at', '<', Carbon::today());
                            })->get()->count();
            }else{
                $attendance = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('classAttendanceAnalyticLog', function ($query) {
                                $query->whereDate('created_at', '<', Carbon::today());
                            })
                            ->orderBy('session', 'desc')
                            ->paginate(30);
                $attendance_count = Student::where('school_id',  auth('teacher')->user()->school_id)
                            ->whereHas('classAttendanceAnalyticLog', function ($query) {
                                $query->whereDate('created_at', '<', Carbon::today());
                            })->get()->count();
            }
            return view('overview.teacher.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'class_arm_id', 'type'));
        }
        
        return back();
    }
    
    public function attendanceSearch(Request $request, $type){
        if($type == 'subject-student'){
            $title = "Subject Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $date = $request->date;
            $session = $request->session;
            $term = $request->term;
            $class_id = $request->class_id;
            $class_arm_id = $request->class_arm_id;
            $subject_id = $request->subject_id;
            if($date == 'today'){
                $time = Carbon::yesterday();
            }elseif($date == 'yesterday'){
                $time = date("Y-m-d", strtotime( '-2 days' ) );
            }elseif($date == 'this_week'){
                $time = date("Y-m-d", strtotime( '-8 days' ) );
            }elseif($date == 'this_month'){
                $currentMonth = date('m');
                $time = Carbon::now()->subMonth()->month;
            }else{
                $time = '';
            }
            
            $class_arm_id = $this->classarms->find($request->class_arm_id);
            $attendance = $class_arm_id->students()
                                    ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                        $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                    })
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)
                                    ->paginate(30);
            $attendance_count = $class_arm_id->students()
                                    ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                        $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                    })
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)->get()->count();
            
            return view('overview.teacher.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'class_arm_id', 'type', 'subject_id'));
        }elseif($type == 'class-student'){
            $title = "Class Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $date = $request->date;
            $session = $request->session;
            $term = $request->term;
            $class_id = $request->class_id;
            $class_arm_id = $request->class_arm_id;
            if($date == 'today'){
                $time = Carbon::yesterday();
            }elseif($date == 'yesterday'){
                $time = date("Y-m-d", strtotime( '-2 days' ) );
            }elseif($date == 'this_week'){
                $time = date("Y-m-d", strtotime( '-8 days' ) );
            }elseif($date == 'this_month'){
                $currentMonth = date('m');
                $time = Carbon::now()->subMonth()->month;
            }else{
                $time = '';
            }
            
            $class_arm_id = $this->classarms->find($request->class_arm_id);
            $attendance = $class_arm_id->students()
                                    ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                        $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                    })
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)
                                    ->paginate(30);
            $attendance_count = $class_arm_id->students()
                                    ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                        $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                    })
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)->get()->count();
            
            return view('overview.teacher.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'class_arm_id', 'type'));
        }
        
        return back();
    }
    
    // public function studentsAttendance(){
    //     $title = "Students Attendance";
    //     $bag = array();
    //     $today_subject_student_attendance = SubjectAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
    //                                         ->where('student_id', '!=', 0)
    //                                         ->where('teacher_id', auth('teacher')->user()->id)
    //                                         ->whereDate('created_at', '>', Carbon::yesterday())
    //                                         ->get()->count();
    //     $all_subject_student_attendance = SubjectAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
    //                                         ->where('student_id', '!=', 0)
    //                                         ->where('teacher_id', auth('teacher')->user()->id)
    //                                         ->get()->count();
    //     $students = Student::where('school_id',  auth('teacher')->user()->school_id)
    //                 ->whereDoesntHave('attendanceAnalyticLog', function ($query) {
    //                     $query->whereDate('created_at', '>', Carbon::yesterday());
    //                 })
    //                 ->orderBy('session', 'desc')
    //                 ->paginate(30);
    //     return view('overview.teacher.students', compact('title', 'students', 'today_subject_student_attendance', 'all_subject_student_attendance'));
    // }
    
    // public function studentsAttendanceMark(Request $request){
    //     if(count($request->student_id) <= 0){
    //         flash('Select atleast one student to mark')->error();
    //         return back();
    //     }
        
    //     foreach($request->student_id as $id){
    //         $attendance_count = AttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)->where('student_id', $id)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
    //         if($attendance_count <= 0){
    //              AttendanceAnalyticLog::create([
    //     	        'school_id' => auth('teacher')->user()->school_id,
    //     	        'student_id' => $id,
    //     	        'last_seen' => Carbon::now()
    //     	    ]);
    //         }
    //     }
        
    //     flash('Attendance marked')->success();
    //     return back();
    // }
    
    public function subjectAttendance($teacher_id){
        $title = "Students Subject Attendance";
        $school_id = auth('teacher')->user()->school_id;
        $teacher = SubjectAttendanceAnalyticTeacher::find($teacher_id);
        $session = 0;
        $term = '';
        $class_id = 0;
        $class_arm_id = 0;
        $subject_id = $teacher->subject->id;
        if($subjectTeacher = SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
            $subject = Subject::find($subject_id)->subject_name;
            $students = Student::where('id', '=', 0)->where('school_id',  auth('teacher')->user()->school_id)
                        ->whereDoesntHave('subjectAttendanceAnalyticLog', function ($query) use($subject_id) {
                            $query->where('subject_id', $subject_id)->whereDate('created_at', '>', Carbon::yesterday());
                        })
                        ->orderBy('session', 'desc')
                        ->paginate(30);
            return view('overview.teacher.subject-students', compact('title', 'teacher', 'students', 'school_id', 'subject', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id'));  
        }
        
        return redirect('overview-app');
    }
    
    public function subjectAttendanceSearchAndMark(Request $request, $teacher_id){
        $teacher = SubjectAttendanceAnalyticTeacher::find($teacher_id);
        $subject_id = $teacher->subject->id;
        if($request->type && $request->type == 'search'){
            $title = "Students Subject Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $session = $request->session;
            $term = $request->term;
            $class_id = $request->class_id;
            $class_arm_id = $request->class_arm_id;
            if($subjectTeacher = SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                $class_arm_id = $this->classarms->find($request->class_arm_id);
                $subject = Subject::find($subject_id)->subject_name;
                $students = $class_arm_id->students()
                            ->where('school_id',  auth('teacher')->user()->school_id)
                            ->whereDoesntHave('subjectAttendanceAnalyticLog', function ($query) use($subject_id) {
                                $query->where('subject_id', $subject_id)->whereDate('created_at', '>', Carbon::yesterday());
                            })
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->paginate(30);
                return view('overview.teacher.subject-students', compact('title', 'teacher', 'students', 'school_id', 'subject', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id'));  
            }
            
            return redirect('overview-app');
        }elseif($request->type && $request->type == 'mark'){
            $subject_class_category = strtolower(Subject::find($subject_id)->class_category);
            if(count($request->student_id) <= 0){
                flash('Select atleast one student to mark')->error();
                return back();
            }
            if($subject_class_category[0] != strtolower(Classes::find($request->class_id)->class_name[0])){
                flash('Subject class category not matching selected class')->error();
                return back();
            }
            if($subjectTeacher = SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                foreach($request->student_id as $id){
                    $attendance_count = SubjectAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                        ->where('student_id', $id)
                                        ->where('teacher_id', auth('teacher')->user()->id)
                                        ->where('subject_id', $subject_id)
                                        ->whereDate('created_at', '>', Carbon::yesterday())
                                        ->get()->count();
                    if($attendance_count <= 0){
                         SubjectAttendanceAnalyticLog::create([
                	        'school_id' => auth('teacher')->user()->school_id,
                	        'student_id' => $id,
                	        'teacher_id' => auth('teacher')->user()->id,
                	        'subject_id' => $subject_id,
                	        'session' => $request->session,
                	        'term' => $request->term,
                	        'last_seen' => Carbon::now()
                	    ]);
                    }
                }
                
                $title = "Students Subject Attendance";
                $school_id = auth('teacher')->user()->school_id;
                $session = $request->session;
                $term = $request->term;
                $class_id = $request->class_id;
                $class_arm_id = $request->class_arm_id;
                if($subjectTeacher = SubjectAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                    $class_arm_id = $this->classarms->find($request->class_arm_id);
                    $subject = Subject::find($subject_id)->subject_name;
                    $students = $class_arm_id->students()
                                ->where('school_id',  auth('teacher')->user()->school_id)
                                ->whereDoesntHave('subjectAttendanceAnalyticLog', function ($query) use($subject_id) {
                                    $query->where('subject_id', $subject_id)->whereDate('created_at', '>', Carbon::yesterday());
                                })
                                ->wherePivot('session', $request->session)
                                ->wherePivot('term', $request->term)
                                ->wherePivot('class_id', $request->class_id)
                                ->paginate(30);
                    flash('Attendance marked')->success();
                    return view('overview.teacher.subject-students', compact('title', 'students', 'school_id', 'subject', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id'));  
                }
                
                return redirect('overview-app');
            }
            
            flash('Permission denied')->error();
            return back();
        }else{
            flash('Invalid Action')->error();
            return back();
        }
    }
    
    public function classAttendance($teacher_id){
        $title = "Students Class Attendance";
        $school_id = auth('teacher')->user()->school_id;
        $teacher = ClassAttendanceAnalyticTeacher::find($teacher_id);
        $session = 0;
        $term = '';
        $class_arm_id = 0;
        $class_id = $teacher->classes->id;
        if($classTeacher = ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
            $class = Classes::find($class_id)->class_name;
            $students = Student::where('id', '=', 0)->where('school_id',  auth('teacher')->user()->school_id)
                        ->whereDoesntHave('classAttendanceAnalyticLog', function ($query) use($class_id) {
                            $query->where('class_id', $class_id)->whereDate('created_at', '>', Carbon::yesterday());
                        })
                        ->orderBy('session', 'desc')
                        ->paginate(30);
            return view('overview.teacher.class-students', compact('title', 'teacher', 'students', 'school_id', 'class', 'session', 'term', 'class_id', 'class_arm_id'));  
        }
        
        return redirect('overview-app');
    }
    
    public function classAttendanceSearchAndMark(Request $request, $teacher_id){
        $teacher = ClassAttendanceAnalyticTeacher::find($teacher_id);
        $class_id = $teacher->classes->id;
        if($request->type && $request->type == 'search'){
            $title = "Students Class Attendance";
            $school_id = auth('teacher')->user()->school_id;
            $session = $request->session;
            $term = $request->term;
            $class_id = $request->class_id;
            $class_arm_id = $request->class_arm_id;
            if($classTeacher = ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                $class_arm_id = $this->classarms->find($request->class_arm_id);
                $class = Classes::find($class_id)->class_name;
                $students = $class_arm_id->students()
                            ->where('school_id',  auth('teacher')->user()->school_id)
                            ->whereDoesntHave('classAttendanceAnalyticLog', function ($query) use($class_id) {
                                $query->where('class_id', $class_id)->whereDate('created_at', '>', Carbon::yesterday());
                            })
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->paginate(30);
                return view('overview.teacher.class-students', compact('title', 'teacher', 'students', 'school_id', 'class', 'session', 'term', 'class_id', 'class_arm_id'));  
            }
            
            return redirect('overview-app');
        }elseif($request->type && $request->type == 'mark'){
            if(count($request->student_id) <= 0){
                flash('Select atleast one student to mark')->error();
                return back();
            }
            if($classTeacher = ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                foreach($request->student_id as $id){
                    $attendance_count = ClassAttendanceAnalyticLog::where('school_id', auth('teacher')->user()->school_id)
                                        ->where('student_id', $id)
                                        ->where('teacher_id', auth('teacher')->user()->id)
                                        ->where('class_id', $class_id)
                                        ->whereDate('created_at', '>', Carbon::yesterday())
                                        ->get()->count();
                    if($attendance_count <= 0){
                         ClassAttendanceAnalyticLog::create([
                	        'school_id' => auth('teacher')->user()->school_id,
                	        'student_id' => $id,
                	        'teacher_id' => auth('teacher')->user()->id,
                	        'class_id' => $class_id,
                	        'session' => $request->session,
                	        'term' => $request->term,
                	        'last_seen' => Carbon::now()
                	    ]);
                    }
                }
                
                $title = "Students Class Attendance";
                $school_id = auth('teacher')->user()->school_id;
                $session = $request->session;
                $term = $request->term;
                $class_id = $request->class_id;
                $class_arm_id = $request->class_arm_id;
                if($classTeacher = ClassAttendanceAnalyticTeacher::where('school_id', auth('teacher')->user()->school_id)->where('teacher_id', auth('teacher')->user()->id)->get()->first()){
                    $class_arm_id = $this->classarms->find($request->class_arm_id);
                    $class = Classes::find($class_id)->class_name;
                    $students = $class_arm_id->students()
                                ->where('school_id',  auth('teacher')->user()->school_id)
                                ->whereDoesntHave('classAttendanceAnalyticLog', function ($query) use($class_id) {
                                    $query->where('class_id', $class_id)->whereDate('created_at', '>', Carbon::yesterday());
                                })
                                ->wherePivot('session', $request->session)
                                ->wherePivot('term', $request->term)
                                ->wherePivot('class_id', $request->class_id)
                                ->paginate(30);
                    flash('Attendance marked')->success();
                    return view('overview.teacher.class-students', compact('title', 'teacher', 'students', 'school_id', 'class', 'session', 'term', 'class_id', 'class_arm_id'));  
                }
                
                return redirect('overview-app');
            }
            
            flash('Permission denied')->error();
            return back();
        }else{
            flash('Invalid Action')->error();
            return back();
        }
    }
    
    public function paginate($items, $perPage)
    {
        $pageStart = \Request::get('page', 1);
        // $pageStart = 2;
        $offSet = ($pageStart * $perPage) - $perPage;
        $itemsForCurrentPage = array_slice($items, $offSet, $perPage, true);
        return new LengthAwarePaginator($itemsForCurrentPage, count($items), $perPage, Paginator::resolveCurrentPage(), array('path' => Paginator::resolveCurrentPath()));
    }

    public function profile(){
        $title = 'My Profile';
        $user = auth('teacher')->user();
        return view('overview.admin.profile', compact('title', 'user'));
    }
}
