<?php
namespace App\Http\Controllers\Overview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Repositories\NgStatesRepositoryInterface;

use App\Repositories\NgStatesLGARepositoryInterface;

use App\Repositories\OndoLGARepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\SuperAdminRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\PaymentRepositoryInterface;

use App\Repositories\PaymentItemsRepositoryInterface;

use App\Repositories\PaymentRecipientRepositoryInterface;

use App\Http\Requests;

use Validator;

use Hash;

use Image;

use App\Events\SchoolAdminCreate;

use Auth;

Use Gate;

use Input;

use App\NgStates;

use Excel;

use Carbon\Carbon;

use App\Permission;

use DB;

use App\SuperAdmin;

use App\Teacher;

use App\School;

use App\Wallet;

use App\Student;

use App\Admin;

use App\Payment;

use App\Classes;

use App\UnityCenter;

use App\UnityHall;

use App\UnityExam;

use App\UnityHallAllocation;

use App\News;

use App\SchoolIDTemplate;

use App\StudentResult;

use App\Transaction;

use App\PaymentItems;

use App\DigitalPayment;

use App\StudentIDCardRequest;

use App\Subject;

use App\AttendanceAnalyticLog;

use App\ClassAttendanceAnalyticLog;

use App\ClassAttendanceAnalyticTeacher;

use App\SubjectAttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;


class SuperAdminController extends Controller
{
    protected $ngstates;

    protected $ngstate_lga;

    protected $schools;

    protected $payment;

    protected $payment_recipient;

    protected $payment_items;

    protected $school_admins;

    protected $permissions;

    protected $admin;

    protected $superadmin;

    protected $ondo_lga;

    protected $students;

    protected $teachers;

    protected $house;

    protected $class_arms;

    protected $classes;

    protected $subjects;

    public function __construct(NgStatesRepositoryInterface $ngstates, NgStatesLGARepositoryInterface $ngstate_lga, SchoolRepositoryInterface $schools, AdminRepositoryInterface $school_admins, PermissionRepositoryInterface $permissions, AdminRepositoryInterface $admin, SuperAdminRepositoryInterface $superadmin, OndoLGARepositoryInterface $ondo_lga, StudentRepositoryInterface $student,TeacherRepositoryInterface $teacher,StudentHouseRepositoryInterface $house,ClassArmRepositoryInterface $class_arm, ClassRepositoryInterface $classes, SubjectRepositoryInterface $subject, PaymentRepositoryInterface $payment, PaymentRecipientRepositoryInterface $payment_recipient, PaymentItemsRepositoryInterface $payment_items){

        $this->middleware('auth:super_admin');

        $this->ngstates = $ngstates;

        $this->ngstate_lga = $ngstate_lga;

        $this->schools = $schools;

        $this->payment = $payment;

        $this->payment_recipient = $payment_recipient;

        $this->payment_items = $payment_items;

        $this->admin = $admin;

        $this->permissions = $permissions;

        $this->superadmin = $superadmin;

        $this->ondo_lga = $ondo_lga;

        $this->students = $student;

        $this->teachers = $teacher;

        $this->school_houses = $house;

        $this->class_arms = $class_arm;

        $this->classes = $classes;

        $this->subjects = $subject;


    }


    protected function permissionDeny($ability){
        Auth::shouldUse('super_admin');
        return Gate::denies($ability);
    }


    public function dashboard(){

        $title = "Super Admin Dashboard";
        $noAutoAd = true;
        $super_admin_id = auth('super_admin')->id();
        
        $today_admin_attendance = AttendanceAnalyticLog::where('admin_id', '!=', 0)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
        $all_admin_attendance = AttendanceAnalyticLog::where('admin_id', '!=', 0)->get()->count();
        $today_teacher_attendance = AttendanceAnalyticLog::where('teacher_id', '!=', 0)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
        $all_teacher_attendance = AttendanceAnalyticLog::where('teacher_id', '!=', 0)->get()->count();
        $today_student_attendance = AttendanceAnalyticLog::where('student_id', '!=', 0)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
        $all_student_attendance = AttendanceAnalyticLog::where('student_id', '!=', 0)->get()->count();
        $today_subject_student_attendance = SubjectAttendanceAnalyticLog::where('student_id', '!=', 0)
                                            ->whereDate('created_at', '>', Carbon::yesterday())
                                            ->get()->count();
        $all_subject_student_attendance = SubjectAttendanceAnalyticLog::where('student_id', '!=', 0)
                                            ->get()->count();

        return view('overview.super-admin.dashboard', compact('title', 'super_admin_id', 'noAutoAd', 'today_admin_attendance', 'all_admin_attendance', 'today_teacher_attendance', 'all_teacher_attendance', 'today_student_attendance', 'all_student_attendance', 'today_subject_student_attendance', 'all_subject_student_attendance'));
    }
    
    public function attendance($type){
        $title = "Attendance";
        $super_admin_id = auth('super_admin')->id();
        $date = '';
        $lga = 0;
        $school_id = 0;
        $session = 0;
        $term = '';
        $class_id = 0;
        $class_arm_id = 0;
        $subject_id = '';
        $currentMonth = date('m');
        $time = Carbon::now()->subMonth()->month;
        if($type == 'administrator'){
            $attendance = AttendanceAnalyticLog::where('admin_id', '!=', 0)->orderBy('created_at', 'desc')->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('admin_id', '!=', 0)->orderBy('created_at', 'desc')->get()->count();
        }elseif($type == 'teacher'){
            $attendance = AttendanceAnalyticLog::where('teacher_id', '!=', 0)->orderBy('created_at', 'desc')->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('teacher_id', '!=', 0)->orderBy('created_at', 'desc')->get()->count();
        }elseif($type == 'student'){
            $attendance = Student::whereHas('classAttendanceAnalyticLog', function ($query) {
                                        $query->whereDate('created_at', '<', Carbon::today());
                                    })
                                    ->orderBy('session', 'desc')
                                    ->paginate(20);
            $attendance_count = Student::whereHas('classAttendanceAnalyticLog', function ($query) {
                                        $query->whereDate('created_at', '<', Carbon::today());
                                    })
                                    ->get()
                                    ->count();
        }
        
        return view('overview.super-admin.attendance', compact('title', 'super_admin_id', 'attendance', 'attendance_count', 'type', 'date', 'lga', 'school_id', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id', 'time'));
    }
    
    public function attendanceSearch(Request $request, $type){
        $title = "Attendance";
        $super_admin_id = auth('super_admin')->id();
        $lga = $request->lga_id;
        $school_id = $request->school_id;
        $date = $request->date;
        $session = $request->session;
        $term = $request->term;
        $class_id = $request->class_id;
        $class_arm_id = $request->class_arm_id;
        $subject_id = $request->subject_id;
        if($date == 'today'){
            $time = Carbon::yesterday();
        }elseif($date == 'yesterday'){
            $time = date("Y-m-d", strtotime( '-2 days' ) );
        }elseif($date == 'this_week'){
            $time = date("Y-m-d", strtotime( '-8 days' ) );
        }elseif($date == 'this_month'){
            $currentMonth = date('m');
            $time = Carbon::now()->subMonth()->month;
        }else{
            $time = '';
        }
        
        if($type == 'administrator'){
            $attendance = AttendanceAnalyticLog::where('admin_id', '!=', 0)
                        ->where('school_id', $school_id)
                        ->whereDate('created_at', '>', $time)
                        ->orderBy('created_at', 'desc')
                        ->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('admin_id', '!=', 0)
                                ->where('school_id', $school_id)
                                ->whereDate('created_at', '>', $time)
                                ->orderBy('created_at', 'desc')
                                ->get()
                                ->count();
        }elseif($type == 'teacher'){
            $attendance = AttendanceAnalyticLog::where('teacher_id', '!=', 0)
                        ->where('school_id', $school_id)
                        ->whereDate('created_at', '>', $time)
                        ->orderBy('created_at', 'desc')
                        ->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('teacher_id', '!=', 0)
                                ->where('school_id', $school_id)
                                ->whereDate('created_at', '>', $time)
                                ->orderBy('created_at', 'desc')
                                ->get()
                                ->count();
        }elseif($type == 'student'){
            $class_arm_id = $this->class_arms->find($request->class_arm_id);
            if($subject_id != '' && $subject_id != 0){
                $attendance = $class_arm_id->students()
                                        ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                            $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        ->paginate(30);
                $attendance_count = $class_arm_id->students()
                                        ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                            $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)->get()->count();
            }else{
                $attendance = $class_arm_id->students()
                                        ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                            $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        ->paginate(30);
                $attendance_count = $class_arm_id->students()
                                        ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                            $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)->get()->count();
            }
        }
        
        return view('overview.super-admin.attendance', compact('title', 'super_admin_id', 'attendance', 'attendance_count', 'type', 'date', 'lga', 'school_id', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id', 'time'));
    }

    public function profile(){
        $title = 'My Profile';
        $user = auth('super_admin')->user();
        return view('overview.super-admin.profile', compact('title', 'user'));
    }
}