<?php

namespace App\Http\Controllers\Overview\Auth;

use Illuminate\Http\Request;
use App\Student;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Repositories\NgStatesRepositoryInterface;
use Validator;
use Auth;
use Session;

class StudentAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = '/overview-app/student/dashboard';

     protected $redirectAfterLogout = '/overview-app';

     protected $ngstates;

     public function __construct(NgStatesRepositoryInterface $ngstate){
        $this->ngstates = $ngstate;
     	$this->middleware('guest:student', ['except' => ['logout']]);
     }


     public function showLoginForm(){
        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

     	return view('student.login', compact('ngstate', 'ngstate_lgas'));
     }

      protected function validateLogin(Request $request)
    {
        $this->validate($request, Student::$rulesLogin);
    }


     public function login(Request $request){

        $this->validateLogin($request);

     	$throttles = $this->isUsingThrottlesLoginsTrait();
        
        if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if (Auth::guard('student')->attempt(['regnum' => $request->input('regnum'), 'password' => $request->input('password')])) {
            Session::put('student.school', auth('student')->user()->school_id);
            flash('Welcome back '.strtolower(auth('student')->user()->surname))->success();
            return $this->handleUserWasAuthenticated($request, $throttles);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        if ($throttles && ! $lockedOut) {
            $this->incrementLoginAttempts($request);
        }

        flash('Opps! credentials not found')->error();

        return $this->sendFailedLoginResponse($request)->withInput();

     }

     public function logout()
    {
        Auth::guard('student')->logout();
        Session::forget('student.school');
        return redirect('/overview-app');
    }

}