<?php
namespace App\Http\Controllers\Overview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\NgStatesRepositoryInterface;

use App\Repositories\NgStatesLGARepositoryInterface;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use Validator;

use Hash;

use Session;

use App\Events\SchoolAdminCreate;

use Gate;

use Auth;

use DB;

use Image;

use App\NgStates;

use App\School;

use App\Student;

use App\Teacher;

use App\Classes;

use App\Timetable;

use App\TimetablePeriod;

use App\Subject;

use App\StudentIDCardRequest;

use Input;

use Zipper;

use ZipArchive;

use App\DigitalPayment;

use App\Assessment;

use App\AssessmentImage;

use App\AttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;

use App\ClassAttendanceAnalyticTeacher;

use Carbon\Carbon;

use Illuminate\Pagination\Paginator;

use Illuminate\Pagination\LengthAwarePaginator;

class AdminController extends Controller
{
    protected $ngstates;

    protected $ngstate_lga;

	protected $admin;

	protected $permission;

    protected $classes;
    
    protected $result_voucher;

    protected $class_arms;

    protected $school_houses;

	protected $student;

	protected $students;

	protected $teacher;

	protected $schools;

	public function __construct(NgStatesRepositoryInterface $ngstates, ClassRepositoryInterface $classes,ClassArmRepositoryInterface $class_arms, ResultVoucherRepositoryInterface $result_voucher, StudentHouseRepositoryInterface $school_houses, NgStatesLGARepositoryInterface $ngstate_lga, AdminRepositoryInterface $admin, PermissionRepositoryInterface $permission,SchoolRepositoryInterface $schools,StudentRepositoryInterface $student, TeacherRepositoryInterface $teacher){

		$this->middleware('auth:admin');

        $this->ngstates = $ngstates;

        $this->ngstate_lga = $ngstate_lga;

		$this->admin = $admin;

		$this->permission = $permission;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->class_arms = $class_arms;

        $this->school_houses = $school_houses;

        $this->schools = $schools;

        $this->students = $student;

	}


	protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

	public function dashboard(){
	    $title = 'Admin Dashboard';
        $noAutoAd = true;
        $today_attendance = AttendanceAnalyticLog::whereDate('created_at', '>', Carbon::yesterday())->where('admin_id', auth('admin')->user()->id)->get();
        $today_teacher_attendance = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', '!=', 0)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
        $all_teacher_attendance = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', '!=', 0)->get()->count();
        $today_student_attendance = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('student_id', '!=', 0)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
        $all_student_attendance = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('student_id', '!=', 0)->get()->count();
		return view('overview.admin.dashboard', compact('title', 'noAutoAd', 'today_attendance', 'today_teacher_attendance', 'all_teacher_attendance', 'today_student_attendance', 'all_student_attendance'));
		
	}
	
	public function attendanceMark(Request $request){
	    AttendanceAnalyticLog::create([
	        'school_id' => auth('admin')->user()->school_id,
	        'admin_id' => auth('admin')->user()->id,
	        'last_seen' => Carbon::now()
	    ]);
	    
	    flash('Attendance marked')->success();
	    return back();
	}
	
	public function subjectTeacher(){
	    $title = 'Subject Teachers';
	    $subject_teachers = SubjectAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)->paginate(30);
	    $teachers = Teacher::where('school_id', auth('admin')->user()->school_id)->get();
	    $classes = Classes::where('school_id', auth('admin')->user()->school_id)->get();
	    $subjects = Subject::all();
	    return view('overview.admin.subject-teacher', compact('title', 'subject_teachers', 'teachers', 'classes', 'subjects'));
	}
	
	public function subjectTeacherAction(Request $request){
	   // return $request->all();
	    if($request->action == 'create'){
	        $oldRecord = SubjectAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)
	                   ->where('teacher_id', $request->teacher_id)
	                   ->where('class_id', $request->class_id)
	                   ->where('class_arm_id', $request->class_arm_id)
	                   ->where('subject_id', $request->subject_id)
	                   ->get();
	        $doubleSubject = SubjectAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)
	                   ->where('class_id', $request->class_id)
	                   ->where('class_arm_id', $request->class_arm_id)
	                   ->where('subject_id', $request->subject_id)
	                   ->get();
	        if($oldRecord->count() > 0){
	            flash("Opps! you can't create a subject teacher with the same subject twice")->error();
	            return back();
	        }elseif($doubleSubject->count() > 0){
	            flash("Opps! you can't assign the same subject twice")->error();
	            return back();
	        }
	        
	        SubjectAttendanceAnalyticTeacher::create([
	            'school_id' =>  auth('admin')->user()->school_id,
	            'class_id' =>  $request->class_id,
	            'class_arm_id' =>  $request->class_arm_id,
	            'subject_id' =>  $request->subject_id,
	            'teacher_id' =>  $request->teacher_id
	        ]);
	        
	        flash('Subject teacher created')->error();
	        return back();
	    }
	    
	    if($request->action == 'delete'){
	        if(count($request->teacher_id) <= 0){
	            flash('Select atleast one teacher')->error();
	            return back();
	        }
	        
	        foreach($request->teacher_id as $id){
	            SubjectAttendanceAnalyticTeacher::find($id)->delete();
	        }
	        
	        if(count($request->teacher_id) > 1){
	            flash('Subject teachers were deleted')->success();
	        }else{
	            flash('Subject teacher was deleted')->success();
	        }
	        return back();
	    }
	    
	    return back();
	}
	
	public function classTeacher(){
	    $title = 'Class Teachers';
	    $class_teachers = ClassAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)->paginate(30);
	    $teachers = Teacher::where('school_id', auth('admin')->user()->school_id)->get();
	    $classes = Classes::where('school_id', auth('admin')->user()->school_id)->get();
	    return view('overview.admin.class-teacher', compact('title', 'class_teachers', 'teachers', 'classes'));
	}
	
	public function classTeacherAction(Request $request){
	    if($request->action == 'create'){
	        $oldRecord = ClassAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)
	                   ->where('teacher_id', $request->teacher_id)
	                   ->where('class_id', $request->class_id)
	                   ->where('class_arm_id', $request->class_arm_id)
	                   ->get();
	        $doubleSubject = ClassAttendanceAnalyticTeacher::where('school_id', auth('admin')->user()->school_id)
	                   ->where('class_id', $request->class_id)
	                   ->where('class_arm_id', $request->class_arm_id)
	                   ->get();

	        if($oldRecord->count() > 0){
	            flash("Opps! you can't create a class teacher with the same class & class-arm twice")->error();
	            return back();
	        }elseif($doubleSubject->count() > 0){
	            flash("Opps! you can't assign the same class & class-arm twice")->error();
	            return back();
	        }
	        
	        ClassAttendanceAnalyticTeacher::create([
	            'school_id' =>  auth('admin')->user()->school_id,
	            'class_id' =>  $request->class_id,
	            'class_arm_id' =>  $request->class_arm_id,
	            'teacher_id' =>  $request->teacher_id
	        ]);
	        
	        flash('Class teacher created')->error();
	        return back();
	    }
	    
	    if($request->action == 'delete'){
	        if(count($request->teacher_id) <= 0){
	            flash('Select atleast one teacher')->error();
	            return back();
	        }
	        foreach($request->teacher_id as $id){
	            ClassAttendanceAnalyticTeacher::find($id)->delete();
	        }
	        
	        if(count($request->teacher_id) > 1){
	            flash('Subject teachers were deleted')->success();
	        }else{
	            flash('Subject teacher was deleted')->success();
	        }
	        return back();
	    }
	    
	    return back();
	}
    
    public function attendance($type){
        $title = "Attendance";
        $date = '';
        $school_id = auth('admin')->user()->school_id;
        $session = 0;
        $term = '';
        $class_id = 0;
        $class_arm_id = 0;
        $subject_id = '';
        $currentMonth = date('m');

        if($type == 'teacher'){
            $attendance = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', '!=', 0)->orderBy('created_at', 'desc')->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', '!=', 0)->orderBy('created_at', 'desc')->get()->count();
        }elseif($type == 'student'){
            $attendance = Student::whereHas('classAttendanceAnalyticLog', function ($query) {
                                        $query->where('school_id', auth('admin')->user()->school_id)->whereDate('created_at', '<', Carbon::today());
                                    })
                                    ->orderBy('session', 'desc')
                                    ->paginate(30);
            $attendance_count = Student::whereHas('classAttendanceAnalyticLog', function ($query) {
                                        $query->where('school_id', auth('admin')->user()->school_id)->whereDate('created_at', '<', Carbon::today());
                                    })
                                    ->get()
                                    ->count();
        }
        
        return view('overview.admin.attendance', compact('title', 'attendance', 'attendance_count', 'type', 'date', 'school_id', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id', 'time'));
    }
    
    public function attendanceSearch(Request $request, $type){
        $title = "Attendance";
        $admin_id = auth('admin')->id();
        $school_id = auth('admin')->user()->school_id;
        $date = $request->date;
        $session = $request->session;
        $term = $request->term;
        $class_id = $request->class_id;
        $class_arm_id = $request->class_arm_id;
        $subject_id = $request->subject_id;
        if($date == 'today'){
            $time = Carbon::yesterday();
        }elseif($date == 'yesterday'){
            $time = date("Y-m-d", strtotime( '-2 days' ) );
        }elseif($date == 'this_week'){
            $time = date("Y-m-d", strtotime( '-8 days' ) );
        }elseif($date == 'this_month'){
            $currentMonth = date('m');
            $time = Carbon::now()->subMonth()->month;
        }else{
            $time = '';
        }
        
        if($type == 'teacher'){
            $attendance = AttendanceAnalyticLog::where('teacher_id', '!=', 0)
                        ->where('school_id', $school_id)
                        ->whereDate('created_at', '>', $time)
                        ->orderBy('created_at', 'desc')
                        ->paginate(30);
            $attendance_count = AttendanceAnalyticLog::where('teacher_id', '!=', 0)
                                ->where('school_id', $school_id)
                                ->whereDate('created_at', '>', $time)
                                ->orderBy('created_at', 'desc')
                                ->get()
                                ->count();
        }elseif($type == 'student'){
            $class_arm_id = $this->class_arms->find($request->class_arm_id);
            if($subject_id != '' && $subject_id != 0){
                $attendance = $class_arm_id->students()
                                        ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                            $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        ->paginate(5);
                $attendance_count = $class_arm_id->students()
                                        ->whereHas('subjectAttendanceAnalyticLog', function ($query) use($time, $subject_id) {
                                            $query->where('subject_id', $subject_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)->get()->count();
            }else{
                $attendance = $class_arm_id->students()
                                        ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                            $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        ->paginate(5);
                $attendance_count = $class_arm_id->students()
                                        ->whereHas('classAttendanceAnalyticLog', function ($query) use($time, $class_id) {
                                            $query->where('class_id', $class_id)->whereDate('created_at', '>', $time);
                                        })
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)->get()->count();
            }
        }
        
        return view('overview.admin.attendance', compact('title', 'admin_id', 'attendance', 'attendance_count', 'type', 'date', 'school_id', 'session', 'term', 'class_id', 'class_arm_id', 'subject_id', 'time'));
    }
    
    public function teachersAttendance(){
        $title = "Teachers Attendance";
        $bag = array();
        $teachers = Teacher::where('school_id',  auth('admin')->user()->school_id)->orderBy('session', 'desc')->paginate(30);
        foreach($teachers as $teacher){
            $attendance_count = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', $teacher->id)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
            if($attendance_count <= 0){
                $bag[] = $teacher;
            }
        }
        $attendance = $this->paginate($bag, 30);
        return view('overview.admin.teachers', compact('title', 'attendance'));
    }
    
    public function teachersAttendanceMark(Request $request){
        foreach($request->teacher_id as $id){
            $attendance_count = AttendanceAnalyticLog::where('school_id', auth('admin')->user()->school_id)->where('teacher_id', $id)->whereDate('created_at', '>', Carbon::yesterday())->get()->count();
            if($attendance_count <= 0){
                 AttendanceAnalyticLog::create([
        	        'school_id' => auth('admin')->user()->school_id,
        	        'teacher_id' => $id,
        	        'last_seen' => Carbon::now()
        	    ]);
            }
        }
        
        flash('Attendance marked')->success();
        return back();
    }
    
    public function paginate($items, $perPage)
    {
        $pageStart = \Request::get('page', 1);
        // $pageStart = 2;
        $offSet = ($pageStart * $perPage) - $perPage;
        $itemsForCurrentPage = array_slice($items, $offSet, $perPage, true);
        return new LengthAwarePaginator($itemsForCurrentPage, count($items), $perPage, Paginator::resolveCurrentPage(), array('path' => Paginator::resolveCurrentPath()));
    }

    public function profile(){
        $title = 'My Profile';
        $user = auth('admin')->user();
        return view('overview.admin.profile', compact('title', 'user'));
    }
}