<?php

namespace App\Http\Controllers;

use DB;

use Illuminate\Http\Request;

use App\Http\Requests;

use Validator;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\LibraryRepositoryInterface;

use App\Repositories\LibraryCategoryRepositoryInterface;

use App\Repositories\LibraryIssueRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use Carbon\Carbon;

use App\PaymentItems;

use Input;

use Auth;

use Session;

use App\School;

use App\Student;

use App\Admin;

class LibraryController extends Controller
{

	protected $admin;  

    protected $permission;

    protected $students;

    protected $library;

    protected $library_category;

    protected $library_issue;

    protected $classes;

	public function __construct(Request $request, AdminRepositoryInterface $admin, PermissionRepositoryInterface $permission, StudentRepositoryInterface $students, LibraryRepositoryInterface $library, LibraryCategoryRepositoryInterface $library_category, LibraryIssueRepositoryInterface $library_issue, ClassRepositoryInterface $classes){

        $this->admin = $admin;

        $this->permission = $permission;

        $this->students = $students;

        $this->library = $library;

        $this->library_category = $library_category;

        $this->library_issue = $library_issue;

        $this->classes = $classes;

    }

//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  START: LibraryCategory  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

	
	public function libraryCategoryCreate(){
		
        return view('admin.library.category-create');
				
	}// End function


    public function libraryCategoryCreateProcess(Request $request)
    {
        $library_category = $this->library_category->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'name' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$verify_library_category =  $this->library_category->setData()
                            ->where('school_id', $school_id)
                            ->where('name', $request->name)
                            ->first();

            if($verify_library_category['id']){
	            flash('Category name ('.$verify_library_category['name'].') already exist. You must specify a unique name')->error();
	            return redirect()->route('admin.library.create.category');            	
            }
            else{

	            $dbData = [
	                'name' => ucwords(strtolower($request->name)),
	                'school_id' => $school_id,
	                'created_at' => Carbon::now(),
	                'updated_at' => Carbon::now()
	            ];  

	            $cat_id = $library_category->create($dbData)->id;

	            if($cat_id){
	                flash('Library Category has been successfully created.')->success();
	                return redirect()->route('admin.library.create.category');
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.create.category');
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

	}// End function


    public function libraryCategoryAll()
    {        

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $categories = $this->library_category->setData()
                            ->where('school_id', $school_id)
                            ->orderBy('name', 'asc')
                            ->get();

        return view('admin.library.category-all', compact('categories'));
    }//End Method


    public function libraryCategoryEdit($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

       	$category = $this->library_category->find($id); 

        return view('admin.library.category-edit', compact('category'));
    }//End Method


    public function libraryCategoryEditProcess(Request $request, $id)
    {
        $library_category = $this->library_category->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'name' => 'required',
                'db_name' => 'required',
                'cat_id' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$verify_library_category =  $this->library_category->setData()
                            ->where('school_id', $school_id)
                            ->where('name', $request->name)
                            ->where('name', '!=', $request->db_name)
                            ->first();

            if($verify_library_category['id']){
	            flash('Category name ('.$request->name.') already exist. You must specify a unique name')->error();
	            return redirect()->route('admin.library.edit.category', ['id' => $request->cat_id]);            	
            }
            else{
	    		$library_category_data = $library_category->find($id);
	    		$library_category_data->name = $request->name;
	    		$data_update	=	$library_category_data->save();

	            if($data_update){
	                flash('Library Category has been successfully updated.')->success();
	            return redirect()->route('admin.library.edit.category', ['id' => $request->cat_id]);            	
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	            return redirect()->route('admin.library.edit.category', ['id' => $request->cat_id]);            	
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function libraryCategoryDelete(Request $request, $id)
    {
        $library_category = $this->library_category->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();

		$verify_category_book =  $this->library->setData()
                            ->where('school_id', $school_id)
                            ->where('cat_id', $id)
                            ->first();

        if($verify_category_book['id']){
            flash('Request aborted! Selected Category has at least one book anchored to it')->error();
            return redirect()->route('admin.library.all.category');            	
        }
        else{
    		$library_category_data = $library_category->find($id);
    		$category_name = $library_category_data->name;
    		$data_delete	=	$library_category_data->delete();

            if($data_delete){
                flash('Library Category ('.$category_name.') has been deleted successfully.')->success();
            	return redirect()->route('admin.library.all.category');            	         	
            }
            else{
                flash('Something went wrong while processing request. Pls try again shortly!')->error();
            	return redirect()->route('admin.library.all.category');            	
            }

    	}

    }//End Method



//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  END: LibraryCategory  ///////////////////////////////
////////////////////////////////////////////////////////////////////////////////////// 



//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////  START: Library  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

	
	public function libraryBookAdd(){

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $categories = $this->library_category->setData()
                            ->where('school_id', $school_id)
                            ->orderBy('name', 'asc')
                            ->get();
		
        return view('admin.library.book-add', compact('categories'));
				
	}// End function


    public function libraryBookAddProcess(Request $request)
    {
        $library = $this->library->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'cat_id' => 'required',
                'title' => 'required',
                'author' => 'required',
                'publisher' => 'required',
                'subject' => 'required',
                'copies' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$verify_book =  $this->library->setData()
                            ->where('school_id', $school_id)
                            ->where('cat_id', $request->cat_id)
                            ->where('title', $request->title)
                            ->first();

            if($verify_book['id']){
	            flash('Book ('.$verify_book['title'].') already exist in the chosen Category. You must specify a unique title')->error();
	            return redirect()->route('admin.library.add.book');            	
            }
            elseif($request->copies < 1){
	            flash('Available Copies in must be specified')->error();
	            return redirect()->route('admin.library.add.book');            	
            }
            else{

	            $dbData = [
	                'school_id' => $school_id,
	                'cat_id' => $request->cat_id,
	                'title' => $request->title,
	                'sub_title' => $request->sub_title,
	                'author' => $request->author,
	                'publisher' => $request->publisher,
	                'subject' => $request->subject,
	                'descrip' => $request->descrip,
	                'location' => $request->location,
	                'isbn' => $request->isbn,
	                'serial_no' => $request->serial_no,
	                'copies' => $request->copies,
	                'available' => $request->copies,
	                'posted_by' => $admin_id,
	                'created_at' => Carbon::now(),
	                'updated_at' => Carbon::now()
	            ];  

	            $book_id = $library->create($dbData)->id;

	            if($book_id){
	                flash('Library Book has been added successfully.')->success();
	                return redirect()->route('admin.library.add.book');
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.add.book');
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

	}// End function


    public function libraryBookAll()
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

       	$books = DB::table('library')
	                ->select('library.*', 'library_category.name')
	                ->where('library.school_id', $school_id)
	                ->join('library_category', 'library_category.id', '=', 'library.cat_id')
	                ->get(); 

        return view('admin.library.book-all', compact('books'));
    }//End Method


    public function libraryBookEdit($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

       	$book = DB::table('library')
	                ->select('library.*', 'library_category.name')
	                ->where('library.school_id', $school_id)
                    ->where('library.id', $id)
	                ->join('library_category', 'library_category.id', '=', 'library.cat_id')
	                ->first(); 

        return view('admin.library.book-edit', compact('book'));
    }//End Method


    public function libraryBookDetails($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

       	$book = DB::table('library')
	                ->select('library.*', 'library_category.name')
	                ->where('library.school_id', $school_id)
                    ->where('library.id', $id)
	                ->join('library_category', 'library_category.id', '=', 'library.cat_id')
	                ->first(); 

        return view('admin.library.book-details', compact('book'));
    }//End Method


    public function libraryBookCopyEdit($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

       	$book = DB::table('library')
	                ->select('library.*', 'library_category.name')
	                ->where('library.school_id', $school_id)
                    ->where('library.id', $id)
	                ->join('library_category', 'library_category.id', '=', 'library.cat_id')
	                ->first(); 

        return view('admin.library.book-copy-edit', compact('book'));
    }//End Method

    
    public function libraryBookCopyEditProcess(Request $request)
    {
        $library = $this->library->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'edit_action' => 'required',
                'copy_count' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$verify_book =  $this->library->find($request->book_id);

            if(empty($verify_book->id)){
	            flash('Request aborted! Requested Book information failed authentication')->error();
	            return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]);            	
            }
            elseif(empty($request->edit_action)){
	            flash('Your Desired Inventory Action must be chosen')->error();
	            return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]);            	
            }
            else{
            	if($request->edit_action == 1){
        			$copy_update	=	$verify_book->available + $request->copy_count;
        			$edit_action	=	'added to';	
            	}
            	else{
            		$copy_update	=	$verify_book->available - $request->copy_count;
            		$edit_action	=	'deducted from';	
            	} 

	    		$library_data = $library->find($verify_book->id);
	    		$library_data->copies = $copy_update;
	    		$library_data->available = $copy_update;
	    		$data_update	=	$library_data->save();

	            if($data_update){
	                flash($request->copy_count.' copies has been successfully '.$edit_action.' the Book Inventory.')->success();
	                return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]); 
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]); 
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////  END: Library  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   




//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  START: LibraryIssue  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

    public function libraryBookIssue()
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();

        $categories = $this->library_category->setData()
                                ->where('school_id', $school_id)
                                ->get();

        return view('admin.library.book-issue', compact('school_id', 'classes', 'categories'));
    }//End Method

    
    public function libraryBookIssueProcess(Request $request)
    {
        $library = $this->library->setData();
        $library_issue = $this->library_issue->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'student_id' => 'required',
                'issue_date' => 'required',
                'due_date' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$curr_date = date("Y-m-d", strtotime(Carbon::now()));
        	
        	$verify_book =  $this->library->find($request->book_id);
        	$verify_student = $this->students->find($request->student_id);

        	$verify_book_issued = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '!=', 2)
                                ->first();

            if($curr_date < $request->issue_date){
	            flash('Request aborted! Issue date ('.$request->issue_date.') cannot be a future date')->error();
	            return redirect()->route('admin.library.issue.book');            	       	
            }
            elseif($request->due_date < $request->issue_date){
	            flash('Request aborted! Issued date ('.$request->issue_date.') must not be ahead of Due Date ('.$request->due_date.') on the calendar')->error();
	            return redirect()->route('admin.library.issue.book');            	       	
            }
            elseif(empty($verify_book->id)){
	            flash('Request aborted! Submitted Book information failed authentication')->error();
	            return redirect()->route('admin.library.issue.book');            	
            }
            elseif(empty($verify_student->id)){
	            flash('Request aborted! Submitted Student information failed authentication')->error();
	            return redirect()->route('admin.library.issue.book');            	         	
            }
            elseif(!empty($verify_book_issued['id'])){
	            flash('Request aborted! A copy of this book had been issued to '.$verify_student->surname.' '.$verify_student->firstname.' and yet to be returned')->error();
	            return redirect()->route('admin.library.issue.book');            	           	
            }
            elseif($verify_book->available < 1){
	            flash('Request aborted! Book cannot be issued out. '.$verify_book->available.' copy of book left in the library')->error();
	            return redirect()->route('admin.library.issue.book');            	       	
            }
            else{
            	DB::beginTransaction();

            	$new_available	=	$verify_book->available - 1;

	            $dbData = [
	                'school_id' => $school_id,
	                'book_id' => $request->book_id,
	                'issued_to' => $request->student_id,
	                'issue_date' => $request->issue_date,
	                'due_date' => $request->due_date,
	                'issued_by' => $admin_id,
	                'created_at' => Carbon::now(),
	                'updated_at' => Carbon::now()
	            ];  

	            $book_issue_id = $library_issue->create($dbData)->id;

	    		$library_data = $library->find($verify_book->id);
	    		$library_data->available = $new_available;
	    		$data_update	=	$library_data->save();

	            if($book_issue_id && $data_update){
	            	DB::commit();
	                flash('Selected Book ('.$verify_book->title.') has been successfully Issued out to '.$verify_student->surname.' '.$verify_student->firstname.'')->success();
	                return redirect()->route('admin.library.issue.book');
	            }
	            else{
	            	DB::rollBack();
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.issue.book');
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function libraryBookReturn()
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();

        $categories = $this->library_category->setData()
                                ->where('school_id', $school_id)
                                ->get();

        return view('admin.library.book-return', compact('school_id', 'classes', 'categories'));
    }//End Method



    
    public function libraryBookReturnProcess(Request $request)
    {
        $library = $this->library->setData();
        $library_issue = $this->library_issue->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'student_id' => 'required',
                'return_date' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

        	$curr_date = date("Y-m-d", strtotime(Carbon::now()));
        	
        	$verify_book =  $this->library->find($request->book_id);
        	$verify_student = $this->students->find($request->student_id);

        	$verify_issued_exist = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->first();

        	$verify_book_issued = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '!=', 2)
                                ->first();

        	$verify_book_returned = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '=', 2)
                                ->first();

            if($curr_date < $request->return_date){
	            flash('Request aborted! Return date ('.$request->return_date.') cannot be a future date')->error();
	            return redirect()->route('admin.library.return.book');            	       	
            }
            elseif(empty($verify_book->id)){
	            flash('Request aborted! Submitted Book information failed authentication')->error();
	            return redirect()->route('admin.library.return.book');            	
            }
            elseif(empty($verify_student->id)){
	            flash('Request aborted! Submitted Student information failed authentication')->error();
	            return redirect()->route('admin.library.return.book');            	         	
            }
            elseif(empty($verify_issued_exist['id'])){
	            flash('Request aborted! Selected book has never been issued to '.$verify_student->surname.' '.$verify_student->firstname.'')->error();
	            return redirect()->route('admin.library.return.book');            	           	
            }
            elseif(empty($verify_book_issued['id'])){
	            flash('Request aborted! '.$verify_student->surname.' '.$verify_student->firstname.' has returned every copy of this book issued out')->error();
	            return redirect()->route('admin.library.return.book');            	           	
            }
            elseif(!empty($verify_book_returned['id'])){
	            flash('Request aborted! '.$verify_student->surname.' '.$verify_student->firstname.' has returned all issued copy of this book')->error();
	            return redirect()->route('admin.library.return.book');            	           	
            }
            elseif($request->return_date < $verify_issued_exist['issue_date']){
	            flash('Request aborted! Return date ('.$request->return_date.') cannot be a date behind Issue Date')->error();
	            return redirect()->route('admin.library.return.book');            	       	
            }
            else{
            	DB::beginTransaction();

            	$new_available	=	$verify_book->available + 1;

            	//Book Issuance Update
	    		$library_issue_data = $library_issue->find($verify_issued_exist->id);
	    		$library_issue_data->return_status = 2;
	    		$library_issue_data->return_date = $request->return_date;
	    		$issue_update	=	$library_issue_data->save();

	    		//Book Inventory Update
	    		$library_data = $library->find($verify_book->id);
	    		$library_data->available = $new_available;
	    		$inventory_update	=	$library_data->save();

	            if($issue_update && $inventory_update){
	            	DB::commit();
	                flash('Book ('.$verify_book->title.') issued out to '.$verify_student->surname.' '.$verify_student->firstname.' has been Returned')->success();
	                return redirect()->route('admin.library.return.book');
	            }
	            else{
	            	DB::rollBack();
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.return.book');
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function getStudents(Request $request){

        return DB::table('students')
	        ->select('students.id', 'students.surname', 'students.firstname', 'students.middlename', 'students.regnum')
	        ->where('class_arms.school_id', $request->school_id)
	        ->where('classarm_student.class_id', $request->class_id)
	        ->where('students.session', $request->session)
	        ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
	        ->join('class_arms', 'classarm_student.classarm_id', '=', 'class_arms.id')
	        ->get(); 
                
    }//End Method


    public function getCategoryBooks(Request $request){

    	return $this->library->setData()
	                ->where('library.school_id', $request->school_id)
	                ->where('library.cat_id', $request->cat_id)
                    ->get();
                
    }//End Method

//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  END: LibraryIssue  ///////////////////////////////
////////////////////////////////////////////////////////////////////////////////////// 

}
