<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;

use App\Student;

use App\Admin;

use App\SuperAdmin;

use Auth;

class ElearningController extends Controller
{
    public function index()
    {
        $title = 'Connect Elearning Portal';

        if(auth('student')->id()){
            $student = Student::find(auth('student')->id());
            return view('student.elearning_connect', compact('title', 'student'));
        }
        elseif(auth('admin')->id()){
            $admin = Admin::find(auth('admin')->id());
            return view('admin.elearning_connect', compact('title', 'admin'));
        }
        elseif(auth('super_admin')->id()){
            $superadmin = SuperAdmin::find(auth('super_admin')->id());
            return view('super-admin.elearning_connect', compact('title', 'superadmin'));
        }
        else{
            return view('welcome');
        }

    }



/* 
    public function elearning_connect_process($id, Request $request){
        
        $validate = Validator::make($request->all(), [
                'password' => 'required',
                'username' => 'required'
            ]);

        if($validate->passes()){
            $url = "http://odsgelearning.com.ng/login/index.php";

            $content = 'username=' . $request->username . '&password=' . $request->password;           

            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_HTTPHEADER,   array( "Content-type: application/x-www-form-urlencoded\r\n"));
            //curl_setopt($curl, CURLOPT_HTTPHEADER,   array("Content-type: text/plain"));
            //curl_setopt($curl, CURLOPT_HTTPHEADER,   array("Content-type: application/json"));
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
            $curl_response = curl_exec($curl); 
            curl_getinfo($curl, CURLINFO_HTTP_CODE);

            $redirectURL = curl_getinfo($curl,CURLINFO_EFFECTIVE_URL ); 

            //return redirect($redirectURL);
            //return Redirect::to($url);

            //header( 'Location: ' . $redirectURL );   //Redirecting to Elearning
            curl_close($curl);                       //Closes open curl.


//$json_data = json_decode($curl_response);
//var_dump($json_data);

            //flash('Connect successful...')->success();
            //return redirect()->route('student.elearning.connect', ['id' => $id]);
        }
        else{
            flash('Connect failed')->error();
            return redirect()->route('student.elearning.connect', ['id' => $id]);
        }
    }
*/


}//end class
