<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Repositories\NgStatesRepositoryInterface;
use App\EntranceExam;
use App\PrimarySchool;
use App\EntranceHallAllocation;
use App\ExamsVouchers;
use App\Agent;
use Validator;
use Auth;
use Session;
use Hash;
use Input;

class EntranceExamAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = 'exams/entrance/view-student';

     protected $redirectAfterLogout = 'exams/entrance/login-with-exam-number';

     protected $ngstates;

     public function __construct(NgStatesRepositoryInterface $ngstate){
        $this->ngstates = $ngstate;
     	$this->middleware('guest:entrance', ['except' => ['logout']]);
     }

     private function getRegNum(){
        $regnum = '16'.rand(11111111, 99999999);

        $count = EntranceExam::where('regnum', '=', $regnum)
                            ->count();

        if($count > 0){
            return $this->getRegNum();
        }else{
            return $regnum;
        }
    } 

     public function createStudent(){

        $title = 'Generate Candidate Registration Number';

        $ngstate = $this->ngstates->find(28);

        return view('exams.entrance.generate-exam-number', compact('title', 'ngstate'));
     }

     public function storeStudent(Request $request){

        $validate =  Validator::make($request->all(), [
            'state_id' => 'required|integer',
            'lga_id' => 'required|integer',
            'school' => 'required|integer',
            'exam_type' => 'in:entrance',
            'serial_no' => 'required',
            'pin' => 'required|card_validation',
            'auth_code' => 'required|agent_validation'
        ]);

        if($validate->passes()){

            $exam_voucher = ExamsVouchers::where('serial', '=',  $request->input('serial_no'))
                                        ->where('pin', '=',  $request->input('pin'))
                                        ->first();

            $agent = Agent::where('access', $request->input('auth_code'))->first();

            $entrance = PrimarySchool::find($request->input('school'));

            if($exam_voucher->school_id == NULL){

                $exam_voucher->school_id = $request->input('school');

                $exam_voucher->save();
            }else{

                if($entrance->password != NULL){

                    flash('The card has been used, you can either login with the card or use your Exam Number and Password')->info();

                    return redirect()->route('exam.entrance.login.card');
                }

            }

            flash(' Create School Email and Password to Continue Registration')->success();

            return redirect()->route('exam.entrance.generate-candidate-password')
                                ->with('auth_code', $request->input('auth_code'))
                                ->with('school' , $request->school);

        }


        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

     }


     public function createCandidatePassword(){

            $title = 'Generate Candidate Registration Number';
            if(!Session::has('school')){
                return redirect()->route('exam.entrance.generate-exam-number');
            }

            $school = PrimarySchool::find(Session::get('school'));

            $auth_code = Session::get('auth_code');

            return view('exams.entrance.generate-candidate-password', compact('title', 'school', 'auth_code'));

     }


     public function storeCandidatePassword(Request $request){

        $validate =  Validator::make($request->all(), [
            'auth_code' => 'required|agent_validation',
            'school' => 'required|integer',
            'email' =>  'email|unique:primary_schools,email',
            'password' => 'required|alpha_num|min:6|confirmed',
            'password_confirmation' => 'required'
        ]);

        if($validate->passes()){

            $entrance = PrimarySchool::find($request->school);

            $entrance->password = Hash::make($request->input('password'));

            $entrance->email = $request->input('email');

            $entrance->save();

            if(Auth::guard('entrance')->attempt(['id' => $request->input('school'), 'password' => $request->input('password')])) {

                flash('You can continue the Entrance Examination Registration')->success();

                return redirect()->route('exam.entrance.view-student');
            }

        }

        flash('Something is wrong')->error();

        $request->session()->flash('school', $request->input('school'));
        $request->session()->flash('auth_code', $request->input('auth_code'));

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();


     }

    protected function validateLogin(Request $request){

        $this->validate($request, Admin::$rulesLogin);
    }

    public function login(){

        $title = 'Login Page';

        $ngstate = $this->ngstates->find(28);

        return view( 'exams.entrance.login',compact('title', 'ngstate'));

    }


     public function loginPost(Request $request){
        $rules = array('login_type' => ['required', 'regex:(card|email)']);

        $validate_one = Validator::make($request->all(), $rules);

        if($validate_one->passes()){

            if($request->input('login_type') == 'card'){

                $rules['regnum'] = 'required|integer';
                $rules['exam_type'] = 'required|in:entrance';
                $rules['serial_no'] = 'required';
                $rules['pin'] = 'required|card_validation|school_verify:exams_vouchers,'.$request->input('school');

                
                $validate_two = Validator::make($request->all(), $rules);

                if($validate_two->passes()){
                    
                    $candidate =  EntranceExam::find($request->school);

                   auth('entrance')->login($candidate);

                   return redirect()->intended('exams/entrance/view-student');

                }

                flash('Somthing is wrong')->error();

                return redirect()->back()
                                ->withErrors($validate_two)
                                ->withInput();
            }else{

                $rules['email'] = 'required';
                $rules['password'] = 'required';

                $credentials = array(
                        'email' => $request->input('email'),
                        'password' => $request->input('password')
                    );

                $this->validate($request, $rules);

             	$throttles = $this->isUsingThrottlesLoginsTrait();

                if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
                    $this->fireLockoutEvent($request);

                    return $this->sendLockoutResponse($request);
                }

                if (Auth::guard('entrance')->attempt($credentials)) {

                    flash('You have successfully login')->success();
                    return $this->handleUserWasAuthenticated($request, $throttles);
                }

                // If the login attempt was unsuccessful we will increment the number of attempts
                // to login and redirect the user back to the login form. Of course, when this
                // user surpasses their maximum number of attempts they will get locked out.
                if ($throttles && ! $lockedOut) {
                    $this->incrementLoginAttempts($request);
                }
                flash('Something is wrong')->error();

                return $this->sendFailedLoginResponse($request)->withInput();
            }

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate_one)
                        ->withInput();


    }

     public function logout()
    {
        Auth::guard('entrance')->logout();

        return redirect()->route('exam.entrance.login.exam.number');
    }

}
