<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Admin;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Repositories\NgStatesRepositoryInterface;
use Validator;
use Auth;
use Session;

class AdminAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = 'admin/dashboard';

     protected $redirectAfterLogout = 'admin/login';

     protected $ngstates;

     public function __construct(NgStatesRepositoryInterface $ngstate){
        $this->ngstates = $ngstate;
     	$this->middleware('guest:admin', ['except' => ['logout']]);
     }


     public function showLoginForm(){

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

     	return view('auth.admin-login', compact('ngstate', 'ngstate_lgas'));
     }

      protected function validateLogin(Request $request)
        {
            $this->validate($request, Admin::$rulesLogin);
        }


     public function login(Request $request){

     	$this->validateLogin($request);

     	$throttles = $this->isUsingThrottlesLoginsTrait();

        if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }
        
        if (Auth::guard('admin')->attempt(['username' => $request->input('username'), 'password' => $request->input('password')])) {
            Session::put('admin.school', auth('admin')->user()->school_id);
            flash('You have successfully login')->success();
            return $this->handleUserWasAuthenticated($request, $throttles);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        if ($throttles && ! $lockedOut) {
            $this->incrementLoginAttempts($request);
        }
        flash('Something is wrong')->error();

        return $this->sendFailedLoginResponse($request)->withInput();

     }

     public function logout()
    {
        Auth::guard('admin')->logout();

        Session::forget('admin.school');

        return redirect()->route('admin.login');
    }

}
