<?php

namespace App\Http\Controllers;

use DB;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\TrafficAnalytic;


class AnalyticController extends Controller
{
    // monthly
    public function getActiveUsersMonths(){
        $month_array = array();
        $user_dates = TrafficAnalytic::orderBy('last_seen', 'DESC')->pluck('last_seen');
        $user_dates = json_decode($user_dates);
        
        if(!empty($user_dates)){
            foreach($user_dates as $raw_date){
                $date = new \DateTime($raw_date);
                $month_no = $date->format('m');
                $month_name = $date->format('M');
                
                $month_array[$month_no] = $month_name;
            }
        }
        
        return $month_array;
    }
    
    public function getMonthlyUsersCount($month){
        $monthly_users = TrafficAnalytic::whereMonth('last_seen', '=', $month)->get()->count();
        return $monthly_users;
    }
    
    public function getMonthlyUsersData($month = 01){
        $monthly_post_count_array = array();
        $month_array = $this->getActiveUsersMonths();
        $month_name_array = array();
        if(!empty($month_array)){
            foreach($month_array as $month_no => $month_name){
                $monthly_post_count = $this->getMonthlyUsersCount($month_no);
                array_push($monthly_post_count_array, $monthly_post_count);
                array_push($month_name_array, $month_name);
            }
        }
        
        $max_no = max($monthly_post_count_array);
        $max = round(($max_no + 10/2) / 10) * 10;
        $monthly_post_data_array = array(
            'months' => $month_name_array,
            'user_count_data' => $monthly_post_count_array,
            'max' => $max
        );
        
        return $monthly_post_data_array;
    }


    
    // weekly
    public function getActiveUsersWeeks(){
        $week_array = array();
        $user_dates = TrafficAnalytic::orderBy('last_seen', 'DESC')->pluck('last_seen');
        $user_dates = json_decode($user_dates);
        
        if(!empty($user_dates)){
            foreach($user_dates as $raw_date){
                $date = new \DateTime($raw_date);
                $week_no = $date->format('w');
                $week_name = $date->format('W');
                
                $week_array[$week_no] = $week_name;
            }
        }
        
        return $week_array;
    }
    
    public function getWeeklyUsersCount($week){
        $a_week_ago = date('Y-m-d', strtotime('-8 days', strtotime(date('Y-m-d'))));
        $weekly_users = TrafficAnalytic::whereBetween(DB::raw('date(last_seen)'), [$a_week_ago, date('Y-m-d')] )->get()->count();
        return $weekly_users;
    }
    
    public function getWeeklyUsersData($week = 01){
        $weekly_post_count_array = array();
        $week_array = $this->getActiveUsersWeeks();
        $week_name_array = array();
        if(!empty($week_array)){
            foreach($week_array as $week_no => $week_name){
                $weekly_post_count = $this->getWeeklyUsersCount($week_no);
                array_push($weekly_post_count_array, $weekly_post_count);
                array_push($week_name_array, $week_name);
            }
        }
        
        $max_no = max($weekly_post_count_array);
        $max = round(($max_no + 10/2) / 10) * 10;
        $weekly_post_data_array = array(
            'months' => $week_name_array,
            'user_count_data' => $weekly_post_count_array,
            'max' => $max
        );
        
        return $weekly_post_data_array;
    }

    
    // daily
    public function getActiveUsersDays(){
        $day_array = array();
        $user_dates = TrafficAnalytic::orderBy('last_seen', 'DESC')->pluck('last_seen');
        $user_dates = json_decode($user_dates);
        
        if(!empty($user_dates)){
            foreach($user_dates as $raw_date){
                $date = new \DateTime($raw_date);
                $day_no = $date->format('d');
                $day_name = $date->format('D');
                
                $day_array[$day_no] = $day_name;
            }
        }
        
        return $day_array;
    }
    
    public function getDailyUsersCount($day){
        $daily_users = TrafficAnalytic::whereDay('last_seen', '=', $day)->get()->count();
        return $daily_users;
    }
    
    public function getDailyUsersData($day = 01){
        $daily_post_count_array = array();
        $day_array = $this->getActiveUsersDays();
        $day_name_array = array();
        if(!empty($day_array)){
            foreach($day_array as $day_no => $day_name){
                $daily_post_count = $this->getDailyUsersCount($day_no);
                array_push($daily_post_count_array, $daily_post_count);
                array_push($day_name_array, $day_name);
            }
        }
        
        $max_no = max($daily_post_count_array);
        $max = round(($max_no + 10/2) / 10) * 10;
        $daily_post_data_array = array(
            'months' => $day_name_array,
            'user_count_data' => $daily_post_count_array,
            'max' => $max
        );
        
        return $daily_post_data_array;
    }

}
