<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    protected $table = "activity_logs";

    protected $fillable = ['super_admin_id', 'school_id', 'admin_id', 'teacher_id', 'student_id', 'message', 'path', 'type', 'ip', 'device'];

    
    public function superAdmin(){
        return $this->belongsTo('App\SuperAdmin', 'super_admin_id');
    }
    
    public function school(){
        return $this->belongsTo('App\School', 'school_id');
    }
    
    public function admin(){
        return $this->belongsTo('App\Admin', 'admin_id');
    }

    public function teacher(){
        return $this->belongsTo('App\Teacher', 'teacher_id');
    }

    public function student(){
        return $this->belongsTo('App\Student', 'student_id');
    }

}