<?php $__env->startSection('content-teacher'); ?>

<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th class="ui huge centered header"> <?php echo e(getClassNameByClassID($class_id).' '.getClassArmNameByClassArmID($classarm_id_get)); ?> &nbsp;&nbsp; <?php echo e($session.'/'.($session + 1)); ?>  <?php echo e($term); ?> Term Results</th>
        </tr>
      </thead>
      <tbody>
      <?php  $counter = 0  ?>
       <?php foreach($students_results_info as $key => $student_results): ?>
        <tr>
          <td>
            <table class="ui unstackable celled table">
              <thead>
                <tr>
                    <th><?php echo e(++$counter); ?></th>
                    <th colspan="<?php echo e(ceil((count($student_results['data']) - 1) / 2)); ?>"><?php echo e(getStudentFullnameByStudentID($key)); ?></th>
                    <th colspan="<?php echo e(floor((count($student_results['data']) - 1) / 2)); ?>"><?php echo e(getRegNumByStudentID($key)); ?></th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              <?php if(count($student_results['data']) > 0): ?>           
                  <?php foreach($student_results['data'] as  $student_result): ?>
                    <td>
                       <table class="inner-table">
                         <tr style="padding:0"><td style="padding:0"><?php echo e(getSubjectCodeBySubjectID($student_result->subject_id)); ?></td></tr>
                         <tr><td><?php echo e($student_result->weighted_average); ?></td></tr>
                         <tr><td>
                         <?php if($class_name_char == "J"): ?>
                              <?php echo e(resultGradeJS($student_result->weighted_average)); ?>

                         <?php else: ?>
                              <?php echo e(resultGradeSS($student_result->weighted_average)); ?>

                         <?php endif; ?>
                         </td></tr>
                       </table>
                    </td>
                  <?php endforeach; ?>

                <?php else: ?>
                    <td colspan="3">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                <?php endif; ?>
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        <?php endforeach; ?>

      </tbody>
      
    </table>
</div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('teacher.layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>