<!DOCTYPE html>
<html>
<head>
	<title><?php echo e(isset($title) ? $title.' : ' : ''); ?> Ondo Secondary School App</title>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="csrf_token" content="<?php echo e(csrf_token()); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(url_public(elixir('css/all.css'))); ?>">
	<link rel="shortcut icon" href="<?php echo e(url_public('/favicon.ico')); ?>" type="image/x-icon">
	<link rel="icon" href="<?php echo e(url_public('/favicon.ico')); ?>" type="image/x-icon">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script> 
	
    <link href="<?php echo e(url_public('/dataTables/dataTables.bootstrap.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(url_public('/dataTables/pagination.css')); ?>" rel="stylesheet" />
    

</head>
<body>
 <div class="ui inverted orange vertical floating menu sidebar">
 	<?php echo $__env->make('layouts.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
 </div>
 <div class="pusher">
	<div class="ui right aligned container printnone" id="header-top" style="margin-left: 0px !important; margin-right: 0px !important; padding: 10px">
	  <p style="max-width:1127px;color:#ffffff;">Welcome to Ondo State Ministry of Education, Science and Technology Website : The Motto ..... </p>
	</div>
	<nav id="header-nav" class="ui stacked segment printnone" style="margin-top: -10px;"  style="position : relative">
		<div id="mobile-icon" style="position: absolute;top:20px; right:20px; cursor: pointer;z-index: 500;">
            <i class="tasks icon" id="" style="color:#ed5408; font-size:2em;"></i>
        </div>
		<div class="ui two column stackable grid container">
			<div class="column">
				<h2 class="ui image header">
			      <img src="<?php echo e(url_public('/images/header-logo.png')); ?>" class="ui huge image" style="width:140px">
			      <div class="content" style="color: #f2711c">
			       Ondo State Ministry of Education,<br> Science and Technology
			      </div>
			    </h2>
			</div>
			<div class="column" id="mobile-menu-view">
				<div class="ui stackable secondary pointing menu right" style="border-bottom:0px">
				  <a class="item active" href="/">
				    Home
				  </a>
				  <a class="item" href="http://odsgmoe.com/about.php">
				     About Us
				  </a>
				  <a class="item" href="http://odsgmoe.com/department.php">
				    Department
				  </a>
				  <a class="item" href="http://odsgmoe.com/gallery.php">
				   Gallery
				  </a>
				  <!-- <a class="item">
				   Contact Us
				  </a> -->
				  <div class="right menu">
				  	<?php if(Request::is('admin/*')): ?>
				  		<?php if(Auth::guard('admin')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('admin.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('admin.login')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
				    <?php elseif(Request::is('teacher/*')): ?>
						<?php if(Auth::guard('teacher')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('teacher.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('teacher.login')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
				    <?php elseif(Request::is('ministry/*')): ?>
						<?php if(Auth::guard('super_admin')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('super_admin.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('super_admin.login')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
					<?php elseif(Request::is('exams/unity/*')): ?>
						<?php if(Auth::guard('unity_exam')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('unity_exam.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('exam.unity.login.exam.number')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
					<?php elseif(Request::is('exams/entrance/*')): ?>
						<?php if(Auth::guard('entrance')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('entrance.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('exam.entrance.login.exam.number')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
				    <?php else: ?>
				   		<?php if(Auth::guard('student')->check()): ?>
						    <a class="ui item" href="<?php echo e(route('student.logout')); ?>">
						      Logout
						    </a>
					    <?php else: ?>
					    	<a class="ui item" href="<?php echo e(route('student.login')); ?>">
						      Login
						    </a>
					    <?php endif; ?>
				    <?php endif; ?>
				  </div>
				</div>
			</div>
		</div>
	</nav>


	<?php echo $__env->yieldContent('banner'); ?>
	<?php if(!Request::is('exams/*')): ?>
		<?php echo $__env->make('layouts.sub-menu', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<?php endif; ?>
	<?php if(Session::has('flash_notification')): ?>
        <div style="position:absolute; margin-top: 10px; left: 20%; right: 20%; z-index:9999999;" class="notification-wrapper">
            <?php echo $__env->make('flash::message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        </div>
    <?php endif; ?>
	<?php echo $__env->yieldContent('content'); ?>
	<footer id="footer" class="ui tall stacked segment printnone">
		<div class="ui three column stackable grid container">
		  <div class="column">
		  	<h2 class="ui center aligned icon white header">
			  <i class="help icon"></i>
			  For Support
			</h2>
			<div class="ui divided items">
				<p class="item"><i class="call icon"></i> +2348053081549</p>
				<p class="item"><i class="mail icon"></i> info@odsgmoe.com</p>
				<p class="item"><i class="address book icon"></i> Ondo State Ministry of Education</p>
			</div>
		  </div>
		  <div class="column">
		  	<h2 class="ui center aligned icon white header">
			  <i class="users icon"></i>
			  Users Login
			</h2>
			<div class="ui divided linked items">
				<a class="item" href="<?php echo e(url(route('super_admin.login'))); ?>"><i class="user icon"></i> Ministry Admin Login </a>
				<a class="item" href="<?php echo e(url(route('admin.login'))); ?>"><i class="user icon"></i>School Adminstrator Login</a>
				<a class="item" href="<?php echo e(url(route('teacher.login'))); ?>"><i class="user icon"></i> Teacher Login</a>
				<a class="item" href="<?php echo e(url(route('student.login'))); ?>"><i class="student icon"></i> Students Login</a>
			</div>
		  </div>
		  <div class="column" is="third-column" style="margin-top:140px;">
		  	<div class="ui divided linked items">
				<a class="item" href="#">FAQ </a>
				<a class="item" href="#">Legal Notice</a>
				<a class="item" href="#">Privacy Statement</a>
				<a class="item" href="#">Terms and Condition</a>
			</div>
		  </div>
		</div>
	</footer>
</div>
	<!--[if lt IE 9]>
<script type="text/javascript" src="<?php echo e(url_public(elixir('js/flashcanvas.js'))); ?>"></script>
<![endif]-->
    <script src="<?php echo e(url_public(elixir('js/all.js'))); ?>" charset="utf-8"></script>


     <!-- DATA TABLE SCRIPTS -->
    <script src="<?php echo e(url_public('/dataTables/jquery.dataTables.js')); ?>"></script>
    <script src="<?php echo e(url_public('/dataTables/dataTables.bootstrap.js')); ?>"></script>

        <!-- page script -->
       <!-- <script type="text/javascript">
            $(function() {
                var table = $('#global_datatable').dataTable({
                    "bPaginate": true,
                    "bLengthChange": false,
                    "bFilter": true,
                    "bSort": false,
                    "bInfo": true,
                    "bAutoWidth": false
                });
            });
        </script> -->
        
</body>
</html>