<?php $__env->startSection('content-teacher'); ?>

<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px">
  <div class="sixteen wide column">
  <?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
  </div>

  <div class="eight wide column">
    <div class="ui divided list cart-summary">
      <?php foreach($inputs as $key => $input): ?>
      <div class="item">  
        <div class="content">
          <?php if($key == 'class'): ?>
          <strong class=""><?php echo e(strtoupper($key)); ?> : </strong> 
          <span class="mini meta"><?php echo e(getClassNameByClassID($input)); ?></span> 
          <?php elseif($key == 'class arm'): ?>
          <strong class=""><?php echo e(strtoupper($key)); ?> : </strong> 
          <span class="mini meta"><?php echo e(getClassArmNameByClassArmID($input)); ?></span>
          <?php elseif($key == 'session'): ?> 
          <strong class=""><?php echo e(strtoupper($key)); ?> : </strong> 
          <span class="mini meta"><?php echo e($input); ?>/<?php echo e(($input+1)); ?></span>
          <?php else: ?>
            <?php if($key != 'teacher_id'): ?>
              <strong class=""><?php echo e(strtoupper($key)); ?> : </strong> 
              <span class="mini meta"><?php echo e($input); ?></span> 
            <?php endif; ?>
          <?php endif; ?>
        </div> 
      </div> 
      <?php endforeach; ?>
    </div>
  </div>

  <div class="eight wide column">

    <div class="ui icon info message">
      <i class="file excel outline icon"></i>
      <div class="content">
        <div class="header">
          Download <?php echo e(getClassNameByClassID($inputs['class']).' '.getClassArmNameByClassArmID($inputs['class arm'])); ?> Result Format
        </div>
        <div class="description">
          <form action="<?php echo e(route('teacher.download.class.result.format.by.subject')); ?>" method="post">
            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
            <input type="hidden" name="session" value="<?php echo e($inputs['session']); ?>">
            <input type="hidden" name="class_id" value="<?php echo e($inputs['class']); ?>">
            <input type="hidden" name="classarm_id" value="<?php echo e($inputs['class arm']); ?>">
            <input type="hidden" name="term" value="<?php echo e($inputs['term']); ?>">
            <input type="hidden" name="teacher_id" value="<?php echo e($teacher_id); ?>">
            <button type="submit" class="fluid ui button" style="background-color: #f75a0c; color:white;">Download</button>
          </form>
        </div>
      </div>
    </div>

  </div>

  <br />

  <div class="sixteen wide column">
    <h4 class="ui dividing header">Upload Result By Subject</h4>

    <?php if(!empty($subjects)): ?>
    <div class="ui divided list">
    <?php foreach($subjects as $subject): ?>
    <div class="item"> 
    <form action="<?php echo e(route('teacher.upload.students.result.by.subject')); ?>" method="post" enctype="multipart/form-data" class="ui form">
          <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
          <input type="hidden" name="session" value="<?php echo e($inputs['session']); ?>">
            <input type="hidden" name="class_id" value="<?php echo e($inputs['class']); ?>">
            <input type="hidden" name="classarm_id" value="<?php echo e($inputs['class arm']); ?>">
            <input type="hidden" name="term" value="<?php echo e($inputs['term']); ?>">
          <input type="hidden" name="subject_id" value="<?php echo e($subject->subject_id); ?>">
          <input type="hidden" name="teacher_id" value="<?php echo e($teacher_id); ?>">
          
      <div class="fields">
        <div class="three wide field">
           <label><?php echo e(strtoupper($subject->subject_name)); ?></label>
          </div>

          <div class="eight wide field">
              <div class="ui right action input">
            <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
            <button type="button" class="ui orange labeled icon button pseudo-batch-file">
              <i class="file excel outline icon"></i>
              Choose Excel File
            </button>
          </div>
              <input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
         </div>
        
        <div class="five wide field">
            <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Upload File</button>
          </div>
      </div>
    </form>
    </div>
    <?php endforeach; ?>
        </div>
    <?php else: ?>
      <div class="ui icon negative message">
        <div class="item">
            <div class="content">
              <p class="header">No Subject has been assign to <?php echo e(getClassNameByClassID($inputs['class']).' '.getClassArmNameByClassArmID($inputs['class arm'])); ?></p>
            </div>
        </div>
      </div>
    <?php endif; ?>

  </div>
</section>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('teacher.layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>