<?php $__env->startSection('content'); ?>

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	<form class="ui form" action="<?php echo e(route('super_admin.view.teacher.post')); ?>" method="post" enctype="multipart/form-data">
		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
		<h2 class="ui dividing header">Search Registered Teachers</h2>
		<div class="four fields">
		  <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" <?php if(!empty(old('state_id'))): ?>
                  value="<?php echo e(old('state_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($ngstate->id); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
              </div>
            </div>
          </div>
          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/school')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                <?php foreach($ngstate_lgas as $ngstateLGA): ?>
                 <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="<?php echo e(old('school')); ?>" data-href="<?php echo e(url('/do-ajax/classes')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                <?php if(!empty(old('school'))): ?>
                    <?php foreach(getSchools(old('school')) as $school): ?>
                     <div class="item" data-value="<?php echo e($school->id); ?>"><?php echo e($school->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Schools</div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Teachers</button>
	      </div>
		</div>
		  
	</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Teachers Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Identification Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Passport</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Teacher's Subject Areas</div>
		    </th>
		     <th>
		    	<div class="ui ribbon label">Teacher's School</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Teachers</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($teachers) > 0): ?>
		  <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $teachers->perPage()  ?>
		  	<?php foreach($teachers as $teacher): ?>
		    <tr>
		    <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename); ?></td>
		      <td><?php echo e($teacher->staff_no); ?></td>
		      <td><img src="<?php echo e(env('APP_URL').$teacher->passport); ?>" class="ui image"></td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	<?php $__empty_1 = true; foreach(getAssocSubject($teacher->id) as $t_s): $__empty_1 = false; ?>
		      	<div class="item">
				    <div class="content">
				      <p class="header"><?php echo e($t_s->subject_name); ?></p>
				    </div>
				</div>
				<?php endforeach; if ($__empty_1): ?>
				<div class="item">
				    <div class="content">
				      <p class="header">No Subject Area Yet</p>
				    </div>
				</div>
		      	<?php endif; ?>
		      	</div>
		      </td>
		      <td><?php echo e(getSchoolName($teacher->school_id)); ?></td>
		      <td class="std-view">
		      <?php if(auth('super_admin')->user()->can('edit-teacher')): ?>
			      <button class="ui labeled blue icon button" data-std-id="<?php echo e($teacher->id); ?>" data-href="<?php echo e(route('super_admin.edit.teacher', ['id' => $teacher->id])); ?>">
				  <i class="edit icon" ></i>
				  Edit
				</button>
			<?php endif; ?>
			  </td>
		      <td class="std-view">
		      <?php if(auth('super_admin')->user()->can('delete-teacher')): ?>
				<button class="ui labeled negative icon button" data-std-id="<?php echo e($teacher->id); ?>" data-href="<?php echo e(route('super_admin.delete.teacher', ['id' => $teacher->id])); ?>">
				  <i class="trash icon"></i>
				  Delete
				</button>
				<?php endif; ?>
		      </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="8">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="8">
		      <?php echo $__env->make('pagination.post-default', ['paginator' => $teachers, 'post_data' => $data], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>