<?php $__env->startSection('content-unity-exam'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
    <form class="ui form" action="<?php echo e(route('exam.unity.store')); ?>" method="post">
      <h2 class="ui dividing header">Unity Examination Registration</h2>
      <div class="field">
        <input type="hidden" value="<?php echo e(csrf_token()); ?>" name="_token" value="<?php echo e(old('_token')); ?>">
        <label>Examination Number</label>
        <div class="three fields">
          <div class="field">
            <p><?php echo e(auth('unity_exam')->user()->regnum); ?></p>
          </div>
        </div>
      </div>
      <div class="field">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" <?php if(!empty(old('surname'))): ?> 
            value="<?php echo e(old('surname')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->surname); ?>"
            <?php endif; ?> placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" <?php if(!empty(old('firstname'))): ?> 
            value="<?php echo e(old('firstname')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->firstname); ?>"
            <?php endif; ?> placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" <?php if(!empty(old('middlename'))): ?> 
            value="<?php echo e(old('middlename')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->middlename); ?>"
            <?php endif; ?> placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob" <?php if(!empty(old('dob'))): ?> 
            value="<?php echo e(old('dob')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->dob); ?>"
            <?php endif; ?>>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender" <?php if(!empty(old('gender'))): ?> 
            value="<?php echo e(old('gender')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->gender); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country" <?php if(!empty(old('country'))): ?> 
            value="<?php echo e(old('country')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->country); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" <?php if(!empty(old('blood_group'))): ?> 
            value="<?php echo e(old('blood_group')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->blood_group); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="ten wide field">
          <label>Contact Address</label>
            <input type="text" name="address" <?php if(!empty(old('address'))): ?> 
            value="<?php echo e(old('address')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->address); ?>"
            <?php endif; ?> placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" <?php if(!empty(old('state_id'))): ?> 
            value="<?php echo e(old('state_id')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->state_id); ?>"
            <?php endif; ?> data-href="<?php echo e(url('/do-ajax/state')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                <?php foreach($ngstates as $ngstate): ?>
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" <?php if(!empty(old('lga_id'))): ?> 
            value="<?php echo e(old('lga_id')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->lga_id); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  <?php if(!empty(old('state_id'))): ?>
                    <?php foreach(getStateLGAs(old('state_id')) as $ngstateLGA): ?>
                     <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>
                  <?php elseif(!empty(auth('unity_exam')->user()->state_id)): ?>
                    <?php foreach(getStateLGAs(auth('unity_exam')->user()->state_id) as $ngstateLGA): ?>
                     <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                    <?php endforeach; ?>  
                  <?php else: ?>
                     <div class="item" data-value="">Select State LGA</div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion" <?php if(!empty(old('religion'))): ?> 
            value="<?php echo e(old('religion')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->religion); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone" <?php if(!empty(old('phone'))): ?> 
            value="<?php echo e(old('phone')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->phone); ?>"
            <?php endif; ?> placeholder="Student's Phone Number">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname" <?php if(!empty(old('parent_fullname'))): ?> 
            value="<?php echo e(old('parent_fullname')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->parent_fullname); ?>"
            <?php endif; ?> placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address" <?php if(!empty(old('parent_address'))): ?> 
            value="<?php echo e(old('parent_address')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->parent_address); ?>"
            <?php endif; ?> placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email" <?php if(!empty(old('parent_email'))): ?> 
            value="<?php echo e(old('parent_email')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->parent_email); ?>"
            <?php endif; ?> placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone" <?php if(!empty(old('parent_phone'))): ?> 
            value="<?php echo e(old('parent_phone')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->parent_phone); ?>"
            <?php endif; ?> placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Examinational Area Location Information</h4>
        <div class="two fields">
          <div class="field">
            <label>Examination Center Local Goverment</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="exam_area"  <?php if(!empty(old('exam_area'))): ?> 
            value="<?php echo e(old('exam_area')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->hall_allocation->exam_center_lga_id); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">Examination Center Local Goverment</div>
              <div class="menu">
                <?php $__empty_1 = true; foreach($ondo_lgas as $ondo_lga): $__empty_1 = false; ?>
                 <div class="item" data-value="<?php echo e($ondo_lga->id); ?>"><?php echo e($ondo_lga->name); ?></div>
                <?php endforeach; if ($__empty_1): ?>
                <?php endif; ?>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">School Choices Information</h4>
        <div class="two fields">
          <div class="field">
            <label>First Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="first_choice"  <?php if(!empty(old('first_choice'))): ?> 
            value="<?php echo e(old('first_choice')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->first_choice); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text uppercase">First Choice</div>
              <div class="menu">
                <?php $__empty_1 = true; foreach($unity_schools as $unity_school): $__empty_1 = false; ?>
                 <div class="item uppercase" data-value="<?php echo e($unity_school->id); ?>" ><?php echo e($unity_school->name); ?></div>
                <?php endforeach; if ($__empty_1): ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Second Choice</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="second_choice" <?php if(!empty(old('second_choice'))): ?> 
            value="<?php echo e(old('second_choice')); ?>"
            <?php else: ?>
            value="<?php echo e(auth('unity_exam')->user()->second_choice); ?>"
            <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text uppercase">Second Choice</div>
              <div class="menu">
                <?php $__empty_1 = true; foreach($unity_schools as $unity_school): $__empty_1 = false; ?>
                 <div class="item uppercase" data-value="<?php echo e($unity_school->id); ?>" ><?php echo e($unity_school->name); ?></div>
                <?php endforeach; if ($__empty_1): ?>
                <?php endif; ?>
              </div>
            </div>
          </div>

        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Student</button>
      
  </form>
</section>
<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('exams.unity.layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>