<?php $__env->startSection('content'); ?>

<section class="ui raised" style="max-width: 1150px; margin: 20px auto;">
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<div class="print-none">
            <form class="ui form" action="<?php echo e(route('admin.student.verification')); ?>" method="post" enctype="multipart/form-data">
                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
            <h2 class="ui dividing header">Get Registered Students</h2>
            <div class="five fields">
            <div class="field">
                <label>Session</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="session" value="<?php echo e(old('session')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Session</div>
                <div class="menu">
                    <?php for($i = 2010; $i <= (date('Y') + 1) ; $i++): ?>
                    <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
                    <?php endfor; ?>
                </div>
                </div>
            </div>
            <div class="field">
                <label>Term</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="term" value="<?php echo e(old('term')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Term</div>
                <div class="menu">
                    <div class="item" data-value="First"> First Term </div>
                    <div class="item" data-value="Second"> Second Term </div>
                    <div class="item" data-value="Third"> Third Term </div>
                </div>
                </div>
            </div>
            
            <div class="field">
                <label>Class</label>
                <div class="ui fluid search selection dropdown" id="classes-dropdown">
                <input type="hidden" name="class_id" value="<?php echo e(old('class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Class</div>
                <div class="menu">
                    <?php foreach($classes as $class): ?>
                    <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
                    <?php endforeach; ?>
                </div>
                </div>
            </div>
            <div class="field" id="field-arms">
                <label>Class Arm</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="class_arm_id" value="<?php echo e(old('class_arm_id')); ?>">
                <i class="dropdown icon"></i>
                <div class="default text">Class Arm</div>
                <div class="menu" id="class-arms">
                    <?php if(!empty(old('class_id'))): ?>
                        <?php foreach(getClassArms(old('class_id')) as $class_arm): ?>
                        <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="item" data-value="">Select Class Arm</div>
                    <?php endif; ?>
                    
                </div>
                </div>
            </div>

            <div class="field">
                <label>Viw Type</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="view_type">
                <i class="dropdown icon"></i>
                <div class="default text">Select Type</div>
                <div class="menu">
                    <div class="item" data-value="view all">View All</div>
                    <div class="item" data-value="view paginated">View Paginated</div>
                </div>
                </div>
            </div>

            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
            </div>

            </div>
            
            </form>
            <h2 class="ui horizontal divider header" style="color:#dc4900;">
            <i class="student icon"></i>
                Students Information  <div class="ui button blue printBtn">PRINT PAGE <i class="print icon"></i></div>
            </h2>
        </div>
        <div class="ui print-area stackable equal height stackable grid">
            <div class="two column row printGrid">
            <?php if(count($students) > 0): ?>
                <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $students->perPage()  ?>
                <?php foreach($students as $student): ?>
                <div class="column container">
                    <div class="student-card">
                        <div class="ui grid">
                            <div class="row">
                                <div class="four wide column">
                                    <img class="ui fuild image" src="<?php echo e(url_public($student->passport)); ?>" height="100" width="100">
                                </div>
                                <div class="twelve wide column field-line">
                                    <div class="line">
                                        <div class="title">STUDENT OSSI NUMBER:</div>
                                        <div class="underline" style="width: 53%;"><?php echo e($student->regnum); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">NAME:</div>
                                <div class="underline" style="width: 90%;"><?php echo e($student->surname.' '.$student->firstname.' '.$student->middlename); ?></div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height stackable grid">
                            <div class="row">
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">GENDER:</div>
                                        <div class="underline" style="width: 60%;"><?php echo e($student->gender); ?></div>
                                    </div>
                                </div>
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">BLOOD GROUP:</div>
                                        <div class="underline" style="width: 50%;"><?php echo e($student->blood_group); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN NAME:</div>
                                <div class="underline" style="width: 65%;"><?php echo e($student->parent_fullname); ?></div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN PHONE:</div>
                                <div class="underline" style="width: 64%;"><?php echo e($student->parent_phone); ?></div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN ADDRESS:</div>
                                <div class="underline" style="width: 61%;"><?php echo e($student->parent_address); ?></div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height stackable grid">
                            <div class="row">
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">CLASS:</div>
                                        <div class="underline" style="width: 70%;"><?php echo e(App\Classes::find($_POST['class_id'])->class_name); ?></div>
                                    </div>
                                </div>
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">CLASS ARM:</div>
                                        <div class="underline" style="width: 58%;"><?php echo e(App\ClassArms::find($_POST['class_arm_id'])->class_arm); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="ui icon negative message">
                    <i class="info circle icon"></i>
                    <div class="content">
                        <div class="header">
                            Sorry, No Record can be found.
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            </div>
        </div>
	</section>
<style>
.field-line {
    position: relative;
}
.field-line .line{
    width: 100%;
    position: absolute;
    bottom: 20px;
    display: inline-flex;
}
.field-line .line h5{
    margin-top: 30px !important;
    background: red;
}

.field-line .underline{
    border-style: none;
    border-bottom: 1px solid #888 !important;
    margin-left: 5px;
    /* background: #456; */
    color: grey;
    font-size: 14px;
    text-align: center;
    text-transform: uppercase;
    word-spacing: 3px;
}
@media  print {
    .print-none{
        display: none !important;
    }
    .print-area{
        margin-top: 2em;
        /* display: none !important; */
        zoom: 60% !important;
    }
    .student-card{
        zoom: 75%;
    }
}
.student-card{
    clear: both;
    box-shadow: 1px 3px 14px #999;
    border-radius: 3px;
    /* margin: 6px; */
    margin: 2em 0.5em;
    zoom: 85%;
    /* border: 1px solid #333; */
    padding: 5px;
}
/* oludipo.gbolahan@etranzact.com */
/* devops@etranzact.com */
/* technicalsupport@etranzact.com */
</style>
<script>
$(document).ready(function(){
    var printBtn = $('.printBtn');
    printBtn.click(function(){
        setTimeout(() => {
            window.print();
        }, 1000);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>