<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		<?php if(isset($release_lock)): ?>
		  Release Selected Student From
		<?php else: ?>

		  <?php echo e(!isset($edit) ? 'View' : 'Remove Selected Students From'); ?> 
		<?php endif; ?>

		  <?php echo e(getClassNameByClassID($class_id)); ?> <?php echo e(getClassArmNameByClassArmID($classarm_id)); ?> <?php echo e($term); ?> Term <?php echo e($session); ?> / <?php echo e(($session + 1)); ?> Session
		  <?php if(isset($release_lock)): ?>
		  	<br><i style="color:red;font-size: 16px;">Note: Students that are not selected their result will be locked</i>
		  <?php endif; ?>
		</h2>
		<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
	  <form action="<?php echo e(route($route)); ?>" method="post" class="ui form">
	  	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  	<input type="hidden" name="session" value="<?php echo e(!empty(old('session')) ? old('session') : $session); ?>">
	  	<input type="hidden" name="class_id" value="<?php echo e(!empty(old('class_id')) ? old('class_id') : $class_id); ?>">
	  	<input type="hidden" name="classarm_id" value="<?php echo e(!empty(old('classarm_id')) ? old('classarm_id') : $classarm_id); ?>">
	  	<input type="hidden" name="term" value="<?php echo e(!empty(old('term')) ? old('term') : $term); ?>">

	  	<?php if(!isset($edit) && !isset($release_lock)): ?>
		<div class="four fields">
	      <div class="field">
	        <label>Next Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_session" value="<?php echo e(old('next_session')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Session</div>
	          <div class="menu">
	            <?php for($i = $session; $i <= (date('Y') + 1) ; $i++): ?>
	             <div class="item" data-value="<?php echo e($i); ?>"><?php echo e($i); ?>/<?php echo e($i+1); ?></div>
	            <?php endfor; ?>
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Next Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_term" value="<?php echo e(old('next_term')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field">
	        <label>Next Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="next_class_id" value="<?php echo e(old('next_class_id')); ?>" data-href="<?php echo e(url('/do-ajax/class')); ?>" >
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Class</div>
	          <div class="menu">
	            <?php foreach($classes as $class): ?>
	             <div class="item" data-value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></div>
	            <?php endforeach; ?>
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Next Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_classarm_id" value="<?php echo e(old('next_classarm_id')); ?>">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Class Arm</div>
	          <div class="menu" id="class-arms">
	            <?php if(!empty(old('next_class_id'))): ?>
	                <?php foreach(getClassArms(old('next_class_id')) as $class_arm): ?>
	                 <div class="item" data-value="<?php echo e($class_arm->id); ?>"><?php echo e($class_arm->class_arm); ?></div>
	                <?php endforeach; ?>
	              <?php else: ?>
	                 <div class="item" data-value="">Select Class Arm</div>
	              <?php endif; ?>
	            
	          </div>
	        </div>
	      </div>

	    </div>
	    <?php endif; ?>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Passport</div>
		    </th>
		    <th >
		    	<div class="ui ribbon label">Select Students</div>
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($classarm_students) > 0): ?>
		  	<?php foreach($classarm_students as $student): ?>
		    <tr>
		      <td><?php echo e($student->surname.' '.$student->firstname.' '.$student->middlename); ?></td>
		      <td><?php echo e($student->regnum); ?></td>
		      <td><img src="<?php echo e(env('APP_URL').$student->passport); ?>" class="ui image"></td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" value="<?php echo e($student->id); ?>"><label></label>
				</div>
			  </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		</table>
		<?php if(isset($release_lock)): ?>
		<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Release or Lock Selected Student Result</button>
		<?php elseif(!isset($edit)): ?>
		<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Move Students to Next <?php echo e(in_array($term, ['First', 'Second']) == true ? 'Term' : 'Class'); ?></button>
		<?php else: ?>
			<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Remove Selected Students</button>
		<?php endif; ?>
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>