<?php $__env->startSection('content'); ?>
	<section class="ui raised segment" style="max-width: 1024px; margin: 30px auto;">
	<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
			  	<th>
			    	<div class="ui ribbon label">School name</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Logo</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School Address</div>
			    </th>
			    <th>
			    	<div class="ui ribbon label">School LGA</div>
			    </th>
			    <th colspan="2">
			    	<div class="ui ribbon label">Actions on School</div>
			    </th>
			 </tr>
		  </thead>
		  <tbody>
		  <tr>
		  	<th colspan="6"><a href="<?php echo e(route('super_admin.create.school')); ?>" class="ui orange fluid button">Create School</a></th>
		  </tr>
		  <?php if(count($schools) > 0): ?>
		  	<?php foreach($schools as $school): ?>
		    <tr>
		      <td><?php echo e($school->name); ?></td>
		      <td><img src="<?php echo e(url_public($school->logo)); ?>" class="ui fluid image"></td>
		      <td><?php echo e($school->address); ?></td>
		      <td><?php echo e($school->ondo_lga->name); ?></td>
		      <td class="std-view">
			      <button class="ui labeled blue icon button" data-std-id="<?php echo e($school->id); ?>" data-href="<?php echo e(route('super_admin.edit.school', ['id' => $school->id])); ?>">
				  <i class="edit icon"></i>
				  Edit
				</button>
			  </td>
		      <td class="std-view">
				<button class="ui labeled negative icon button" data-std-id="<?php echo e($school->id); ?>" data-href="<?php echo e(route('super_admin.delete.school', ['id' => $school->id])); ?>">
				  <i class="trash icon"></i>
				  Delete
				</button>
		      </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="6">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr><th colspan="6">
		      <?php echo $__env->make('pagination.default', ['paginator' => $schools], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
	<div class="jtr"></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>