<?php $__env->startSection('content'); ?>
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th class="ui huge centered header"> <?php echo e(getClassNameByClassID($class_id).' '.getClassArmNameByClassArmID($classarm_id_get)); ?> <?php echo e($session.'/'.($session + 1)); ?>  <?php echo e($term); ?> Term Results</th>
        </tr>
      </thead>
      <tbody>
      <?php  $counter = 0  ?>
       <?php foreach($students_results_info as $key => $student_results): ?>
        <tr>
          <td>
            <table class="ui unstackable celled table">
              <thead>
                <tr>
                    <th><?php echo e(++$counter); ?></th>
                    <th colspan="<?php echo e(ceil((count($student_results['data']) - 1) / 2)); ?>"><?php echo e(getStudentFullnameByStudentID($key)); ?></th>
                    <th colspan="<?php echo e(floor((count($student_results['data']) - 1) / 2)); ?>"><?php echo e(getRegNumByStudentID($key)); ?></th>
                    <th colspan="2">ACTIONS</th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              <?php if(count($student_results['data']) > 0): ?>           
                  <?php foreach($student_results['data'] as  $student_result): ?>
                    <td>
                       <table class="inner-table">
                         <tr style="padding:0"><td style="padding:0"><?php echo e(getSubjectCodeBySubjectID($student_result->subject_id)); ?></td></tr>
                         <tr><td><?php echo e($student_result->weighted_average); ?></td></tr>
                         <tr><td>
                         <?php if($class_name_char == "J"): ?>
                              <?php echo e(resultGradeJS($student_result->weighted_average)); ?>

                         <?php else: ?>
                              <?php echo e(resultGradeSS($student_result->weighted_average)); ?>

                         <?php endif; ?>
                         </td></tr>
                       </table>
                    </td>
                  <?php endforeach; ?>
                    <td class="std-view"> 
                    <?php if(auth('admin')->user()->can('edit-student-result')): ?>
                      <button class="ui labeled blue icon button" data-std-id="<?php echo e($key); ?>" data-href="<?php echo e(route('admin.edit.student.result', ['id' => $key, 'session' => $session, 'term' => $term, 'class_id' => $class_id, 'classarm_id' => $classarm_id_get])); ?>" data-item="<?php echo e(getStudentFullnameByStudentID($key).'\'s Result'); ?>">
                          <i class="edit icon"></i> Edit
                      </button>
                      <?php endif; ?>
                    </td>
                    <td class="std-view">
                    <?php if(auth('admin')->user()->can('delete-student-result')): ?>
                      <button class="ui labeled negative icon button" data-std-id="<?php echo e($key); ?>" data-href="<?php echo e(route('admin.delete.student.result', ['id' => $key])); ?>" data-item="<?php echo e(getStudentFullnameByStudentID($key).'\'s Result'); ?>">
                          <i class="trash icon"></i> Delete
                      </button>
                      <?php endif; ?>
                    </td>

                <?php else: ?>
                    <td colspan="3">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                <?php endif; ?>
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        <?php endforeach; ?>

      </tbody>
      <tfoot>
          <tr>
          <td style="vertical-align: top;">
            <table style="width: 100%;">
              <tbody>
                 <tr>
                   <td>
                      <table style="width: 100%;">
                        <thead>
                        <tr>
                          <th>
                            SUBJECT CODE
                          </th>
                          <th>
                            SUBJECT
                          </th>
                        </tr>
                        </thead>
                        <tbody>
                          <?php $__empty_1 = true; foreach(getAssocSubjectByClassArmID($classarm_id_get, $session) as $subject): $__empty_1 = false; ?>
                            <tr>
                              <td>
                                <?php echo e($subject->subject_code); ?>

                              </td>
                              <td>
                                <?php echo e($subject->subject_name); ?>

                              </td>
                            </tr>
                          <?php endforeach; if ($__empty_1): ?>

                          <?php endif; ?>
                        </tbody>
                      </table>
                   </td>
                   <td style="vertical-align: top;">
                     <table style="width: 100%">
                          <thead>
                          <tr>
                            <th>
                              SCORE RANGE
                            </th>
                            <th>
                              GRADE
                            </th>
                            <th>
                              REMARKS
                            </th>
                          </tr>
                          </thead>
                          <tbody>                          
                          <?php foreach($listGradeRemark as  $rowGradeRemark): ?>
                              <tr>
                               <td>
                                 <?php echo e($rowGradeRemark['mark']); ?>

                               </td>
                               <td>
                                 <?php echo e($rowGradeRemark['grade']); ?>

                               </td>
                               <td>
                                 <?php echo e($rowGradeRemark['remark']); ?>

                               </td>
                             </tr>
                          <?php endforeach; ?>
                          </tbody>
                      </table>
                   </td>
                 </tr>
              </tbody>
            </table>
          </td>
        </tr>
      </tfoot>
    </table>
</div>
</section>
<div class="jtr"></div>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <input type="hidden" name="_method" value="delete">
        <input type="hidden" name="session" value="<?php echo e($session); ?>">
        <input type="hidden" name="class_id" value="<?php echo e($class_id); ?>">
        <input type="hidden" name="classarm_id" value="<?php echo e($classarm_id_get); ?>">
        <input type="hidden" name="term" value="<?php echo e($term); ?>">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>