<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 1024px; margin: 40px auto;">
<?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <h2 class="ui dividing header" style="color: orange;"><?php echo e($title); ?></h2>
	<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Current School</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School to be Transfer</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student OSSIN</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Debtor Status</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student Transfer Reason</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Actions on Transfer</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  <?php if(count($transfers) > 0): ?>
		  <?php  $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $transfers->perPage()  ?>
		  	<?php foreach($transfers as $transfer): ?>
		    <tr>
		      <td><?php echo e(++$counter); ?></td>
		      <td><?php echo e($transfer->formerSchool->name); ?></td>
		      <td><?php echo e($transfer->newSchool->name); ?></td>
		      <td><?php echo e(trim($transfer->studentBeforeTransfer->surname.' '.$transfer->studentBeforeTransfer->firstname.' '.$transfer->studentBeforeTransfer->middlename)); ?></td>
		      <td><?php echo e($transfer->studentBeforeTransfer->regnum); ?></td>
		      <td><?php echo ($transfer->debtor()->count()  > 0 && $transfer->status == 0) ? '<span style="color:red;">'.$transfer->debtor->issue.'</span>' : 'Student does not have any debt'; ?></td>
		      <td>
		      	<?php echo e($transfer->reason_for_transfer); ?>

		      </td>
		      <td class="std-view">
		      <?php if($transfer->former_school_status == 0): ?>
			     <button class="ui labeled blue icon button" data-item="Are you sure want to Grant the Transfer?" data-messages="Are you sure you want to grant the transfer" data-href="<?php echo e(route('admin.grant.transfer', ['id' => $transfer->id])); ?>">
					  <i class="edit icon"></i>
					  Grant Transfer
				</button>
			  <?php else: ?>
				  <?php if($transfer->new_school_status == 0 && ($transfer->student_new_school == auth('admin')->user()->school_id)): ?>
				    <button class="ui labeled blue icon button" data-item="Are you sure want to Accept the Transfer?" data-messages="Are you sure you want to accept the transfer" data-href="<?php echo e(route('admin.accept.transfer', ['id' => $transfer->id])); ?>">
						  <i class="edit icon"></i>
						  Accept Transfer
					</button>
				  <?php else: ?>
				  	<a class="ui labeled orange icon button" href="<?php echo e(route('admin.view.transfer', ['id' => $transfer->id])); ?>">
						  View Transfer Letter
					</a>
				  <?php endif; ?>
			  <?php endif; ?>
			  </td>
		    </tr>
		   <?php endforeach; ?>
		    <?php else: ?>
			<tr>
				<th colspan="8">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  <?php endif; ?>
		  </tbody>
		  <tfoot>
		    <tr>
			    <th colspan="8">
			      <?php echo $__env->make('pagination.default', ['paginator' => $transfers], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
			    </th>
			</tr>
		  </tfoot>
		</table>

<div class="ui modal generate" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>