<?php $__env->startSection('content'); ?>
<section class="ui middle aligned center aligned grid">
  <div class="column" style="max-width: 450px;">
  <?php echo $__env->make('partial.error', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <h2 class="ui orange image header">
      <img src="<?php echo e(url_public('/images/header-logo.png')); ?>" class="image">
      <div class="content">
        Common Entrance Examination Login
      </div>
    </h2>
    <form class="ui large form"  <?php if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card')))): ?> action="<?php echo e(route('exam.entrance.login.card')); ?>" <?php else: ?> action="<?php echo e(route('exam.entrance.login.exam.number')); ?>" <?php endif; ?> method="post">
    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
      <div class="ui stacked segment">
      <?php if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card')))): ?>
        <input type="hidden" name="login_type" value="card">
        <input type="hidden" name="exam_type" value="entrance_exam">
        <div class="field states">
            <label>State</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" <?php if(!empty(old('state_id'))): ?>
                  value="<?php echo e(old('state_id')); ?>"
                <?php else: ?>
                  value="<?php echo e($ngstate->id); ?>"
                <?php endif; ?>>
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                 <div class="item" data-value="<?php echo e($ngstate->id); ?>"><?php echo e($ngstate->name); ?></div>
              </div>
            </div>
          </div>

          <div class="field" id="field-lga">
            <label>Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="<?php echo e(old('lga_id')); ?>" data-href="<?php echo e(url('/do-ajax/primary-school')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Local Govt. Area</div>
              <div class="menu" id="state-lga">
                <?php foreach($ngstate->ondo_lga as $ngstateLGA): ?>
                 <div class="item" data-value="<?php echo e($ngstateLGA->id); ?>"><?php echo e($ngstateLGA->name); ?></div>
                <?php endforeach; ?>
              </div>
            </div>
          </div>

          <div class="field" id="field-school">
            <label>School</label>
            <div class="ui fluid search selection dropdown" id="wrap-schools">
              <input type="hidden" name="school" value="<?php echo e(old('school')); ?>">
              <i class="dropdown icon"></i>
              <div class="default text">Schools</div>
              <div class="menu" id="school-options-handler">
                <?php if(!empty(old('school'))): ?>
                    <?php foreach(getSchools(old('school')) as $school): ?>
                     <div class="item" data-value="<?php echo e($school->id); ?>"><?php echo e($school->name); ?></div>
                    <?php endforeach; ?>
                  <?php else: ?>
                     <div class="item" data-value="">Schools</div>
                  <?php endif; ?>
              </div>
            </div>
          </div> 
        <div class="field">
            <label>Serial Number</label>
            <input type="text" name="serial_no" value="<?php echo e(old('serial_no')); ?>" placeholder="Enter Serial Number">
        </div>
        <div class="field">
            <label>PIN</label>
            <input type="password" name="pin" placeholder="Enter PIN" value="<?php echo e(old('pin')); ?>">
        </div>
      <?php else: ?>
        <input type="hidden" name="login_type" value="email">
        <div class="field">
            <label>School Email Address</label>
            <input type="text" name="email" value="<?php echo e(old('email')); ?>" placeholder="Enter Examination Number">
        </div>
        <div class="field">
            <label>Password</label>
            <input type="password" name="password" placeholder="Enter Password" value="<?php echo e(old('password')); ?>">
        </div>
      <?php endif; ?>
        <button class="ui fluid large orange submit button" type="submit">Common Entrance Examination Login</button>
      <?php if(Request::is(str_replace(explode('public',env('APP_URL'))[0], '',route('exam.entrance.login.card')))): ?>
          <div class="ui message">
            <a href="<?php echo e(route('exam.entrance.login.exam.number')); ?>">Login with your Examination Number and Password</a>
          </div>
      <?php else: ?>
          <div class="ui message">
            <a href="<?php echo e(route('exam.entrance.login.card')); ?>"> Login with your Card PIN and Serial Number</a>
          </div>
      <?php endif; ?>
      </div>
    </form>
  </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>