<?php $__env->startSection('content'); ?>
<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">
    <h2 class="ui dividing header text_center"> <?php echo $title; ?> </h2>
    <div class="ui grid">
        <div class="four wide column">
            <div class="ui vertical fluid tabular menu">
            <a href="<?php echo e(url('ministry/school-statistics')); ?>" class="item <?php if(!isset($_GET['action']) || $_GET['action'] == ''): ?> active <?php endif; ?>">
                View live
            </a>
            <a href="<?php echo e(url('ministry/school-statistics?action=view_all')); ?>" class="item <?php if(isset($_GET['action']) && $_GET['action'] == 'view_all'): ?> active <?php endif; ?>">
                View all
            </a>
            <a class="item <?php if(isset($_GET['action']) && $_GET['action'] == 'view_lga'): ?> active <?php endif; ?>">
                <form class="ui left action input">
                    <input type="hidden" name="action" value="view_lga">
                    <button class="ui button">LGA:</button>
                    <select name="value" class="ui fluid search dropdown">
                        <option value="">Choose LGA</option>
                        <?php if($item_rows = DB::table('ondo_lgas')->where('state_id', 28)->get()): ?>
                            <?php foreach($item_rows as $item_data): ?>
                            <option <?php if(isset($_GET['value']) && $_GET['value'] == $item_data->id){ echo 'selected'; } ?> value="<?php echo e($item_data->id); ?>"><?php echo e($item_data->name); ?></option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </form>
            </a>
            </div>
        </div>
        <div class="twelve wide stretched column">
            <div class="ui segment">
                <?php if(isset($_GET['action']) && $_GET['action'] == 'view_all'): ?>
                <div class="c8">
                    <img class="ui fuild image" src="<?php echo e(url_public('/images/ill-stats.png')); ?>" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(count($schools) > 0): ?>
                        <?php foreach($schools as $school): ?>
                        <tr>
                        <td><?php echo e($school->name); ?></td>
                        <td><img src="<?php echo e(url_public($school->logo)); ?>" class="ui fluid image"></td>
                        <td><?php echo e($school->ondo_lga->name); ?></td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="<?php echo e($school->name); ?>" school-id="<?php echo e($school->id); ?>">
                            <i class="edit icon"></i>
                            View School Statistics
                            </button>
                        </td>
                        </tr>
                    <?php endforeach; ?>
                        <?php else: ?>
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        <?php echo $__env->make('pagination.default', ['paginator' => $schools], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                <?php elseif(isset($_GET['action']) && $_GET['action'] == 'view_lga'): ?>
                <div class="c8">
                    <div class="wallpaper">
                        <img class="" src="<?php echo e(url_public('/images/ill-stats.png')); ?>">
                        <h1><?php echo e($lga_name); ?></h1>
                    </div>
                    <div class="main">
                        <table class="ui celled table">
                            <thead>
                                <tr>
                                    <th>
                                        <div class="ui ribbon label">School name</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School Logo</div>
                                    </th>
                                    <th>
                                        <div class="ui ribbon label">School LGA</div>
                                    </th>
                                    <th colspan="2">
                                        <div class="ui ribbon label">Actions on School</div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if(count($schools) > 0): ?>
                                <?php foreach($schools as $school): ?>
                                <tr>
                                <td><?php echo e($school->name); ?></td>
                                <td><img src="<?php echo e(url_public($school->logo)); ?>" class="ui fluid image"></td>
                                <td><?php echo e($school->ondo_lga->name); ?></td>
                                <td class="std-view" width="250">
                                    <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="<?php echo e($school->name); ?>" school-id="<?php echo e($school->id); ?>">
                                    <i class="edit icon"></i>
                                    View School Statistics
                                    </button>
                                </td>
                                </tr>
                            <?php endforeach; ?>
                                <?php else: ?>
                                <tr>
                                    <th colspan="6">
                                        <div class="ui icon negative message">
                                        <i class="info circle icon"></i>
                                        <div class="content">
                                            <div class="header">
                                            Sorry, No Record can be found.
                                            </div>
                                        </div>
                                        </div>
                                    </th>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr><th colspan="6">
                                <?php echo $__env->make('pagination.default', ['paginator' => $schools], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                </th>
                            </tr></tfoot>
                        </table>
                    </div>
                </div>
                <?php else: ?>
                <div class="c8">
                    <img class="ui fuild image" src="<?php echo e(url_public('/images/ill-stats.png')); ?>" style="width:100%" height="250">
                    <table class="ui celled table">
                    <thead>
                        <tr>
                            <th>
                                <div class="ui ribbon label">School name</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School Logo</div>
                            </th>
                            <th>
                                <div class="ui ribbon label">School LGA</div>
                            </th>
                            <th colspan="2">
                                <div class="ui ribbon label">Actions on School</div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(count($schools) > 0): ?>
                        <?php foreach($schools as $school): ?>
                        <tr>
                        <td><?php echo e($school->name); ?></td>
                        <td><img src="<?php echo e(url_public($school->logo)); ?>" class="ui fluid image"></td>
                        <td><?php echo e($school->ondo_lga->name); ?></td>
                        <td class="std-view" width="250">
                            <button style="background: #3caeb7;color: #fff;"  class="ui labeled icon button showStatsBtn" school-name="<?php echo e($school->name); ?>" school-id="<?php echo e($school->id); ?>">
                            <i class="edit icon"></i>
                            View School Statistics
                            </button>
                        </td>
                        </tr>
                    <?php endforeach; ?>
                        <?php else: ?>
                        <tr>
                            <th colspan="6">
                                <div class="ui icon negative message">
                                <i class="info circle icon"></i>
                                <div class="content">
                                    <div class="header">
                                    Sorry, No Record can be found.
                                    </div>
                                </div>
                                </div>
                            </th>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                    <tfoot>
                        <tr><th colspan="6">
                        <?php echo $__env->make('pagination.default', ['paginator' => $schools], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </th>
                    </tr></tfoot>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
	
    
<!-- modals -->
<form class="ui long modal">
    <!-- <i class="close icon"></i> -->
    <div class="header">
    </div>
    <div class="image content" style="height: 70vh;">
    <div class="image loading">
        loading statistics
    </div>
    <div class="description ui grid">
        <div class="five wide column field loading" style="margin-left: 10px;margin-top: 10px;"></div>
        <div class="stats hard-center" style="display: none;">
        <div class="ui statistics">
            <div class="statistic">
                <div class="value teacher_count">
                0
                </div>
                <div class="label">
                Teachers
                </div>
            </div>
            <div class="statistic">
                <div class="value student_count">
                0
                </div>
                <div class="label">
                Students
                </div>
            </div>
            <div class="statistic">
                <div class="value admin_count">
                0
                </div>
                <div class="label">
                Admins
                </div>
            </div>
        </div>

        <div class="ui stackable equal height stackable grid">
            <div class="row">
                <div class="eight wide column field-line">
                    <div class="ui list">
                        <div class="item">
                            <i class="users icon"></i>
                            <div class="content account">
                            </div>
                        </div>
                        <div class="item">
                            <i class="marker icon"></i>
                            <div class="content location">
                            </div>
                        </div>
                        <div class="item">
                            <i class="clock icon"></i>
                            <div class="content created_at">
                            </div>
                        </div>
                        <div class="item">
                            <i class="linkify icon"></i>
                            <div class="content category">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="eight wide column field-line">                   
                    <div class="ui stackable equal height stackable grid">
                        <div class="eight wide column">
                            <div class="ui special cards">
                            <div class="card">
                                <div class="image" style="padding: 5px;">
                                <img src="<?php echo e(url_public('/images/boys.png')); ?>">
                                </div>
                                <div class="content">
                                <!-- <a class="header">Students</a> -->
                                <div class="meta">
                                    <span class="date">Male Count</span>
                                </div>
                                </div>
                                <div class="extra content">
                                <a>
                                    <i class="users icon"></i>
                                    <span class="male_count">0</span> Males
                                </a>
                                </div>
                            </div>
                            </div>
                        </div>

                        <div class="eight wide column">
                            <div class="ui special cards">
                            <div class="card">
                                <div class="image" style="padding: 5px;">
                                <img src="<?php echo e(url_public('/images/girls.png')); ?>">
                                </div>
                                <div class="content">
                                <!-- <a class="header">Students</a> -->
                                <div class="meta">
                                    <span class="date">Female Count</span>
                                </div>
                                </div>
                                <div class="extra content">
                                <a>
                                    <i class="users icon"></i>
                                    <span class="female_count">0</span> Females
                                </a>
                                </div>
                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
    </div>
    <div class="actions">
    <div class="ui cancel button">Cancel</div>
    </div>
</form>
<div class="jtr"></div>
<script type="text/javascript">
	$(document).ready(function(){
        $('.showStatsBtn').click(function(){
        	var modal = $('.ui.modal');
        	var name = $(this).attr('school-name');
        	var id = $(this).attr('school-id');
        	modal.find('.header').html(name.toUpperCase()+"'s  Statistics");
            modal.find('.image.loading').fadeIn('slow');
        	modal.find('.loading').fadeIn('slow');
            $('.stats').fadeOut('slow');
	        modal.modal({
		    closable  : false,
		    centered: false,
		    onDeny : function() {
				modal.find('.approve').fadeOut('fast');
		    },
		    onApprove : function() {
		    	$(this).submit();
		    }
		  }).modal('show');
	        //get permissions with ajax
	        var token = "<?php echo e(csrf_token()); ?>";
	        var route = "<?php echo e(route('super_admin.school.view.statistics')); ?>";
	        $.ajax({
	        	url: route,
	        	type: 'POST',
	        	data: {school_id: id, _token: token},
	        	success: function(response){
					// alert(response);
                    modal.find('.image.loading').fadeOut('slow');
                    modal.find('.loading').fadeOut('slow');
                    $.each(response, function(index, value){
                        // alert(value.teacher_count)
                        $('.stats .teacher_count').html(value.teacher_count);
                        $('.stats .student_count').html(value.student_count);
                        $('.stats .admin_count').html(value.admin_count);
                        $('.stats .male_count').html(value.male_count);
                        $('.stats .female_count').html(value.female_count);
                        $('.stats .account').html(value.account);
                        $('.stats .location').html(value.location);
                        $('.stats .created_at').html(value.created_at);
                        $('.stats .category').html(value.category);
                        $('.stats').fadeIn('slow');
                    });
	        	},
	        	error: function(error){
	        		console.log(error);
	        		$('.msg-bag').html(error('Something went wrong'));
	        		msgClose();
					modal.find('.approve').fadeOut('fast');
	        	}
	        });
	    });
	});
</script>
<style>
.wallpaper{
    position: relative;
    height: 250px;
    width: 100%;
    background: red;
}
.wallpaper img{
    position: absolute;
    width: 100%;
    height: 100%;
    filter: brightness(0.4);
}
.wallpaper h1{
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #fff;
    font-size: 3em;
    text-transform: uppercase;
    text-align: center;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>